/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.pdf.PRStream;
import clover.com.lowagie.text.pdf.PdfArray;
import clover.com.lowagie.text.pdf.PdfDictionary;
import clover.com.lowagie.text.pdf.PdfImportedPage;
import clover.com.lowagie.text.pdf.PdfLiteral;
import clover.com.lowagie.text.pdf.PdfName;
import clover.com.lowagie.text.pdf.PdfNumber;
import clover.com.lowagie.text.pdf.PdfObject;
import clover.com.lowagie.text.pdf.PdfReader;
import clover.com.lowagie.text.pdf.PdfRectangle;
import clover.com.lowagie.text.pdf.PdfStream;
import clover.com.lowagie.text.pdf.PdfTemplate;
import clover.com.lowagie.text.pdf.PdfWriter;
import clover.com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class PdfReaderInstance {
    static final PdfLiteral IDENTITYMATRIX = new PdfLiteral("[1 0 0 1 0 0]");
    static final PdfNumber ONE = new PdfNumber(1);
    PdfObject[] xrefObj;
    PdfDictionary[] pages;
    int[] myXref;
    PdfReader reader;
    RandomAccessFileOrArray file;
    HashMap importedPages = new HashMap();
    PdfWriter writer;
    HashMap visited = new HashMap();
    ArrayList nextRound = new ArrayList();

    PdfReaderInstance(PdfReader pdfReader, PdfWriter pdfWriter, PdfObject[] pdfObjectArray, PdfDictionary[] pdfDictionaryArray) {
        this.reader = pdfReader;
        this.xrefObj = pdfObjectArray;
        this.pages = pdfDictionaryArray;
        this.writer = pdfWriter;
        this.file = pdfReader.getSafeFile();
        this.myXref = new int[pdfObjectArray.length];
    }

    PdfReader getReader() {
        return this.reader;
    }

    PdfImportedPage getImportedPage(int n) {
        if (n < 1 || n > this.pages.length) {
            throw new IllegalArgumentException("Invalid page number");
        }
        Integer n2 = new Integer(n);
        PdfImportedPage pdfImportedPage = (PdfImportedPage)this.importedPages.get(n2);
        if (pdfImportedPage == null) {
            pdfImportedPage = new PdfImportedPage(this, this.writer, n);
            this.importedPages.put(n2, pdfImportedPage);
        }
        return pdfImportedPage;
    }

    int getNewObjectNumber(int n, int n2) {
        if (this.myXref[n] == 0) {
            this.myXref[n] = this.writer.getIndirectReferenceNumber();
            this.nextRound.add(new Integer(n));
        }
        return this.myXref[n];
    }

    RandomAccessFileOrArray getReaderFile() {
        return this.file;
    }

    PdfObject getResources(int n) {
        return this.reader.getPdfObject(this.pages[n - 1].get(PdfName.RESOURCES));
    }

    public byte[] getStreamBytes(PRStream pRStream) throws IOException {
        PdfObject pdfObject = pRStream.get(PdfName.FILTER);
        byte[] byArray = new byte[pRStream.getLength()];
        this.file.seek(pRStream.getOffset());
        this.file.readFully(byArray);
        ArrayList arrayList = new ArrayList();
        if (pdfObject != null) {
            if (pdfObject.type() == 4) {
                arrayList.add(pdfObject);
            } else if (pdfObject.type() == 5) {
                arrayList = ((PdfArray)pdfObject).getArrayList();
            }
        }
        int n = 0;
        while (n < arrayList.size()) {
            String string = ((PdfName)arrayList.get(n)).toString();
            if (string.equals("/FlateDecode") || string.equals("/Fl")) {
                byArray = PdfReader.FlateDecode(byArray);
            } else if (string.equals("/ASCIIHexDecode") || string.equals("/AHx")) {
                byArray = PdfReader.ASCIIHexDecode(byArray);
            } else if (string.equals("/ASCII85Decode") || string.equals("/A85")) {
                byArray = PdfReader.ASCII85Decode(byArray);
            } else if (string.equals("/LZWDecode")) {
                byArray = PdfReader.LZWDecode(byArray);
            } else {
                throw new IOException("The filter " + string + " is not supported.");
            }
            ++n;
        }
        return byArray;
    }

    PdfStream getFormXObject(int n) throws IOException {
        PRStream pRStream;
        Object object;
        Object object2;
        PdfDictionary pdfDictionary = this.pages[n - 1];
        PdfObject pdfObject = this.reader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS));
        int n2 = 0;
        int n3 = 0;
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        ByteArrayOutputStream byteArrayOutputStream = null;
        Object var8_8 = null;
        if (pdfObject != null) {
            if (pdfObject.type() == 7) {
                object2 = (PRStream)pdfObject;
                n2 = ((PRStream)object2).getLength();
                n3 = ((PRStream)object2).getOffset();
                pdfDictionary2.putAll((PdfDictionary)object2);
            } else {
                object2 = (PdfArray)pdfObject;
                object = ((PdfArray)object2).getArrayList();
                byteArrayOutputStream = new ByteArrayOutputStream();
                int n4 = 0;
                while (n4 < ((ArrayList)object).size()) {
                    PRStream pRStream2 = (PRStream)this.reader.getPdfObject((PdfObject)((ArrayList)object).get(n4));
                    byte[] byArray = this.getStreamBytes(pRStream2);
                    byteArrayOutputStream.write(byArray);
                    if (n4 != ((ArrayList)object).size() - 1) {
                        byteArrayOutputStream.write(10);
                    }
                    ++n4;
                }
            }
        }
        pdfDictionary2.put(PdfName.RESOURCES, this.reader.getPdfObject(pdfDictionary.get(PdfName.RESOURCES)));
        pdfDictionary2.put(PdfName.TYPE, PdfName.XOBJECT);
        pdfDictionary2.put(PdfName.SUBTYPE, PdfName.FORM);
        object2 = (PdfImportedPage)this.importedPages.get(new Integer(n));
        pdfDictionary2.put(PdfName.BBOX, new PdfRectangle(((PdfTemplate)object2).getBoundingBox()));
        object = ((PdfTemplate)object2).getMatrix();
        if (object == null) {
            pdfDictionary2.put(PdfName.MATRIX, IDENTITYMATRIX);
        } else {
            pdfDictionary2.put(PdfName.MATRIX, (PdfObject)object);
        }
        pdfDictionary2.put(PdfName.FORMTYPE, ONE);
        if (byteArrayOutputStream == null) {
            pRStream = new PRStream(this.reader, n3);
            pRStream.putAll(pdfDictionary2);
            pRStream.setLength(n2);
        } else {
            pRStream = new PRStream(this.reader, byteArrayOutputStream.toByteArray());
            pRStream.putAll(pdfDictionary2);
        }
        return pRStream;
    }

    void writeAllVisited() throws IOException {
        while (this.nextRound.size() > 0) {
            ArrayList arrayList = this.nextRound;
            this.nextRound = new ArrayList();
            int n = 0;
            while (n < arrayList.size()) {
                Integer n2 = (Integer)arrayList.get(n);
                if (!this.visited.containsKey(n2)) {
                    this.visited.put(n2, null);
                    int n3 = n2;
                    this.writer.addToBody(this.xrefObj[n3], this.myXref[n3]);
                }
                ++n;
            }
        }
    }

    void writeAllPages() throws IOException {
        try {
            this.file.reOpen();
            Iterator iterator = this.importedPages.values().iterator();
            while (iterator.hasNext()) {
                PdfImportedPage pdfImportedPage = (PdfImportedPage)iterator.next();
                this.writer.addToBody((PdfObject)pdfImportedPage.getFormXObject(), pdfImportedPage.getIndirectReference());
            }
            this.writeAllVisited();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.file.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.file.close();
        }
        catch (Exception exception) {}
    }
}

