/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.pdf.PdfContentByte;
import clover.com.lowagie.text.pdf.PdfEncodings;
import clover.com.lowagie.text.pdf.PdfEncryption;
import clover.com.lowagie.text.pdf.PdfObject;
import clover.com.lowagie.text.pdf.PdfWriter;

public class PdfString
extends PdfObject {
    protected String value = "";
    protected String encoding = "PDF";

    public PdfString() {
        super(3);
    }

    public PdfString(String string) {
        super(3);
        this.value = string;
    }

    public PdfString(String string, String string2) {
        super(3);
        this.value = string;
        this.encoding = string2;
    }

    public PdfString(byte[] byArray) {
        super(3);
        this.value = PdfEncodings.convertToString(byArray, null);
        this.encoding = "";
    }

    public byte[] toPdf(PdfWriter pdfWriter) {
        byte[] byArray = PdfEncodings.convertToBytes(this.value, this.encoding);
        PdfEncryption pdfEncryption = pdfWriter.getEncryption();
        if (pdfEncryption != null) {
            pdfEncryption.prepareKey();
            pdfEncryption.encryptRC4(byArray);
        }
        return PdfContentByte.escapeString(byArray);
    }

    public String toString() {
        return this.value;
    }

    byte[] get(PdfWriter pdfWriter) {
        return this.toPdf(pdfWriter);
    }

    public String getEncoding() {
        return this.encoding;
    }
}

