/*
 * Decompiled with CFR 0.152.
 */
package clover.gnu.cajo.utils.extra;

import clover.gnu.cajo.invoke.Remote;
import clover.gnu.cajo.invoke.RemoteInvoke;
import clover.gnu.cajo.utils.ItemServer;
import clover.gnu.cajo.utils.Multicast;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Registry {
    private final Hashtable entries = new Hashtable();

    public void multicast(Multicast multicast) {
        this.entries.put(multicast.iaddr.getHostAddress(), multicast.item);
    }

    public void post(RemoteInvoke remoteInvoke) throws ServerNotActiveException {
        this.entries.put(RemoteServer.getClientHost(), remoteInvoke);
    }

    public Hashtable get() {
        return this.entries;
    }

    public String getDescription() {
        return "Welcome to the cajo item registry!\n\nThere are two ways to register a remote item reference:\n\n\tFirst, Multicast hailing frequency announcements are\n\tautomatically registered.\n\n\tSecond, invocations of the 'post' method, with a remote\n\treference are also registered.\n\nAll currently registered references can be requested via the\n'get' method. It takes no arguments, and returns a\njava.util.Hashtable containing the registered remote item\nreferences, keyed by their server addresses. Additionally, it\nautomatically purges inactive references periodically.\n\nEnjoy!";
    }

    public static void main(String[] stringArray) {
        try {
            Remote.config(null, 1099, stringArray.length > 0 ? stringArray[0] : null, 0);
            Registry registry = new Registry();
            Remote remote = new Remote(registry);
            Multicast multicast = new Multicast();
            ItemServer.bind(remote, "registry");
            multicast.listen(registry);
            Thread.currentThread().setPriority(1);
            block4: while (true) {
                multicast.announce(remote, 200);
                Thread.sleep(3600000L);
                Enumeration enumeration = registry.entries.keys();
                while (true) {
                    if (!enumeration.hasMoreElements()) continue block4;
                    Object k = enumeration.nextElement();
                    Object v = registry.entries.get(k);
                    try {
                        Remote.invoke(v, "toString", null);
                    }
                    catch (Exception exception) {
                        registry.entries.remove(k);
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

