/*
 * Decompiled with CFR 0.152.
 */
package clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent;

import [Ljava.lang.Object;;
import clover.retrotranslator.edu.emory.mathcs.backport.java.util.Arrays;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class CopyOnWriteArrayList
implements List,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    private volatile transient Object[] array;

    public CopyOnWriteArrayList() {
        this.setArray(new Object[0]);
    }

    public CopyOnWriteArrayList(Collection c) {
        Object[] array = c.toArray();
        if (array.getClass() != Object;.class) {
            array = Arrays.copyOf(array, array.length, Object;.class);
        }
        this.setArray(array);
    }

    public CopyOnWriteArrayList(Object[] array) {
        this.setArray(Arrays.copyOf(array, array.length, Object;.class));
    }

    final Object[] getArray() {
        return this.array;
    }

    final void setArray(Object[] array) {
        this.array = array;
    }

    public int size() {
        return this.getArray().length;
    }

    public boolean isEmpty() {
        return this.getArray().length == 0;
    }

    private static int search(Object[] array, Object subject, int pos, int end) {
        if (subject == null) {
            while (pos < end) {
                if (array[pos] == null) {
                    return pos;
                }
                ++pos;
            }
        } else {
            while (pos < end) {
                if (subject.equals(array[pos])) {
                    return pos;
                }
                ++pos;
            }
        }
        return -1;
    }

    private static int reverseSearch(Object[] array, Object subject, int start, int pos) {
        if (subject == null) {
            --pos;
            while (pos >= start) {
                if (array[pos] == null) {
                    return pos;
                }
                --pos;
            }
        } else {
            --pos;
            while (pos >= start) {
                if (subject.equals(array[pos])) {
                    return pos;
                }
                --pos;
            }
        }
        return -1;
    }

    public boolean contains(Object o) {
        Object[] array = this.getArray();
        return CopyOnWriteArrayList.search(array, o, 0, array.length) >= 0;
    }

    public Iterator iterator() {
        return new COWIterator(this.getArray(), 0);
    }

    public Object[] toArray() {
        Object[] array = this.getArray();
        return Arrays.copyOf(array, array.length, Object;.class);
    }

    public Object[] toArray(Object[] a) {
        Object[] array = this.getArray();
        int length = array.length;
        if (a.length < length) {
            return Arrays.copyOf(array, length, a.getClass());
        }
        System.arraycopy(array, 0, a, 0, length);
        if (a.length > length) {
            a[length] = null;
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] oldarr = this.getArray();
            int length = oldarr.length;
            Object[] newarr = new Object[length + 1];
            System.arraycopy(oldarr, 0, newarr, 0, length);
            newarr[length] = o;
            this.setArray(newarr);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIfAbsent(Object o) {
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] oldarr = this.getArray();
            int length = oldarr.length;
            if (CopyOnWriteArrayList.search(this.array, o, 0, length) >= 0) {
                return false;
            }
            Object[] newarr = new Object[length + 1];
            System.arraycopy(oldarr, 0, newarr, 0, length);
            newarr[length] = o;
            this.setArray(newarr);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAllAbsent(Collection c) {
        Object[] arr = c.toArray();
        if (arr.length == 0) {
            return 0;
        }
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] oldarr = this.getArray();
            int oldlength = oldarr.length;
            Object[] tmp = new Object[arr.length];
            int added = 0;
            for (int i = 0; i < arr.length; ++i) {
                Object o = arr[i];
                if (CopyOnWriteArrayList.search(oldarr, o, 0, oldlength) >= 0 || CopyOnWriteArrayList.search(tmp, o, 0, added) >= 0) continue;
                tmp[added++] = o;
            }
            if (added == 0) {
                return 0;
            }
            Object[] newarr = new Object[oldlength + added];
            System.arraycopy(oldarr, 0, newarr, 0, oldlength);
            System.arraycopy(tmp, 0, newarr, oldlength, added);
            this.setArray(newarr);
            return added;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] array = this.getArray();
            int length = array.length;
            int pos = CopyOnWriteArrayList.search(array, o, 0, length);
            if (pos < 0) {
                return false;
            }
            Object[] newarr = new Object[length - 1];
            int moved = length - pos - 1;
            if (pos > 0) {
                System.arraycopy(array, 0, newarr, 0, pos);
            }
            if (moved > 0) {
                System.arraycopy(array, pos + 1, newarr, pos, moved);
            }
            this.setArray(newarr);
            return true;
        }
    }

    public boolean containsAll(Collection c) {
        Object[] array = this.getArray();
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            if (CopyOnWriteArrayList.search(array, itr.next(), 0, array.length) >= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c) {
        Object[] ca = c.toArray();
        if (ca.length == 0) {
            return false;
        }
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] oldarr = this.getArray();
            int length = oldarr.length;
            Object[] newarr = new Object[length + ca.length];
            System.arraycopy(oldarr, 0, newarr, 0, length);
            int pos = length;
            System.arraycopy(ca, 0, newarr, pos, ca.length);
            this.setArray(newarr);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection c) {
        Object[] ca = c.toArray();
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] oldarr = this.getArray();
            int length = oldarr.length;
            if (index < 0 || index > length) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + length);
            }
            if (ca.length == 0) {
                return false;
            }
            Object[] newarr = new Object[length + ca.length];
            int moved = length - index;
            System.arraycopy(oldarr, 0, newarr, 0, index);
            int pos = length;
            System.arraycopy(ca, 0, newarr, index, ca.length);
            if (moved > 0) {
                System.arraycopy(oldarr, index, newarr, index + ca.length, moved);
            }
            this.setArray(newarr);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection c) {
        if (c.isEmpty()) {
            return false;
        }
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] array = this.getArray();
            int length = array.length;
            Object[] tmp = new Object[length];
            int newlen = 0;
            for (int i = 0; i < length; ++i) {
                Object o = array[i];
                if (c.contains(o)) continue;
                tmp[newlen++] = o;
            }
            if (newlen == length) {
                return false;
            }
            Object[] newarr = new Object[newlen];
            System.arraycopy(tmp, 0, newarr, 0, newlen);
            this.setArray(newarr);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection c) {
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] array = this.getArray();
            int length = array.length;
            Object[] tmp = new Object[length];
            int newlen = 0;
            for (int i = 0; i < length; ++i) {
                Object o = array[i];
                if (!c.contains(o)) continue;
                tmp[newlen++] = o;
            }
            if (newlen == length) {
                return false;
            }
            Object[] newarr = new Object[newlen];
            System.arraycopy(tmp, 0, newarr, 0, newlen);
            this.setArray(newarr);
            return true;
        }
    }

    public void clear() {
        this.setArray(new Object[0]);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        ListIterator itr = ((List)o).listIterator();
        Object[] array = this.getArray();
        int length = array.length;
        int idx = 0;
        while (idx < length && itr.hasNext()) {
            Object o1;
            Object o2 = itr.next();
            if (CopyOnWriteArrayList.eq(o1 = array[idx++], o2)) continue;
            return false;
        }
        return idx == length && !itr.hasNext();
    }

    public int hashCode() {
        int hashCode = 1;
        Object[] array = this.getArray();
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            Object o = array[i];
            hashCode = 31 * hashCode + (o == null ? 0 : o.hashCode());
        }
        return hashCode;
    }

    public Object get(int index) {
        return this.getArray()[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int index, Object element) {
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] oldarr = this.getArray();
            int length = oldarr.length;
            Object oldVal = oldarr[index];
            if (oldVal == element) {
                this.setArray(oldarr);
            } else {
                Object[] newarr = new Object[length];
                System.arraycopy(oldarr, 0, newarr, 0, length);
                newarr[index] = element;
                this.setArray(newarr);
            }
            return oldVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Object element) {
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] oldarr = this.getArray();
            int length = oldarr.length;
            if (index < 0 || index > length) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + length);
            }
            Object[] newarr = new Object[length + 1];
            int moved = length - index;
            System.arraycopy(oldarr, 0, newarr, 0, index);
            newarr[index] = element;
            if (moved > 0) {
                System.arraycopy(oldarr, index, newarr, index + 1, moved);
            }
            this.setArray(newarr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        CopyOnWriteArrayList copyOnWriteArrayList = this;
        synchronized (copyOnWriteArrayList) {
            Object[] array = this.getArray();
            int length = array.length;
            if (index < 0 || index >= length) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + length);
            }
            Object result = array[index];
            Object[] newarr = new Object[length - 1];
            int moved = length - index - 1;
            if (index > 0) {
                System.arraycopy(array, 0, newarr, 0, index);
            }
            if (moved > 0) {
                System.arraycopy(array, index + 1, newarr, index, moved);
            }
            this.setArray(newarr);
            return result;
        }
    }

    public int indexOf(Object o) {
        Object[] array = this.getArray();
        return CopyOnWriteArrayList.search(array, o, 0, array.length);
    }

    public int indexOf(Object o, int index) {
        Object[] array = this.getArray();
        return CopyOnWriteArrayList.search(array, o, index, array.length);
    }

    public int lastIndexOf(Object o) {
        Object[] array = this.getArray();
        return CopyOnWriteArrayList.reverseSearch(array, o, 0, array.length);
    }

    public int lastIndexOf(Object o, int index) {
        Object[] array = this.getArray();
        return CopyOnWriteArrayList.reverseSearch(array, o, 0, index);
    }

    public ListIterator listIterator() {
        return new COWIterator(this.getArray(), 0);
    }

    public ListIterator listIterator(int index) {
        Object[] array = this.getArray();
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + array.length);
        }
        return new COWIterator(array, index);
    }

    public List subList(int fromIndex, int toIndex) {
        Object[] array = this.getArray();
        if (fromIndex < 0 || toIndex > array.length || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        return new COWSubList(fromIndex, toIndex - fromIndex);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Object[] array = this.getArray();
        int length = array.length;
        out.writeInt(length);
        for (int i = 0; i < length; ++i) {
            out.writeObject(array[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int length = in.readInt();
        Object[] array = new Object[length];
        for (int i = 0; i < length; ++i) {
            array[i] = in.readObject();
        }
        this.setArray(array);
    }

    public String toString() {
        Object[] array = this.getArray();
        int length = array.length;
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(array[i]);
        }
        buf.append(']');
        return buf.toString();
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    static class COWSubIterator
    implements ListIterator {
        final Object[] array;
        int cursor;
        int first;
        int last;

        COWSubIterator(Object[] array, int first, int last, int cursor) {
            this.array = array;
            this.first = first;
            this.last = last;
            this.cursor = cursor;
        }

        public boolean hasNext() {
            return this.cursor < this.last;
        }

        public boolean hasPrevious() {
            return this.cursor > this.first;
        }

        public int nextIndex() {
            return this.cursor - this.first;
        }

        public Object next() {
            if (this.cursor == this.last) {
                throw new NoSuchElementException();
            }
            return this.array[this.cursor++];
        }

        public int previousIndex() {
            return this.cursor - this.first - 1;
        }

        public Object previous() {
            if (this.cursor == this.first) {
                throw new NoSuchElementException();
            }
            return this.array[--this.cursor];
        }

        public void add(Object val) {
            throw new UnsupportedOperationException();
        }

        public void set(Object val) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class COWSubList
    implements Serializable,
    List {
        private static final long serialVersionUID = -8660955369431018984L;
        final int offset;
        int length;
        transient Object[] expectedArray;

        COWSubList(int offset, int length) {
            this.offset = offset;
            this.length = length;
            this.expectedArray = CopyOnWriteArrayList.this.getArray();
        }

        public int size() {
            return this.length;
        }

        public boolean isEmpty() {
            return this.length == 0;
        }

        public boolean contains(Object o) {
            return CopyOnWriteArrayList.search(CopyOnWriteArrayList.this.getArray(), o, this.offset, this.offset + this.length) >= 0;
        }

        public Iterator iterator() {
            return this.listIterator();
        }

        public Object[] toArray() {
            Object[] array = CopyOnWriteArrayList.this.getArray();
            Object[] newarr = new Object[this.length];
            System.arraycopy(array, this.offset, newarr, 0, this.length);
            return newarr;
        }

        public Object[] toArray(Object[] a) {
            Object[] array = CopyOnWriteArrayList.this.getArray();
            if (a.length < this.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.length);
                System.arraycopy(array, this.offset, a, 0, this.length);
            } else {
                System.arraycopy(array, this.offset, a, 0, this.length);
                if (a.length > this.length) {
                    a[this.length] = null;
                }
            }
            return a;
        }

        public boolean add(Object o) {
            this.add(this.length, o);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object o) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                Object[] array = CopyOnWriteArrayList.this.getArray();
                if (array != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                int fullLength = array.length;
                int pos = CopyOnWriteArrayList.search(array, o, this.offset, this.length);
                if (pos < 0) {
                    return false;
                }
                Object[] newarr = new Object[fullLength - 1];
                int moved = this.length - pos - 1;
                if (pos > 0) {
                    System.arraycopy(array, 0, newarr, 0, pos);
                }
                if (moved > 0) {
                    System.arraycopy(array, pos + 1, newarr, pos, moved);
                }
                CopyOnWriteArrayList.this.setArray(newarr);
                this.expectedArray = newarr;
                --this.length;
                return true;
            }
        }

        public boolean containsAll(Collection c) {
            Object[] array = CopyOnWriteArrayList.this.getArray();
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                if (CopyOnWriteArrayList.search(array, itr.next(), this.offset, this.length) >= 0) continue;
                return false;
            }
            return true;
        }

        public boolean addAll(Collection c) {
            return this.addAll(this.length, c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addAll(int index, Collection c) {
            int added = c.size();
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                int pos;
                if (index < 0 || index >= this.length) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.length);
                }
                Object[] oldarr = CopyOnWriteArrayList.this.getArray();
                if (oldarr != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                if (added == 0) {
                    return false;
                }
                int fullLength = oldarr.length;
                Object[] newarr = new Object[fullLength + added];
                int newpos = pos = this.offset + index;
                System.arraycopy(oldarr, 0, newarr, 0, pos);
                int rem = fullLength - pos;
                Iterator itr = c.iterator();
                while (itr.hasNext()) {
                    newarr[newpos++] = itr.next();
                }
                if (rem > 0) {
                    System.arraycopy(oldarr, pos, newarr, newpos, rem);
                }
                CopyOnWriteArrayList.this.setArray(newarr);
                this.expectedArray = newarr;
                this.length += added;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeAll(Collection c) {
            if (c.isEmpty()) {
                return false;
            }
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                Object[] array = CopyOnWriteArrayList.this.getArray();
                if (array != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                int fullLength = array.length;
                Object[] tmp = new Object[this.length];
                int retained = 0;
                for (int i = this.offset; i < this.offset + this.length; ++i) {
                    Object o = array[i];
                    if (c.contains(o)) continue;
                    tmp[retained++] = o;
                }
                if (retained == this.length) {
                    return false;
                }
                Object[] newarr = new Object[fullLength + retained - this.length];
                int moved = fullLength - this.offset - this.length;
                if (this.offset > 0) {
                    System.arraycopy(array, 0, newarr, 0, this.offset);
                }
                if (retained > 0) {
                    System.arraycopy(tmp, 0, newarr, this.offset, retained);
                }
                if (moved > 0) {
                    System.arraycopy(array, this.offset + this.length, newarr, this.offset + retained, moved);
                }
                CopyOnWriteArrayList.this.setArray(newarr);
                this.expectedArray = newarr;
                this.length = retained;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection c) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                Object[] array = CopyOnWriteArrayList.this.getArray();
                if (array != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                int fullLength = array.length;
                Object[] tmp = new Object[this.length];
                int retained = 0;
                for (int i = this.offset; i < this.offset + this.length; ++i) {
                    Object o = array[i];
                    if (!c.contains(o)) continue;
                    tmp[retained++] = o;
                }
                if (retained == this.length) {
                    return false;
                }
                Object[] newarr = new Object[fullLength + retained - this.length];
                int moved = fullLength - this.offset - this.length;
                if (this.offset > 0) {
                    System.arraycopy(array, 0, newarr, 0, this.offset);
                }
                if (retained > 0) {
                    System.arraycopy(tmp, 0, newarr, this.offset, retained);
                }
                if (moved > 0) {
                    System.arraycopy(array, this.offset + this.length, newarr, this.offset + retained, moved);
                }
                CopyOnWriteArrayList.this.setArray(newarr);
                this.expectedArray = newarr;
                this.length = retained;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                Object[] array = CopyOnWriteArrayList.this.getArray();
                if (array != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                int fullLength = array.length;
                Object[] newarr = new Object[fullLength - this.length];
                int moved = fullLength - this.offset - this.length;
                if (this.offset > 0) {
                    System.arraycopy(array, 0, newarr, 0, this.offset);
                }
                if (moved > 0) {
                    System.arraycopy(array, this.offset + this.length, newarr, this.offset, moved);
                }
                CopyOnWriteArrayList.this.setArray(newarr);
                this.expectedArray = newarr;
                this.length = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean equals(Object o) {
            int last;
            Object[] array;
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                array = CopyOnWriteArrayList.this.getArray();
                if (array != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                last = this.offset + this.length;
            }
            ListIterator itr = ((List)o).listIterator();
            int idx = this.offset;
            while (idx < last && itr.hasNext()) {
                Object o1 = array[idx];
                Object o2 = itr.next();
                if (CopyOnWriteArrayList.eq(o1, o2)) continue;
                return false;
            }
            return idx == last && !itr.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int hashCode() {
            int last;
            Object[] array;
            int hashCode = 1;
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                array = CopyOnWriteArrayList.this.getArray();
                if (array != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                last = this.offset + this.length;
            }
            for (int i = this.offset; i < last; ++i) {
                Object o = array[i];
                hashCode = 31 * hashCode + (o == null ? 0 : o.hashCode());
            }
            return hashCode;
        }

        public Object get(int index) {
            return CopyOnWriteArrayList.this.getArray()[this.offset + index];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object set(int index, Object element) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                if (index < 0 || index >= this.length) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.length);
                }
                Object[] oldarr = CopyOnWriteArrayList.this.getArray();
                if (oldarr != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                int fullLength = oldarr.length;
                Object oldVal = oldarr[this.offset + index];
                if (oldVal == element) {
                    CopyOnWriteArrayList.this.setArray(oldarr);
                } else {
                    Object[] newarr = new Object[fullLength];
                    System.arraycopy(oldarr, 0, newarr, 0, fullLength);
                    newarr[this.offset + index] = element;
                    CopyOnWriteArrayList.this.setArray(newarr);
                    this.expectedArray = newarr;
                }
                return oldVal;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(int index, Object element) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                if (index < 0 || index > this.length) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.length);
                }
                Object[] oldarr = CopyOnWriteArrayList.this.getArray();
                if (oldarr != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                int fullLength = oldarr.length;
                Object[] newarr = new Object[fullLength + 1];
                int pos = this.offset + index;
                int moved = fullLength - pos;
                System.arraycopy(oldarr, 0, newarr, 0, pos);
                newarr[pos] = element;
                if (moved > 0) {
                    System.arraycopy(oldarr, pos, newarr, pos + 1, moved);
                }
                CopyOnWriteArrayList.this.setArray(newarr);
                this.expectedArray = newarr;
                ++this.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object remove(int index) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                if (index < 0 || index >= this.length) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.length);
                }
                Object[] array = CopyOnWriteArrayList.this.getArray();
                if (array != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                int fullLength = array.length;
                int pos = this.offset + index;
                Object result = array[pos];
                Object[] newarr = new Object[fullLength - 1];
                int moved = fullLength - pos - 1;
                if (index > 0) {
                    System.arraycopy(array, 0, newarr, 0, pos);
                }
                if (moved > 0) {
                    System.arraycopy(array, pos + 1, newarr, pos, moved);
                }
                CopyOnWriteArrayList.this.setArray(newarr);
                this.expectedArray = newarr;
                --this.length;
                return result;
            }
        }

        public int indexOf(Object o) {
            int pos = CopyOnWriteArrayList.search(CopyOnWriteArrayList.this.getArray(), o, this.offset, this.offset + this.length);
            return pos >= 0 ? pos - this.offset : -1;
        }

        public int indexOf(Object o, int index) {
            int pos = CopyOnWriteArrayList.search(CopyOnWriteArrayList.this.getArray(), o, this.offset + index, this.offset + this.length) - this.offset;
            return pos >= 0 ? pos - this.offset : -1;
        }

        public int lastIndexOf(Object o) {
            int pos = CopyOnWriteArrayList.reverseSearch(CopyOnWriteArrayList.this.getArray(), o, this.offset, this.offset + this.length) - this.offset;
            return pos >= 0 ? pos - this.offset : -1;
        }

        public int lastIndexOf(Object o, int index) {
            int pos = CopyOnWriteArrayList.reverseSearch(CopyOnWriteArrayList.this.getArray(), o, this.offset, this.offset + index) - this.offset;
            return pos >= 0 ? pos - this.offset : -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator listIterator() {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                Object[] array = CopyOnWriteArrayList.this.getArray();
                if (array != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                return new COWSubIterator(array, this.offset, this.offset + this.length, this.offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListIterator listIterator(int index) {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                if (index < 0 || index >= this.length) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.length);
                }
                Object[] array = CopyOnWriteArrayList.this.getArray();
                if (array != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                return new COWSubIterator(array, this.offset, this.offset + this.length, this.offset + index);
            }
        }

        public List subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this.length || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException();
            }
            return new COWSubList(this.offset + fromIndex, toIndex - fromIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            int last;
            Object[] array;
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                array = CopyOnWriteArrayList.this.getArray();
                if (array != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
                last = this.offset + this.length;
            }
            StringBuffer buf = new StringBuffer();
            buf.append('[');
            for (int i = this.offset; i < last; ++i) {
                if (i > this.offset) {
                    buf.append(", ");
                }
                buf.append(array[i]);
            }
            buf.append(']');
            return buf.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream out) throws IOException {
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                if (CopyOnWriteArrayList.this.getArray() != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
            }
            out.defaultWriteObject();
            copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                if (CopyOnWriteArrayList.this.getArray() != this.expectedArray) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            CopyOnWriteArrayList copyOnWriteArrayList = CopyOnWriteArrayList.this;
            synchronized (copyOnWriteArrayList) {
                this.expectedArray = CopyOnWriteArrayList.this.getArray();
            }
        }
    }

    static class COWIterator
    implements ListIterator {
        final Object[] array;
        int cursor;

        COWIterator(Object[] array, int cursor) {
            this.array = array;
            this.cursor = cursor;
        }

        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        public int nextIndex() {
            return this.cursor;
        }

        public Object next() {
            try {
                return this.array[this.cursor++];
            }
            catch (IndexOutOfBoundsException e) {
                --this.cursor;
                throw new NoSuchElementException();
            }
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public Object previous() {
            try {
                return this.array[--this.cursor];
            }
            catch (IndexOutOfBoundsException e) {
                ++this.cursor;
                throw new NoSuchElementException();
            }
        }

        public void add(Object val) {
            throw new UnsupportedOperationException();
        }

        public void set(Object val) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

