/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.groovy;

import com.atlassian.clover.ant.AntInstrUtils;
import com.atlassian.clover.instr.java.InstrumentationConfig;
import com.atlassian.clover.instr.java.Instrumenter;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CloverNames;
import com.cenqua.clover.Logger;
import com.cenqua.clover.tasks.AntInstrumentationConfig;
import com.cenqua.clover.tasks.CloverEnvTask;
import com.cenqua.clover.util.ClassPathUtil;
import com.cenqua.clover.util.FileUtils;
import com.cenqua.clover.util.ReflectionUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovycSupport
implements BuildListener {
    private static final Collection<String> COMPILERS = new HashSet<String>(){
        {
            this.add("org.codehaus.groovy.ant.Groovyc");
            this.add("org.codehaus.groovy.grails.compiler.GrailsCompiler");
        }
    };
    private static final String GROVER = "grover";
    private static final String JAR = ".jar";
    private static final String GROVER_JAR = "grover.jar";
    private static final String EMBEDDEDJARS_CLOVER = "embeddedjars/clover3.0.2";
    private final boolean cleanupAfterBuild;
    private File workingDir;
    private Collection<String> groovycTaskNames = new HashSet<String>();
    private int numTaskDefsLastSeen = 0;
    private File groverJar;
    static /* synthetic */ Class class$com$atlassian$clover$ant$groovy$GroovycSupport;
    static /* synthetic */ Class class$com$cenqua$clover$tasks$CloverEnvTask;

    public static void ensureAddedTo(Project project) {
        for (BuildListener listener : project.getBuildListeners()) {
            if (!GroovycSupport.isOneOfMe(listener)) continue;
            return;
        }
        project.addBuildListener((BuildListener)new GroovycSupport(project));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isOneOfMe(BuildListener listener) {
        if (listener instanceof GroovycSupport) return true;
        String string = listener.getClass().getName();
        Class<?> clazz = class$com$atlassian$clover$ant$groovy$GroovycSupport;
        if (clazz == null) {
            clazz = class$com$atlassian$clover$ant$groovy$GroovycSupport = new GroovycSupport[0].getClass().getComponentType();
        }
        if (!string.equals(clazz)) return false;
        return true;
    }

    private GroovycSupport(Project project) {
        this.cleanupAfterBuild = !Boolean.getBoolean("clover.grover.no.postbuild.cleanup") || Boolean.valueOf(project.getProperty("clover.grover.no.postbuild.cleanup")) == false;
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    public void buildFinished(BuildEvent buildEvent) {
    }

    public void targetStarted(BuildEvent buildEvent) {
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void messageLogged(BuildEvent buildEvent) {
    }

    public void taskFinished(BuildEvent buildEvent) {
        if (this.workingDir != null) {
            if (this.workingDir.exists() && this.cleanupAfterBuild) {
                Logger.getInstance().verbose(new StringBuffer().append("Cleaning up Clover directory ").append(this.workingDir.getAbsolutePath()).toString());
                FileUtils.deltree(this.workingDir);
            }
            this.workingDir = null;
        }
    }

    public void taskStarted(BuildEvent buildEvent) {
        this.initGroovycTaskNames(buildEvent.getProject());
        Task task = buildEvent.getTask();
        if (this.isGroovyc(task)) {
            task.maybeConfigure();
            try {
                Task groovyc = task instanceof UnknownElement ? (Task)((UnknownElement)task).getRealThing() : task;
                AntInstrumentationConfig config = AntInstrumentationConfig.getFrom(buildEvent.getProject());
                if (groovyc != null && config != null && config.isEnabled()) {
                    this.ensureWorkingDirCreated(config);
                    this.ensureGroverJarCreated();
                    if (this.workingDir != null && this.groverJar != null) {
                        Collection<ParentAndChildPath> groovySourceToInstrument;
                        Collection<File> includedFiles;
                        Path origSrcPath = this.invokeGetSrcdir(groovyc);
                        File destDir = this.invokeGetDestdir(groovyc);
                        Collection<ParentAndChildPath> groovySourceToCompile = this.scanForOutOfDateSource(buildEvent.getProject(), groovyc, origSrcPath, destDir, "groovy");
                        if (this.isJointCompilation(groovyc)) {
                            Logger.getInstance().verbose("Detected joint Groovy and Java compilation.");
                            Collection<ParentAndChildPath> javaSourceToCompile = this.scanForOutOfDateSource(buildEvent.getProject(), groovyc, origSrcPath, destDir, "java");
                            if (this.filesNeedingInstrumentation(buildEvent.getProject(), origSrcPath, javaSourceToCompile)) {
                                File mainInstrDir = AntInstrUtils.createInstrDir(config.getTmpDir());
                                File filteredInstrDir = new File(mainInstrDir, CloverNames.CLOVER_RECORDER_PREFIX);
                                filteredInstrDir.mkdirs();
                                Logger.getInstance().verbose(new StringBuffer().append("Outputting instrumented Java source to ").append(filteredInstrDir.getAbsolutePath()).toString());
                                this.instrumentAndIgnoreOriginalJavaSource(groovyc, config, filteredInstrDir, this.applyCloverFilter(buildEvent.getProject(), groovyc, origSrcPath, true, javaSourceToCompile));
                                this.includeGroovySource(groovyc, groovySourceToCompile);
                                this.invokeSetSrcdir(groovyc, new Path(buildEvent.getProject(), mainInstrDir.getAbsolutePath()));
                            }
                        }
                        if ((includedFiles = this.toFiles(groovySourceToInstrument = this.applyCloverFilter(buildEvent.getProject(), groovyc, origSrcPath, false, groovySourceToCompile))).size() > 0) {
                            Logger.getInstance().verbose("Groovy files to be instrumented:");
                            for (File includedFile : includedFiles) {
                                Logger.getInstance().verbose(includedFile.getAbsolutePath());
                            }
                        }
                        config.setIncludedFiles(includedFiles);
                        this.augmentCompilationClasspath(buildEvent.getProject(), groovyc, config);
                    }
                }
            }
            catch (Throwable t) {
                buildEvent.getProject().log(new StringBuffer().append("Clover failed to integrate with <").append(task.getTaskName()).append("/>").toString(), t, 0);
            }
        }
    }

    private Collection<File> toFiles(Collection<ParentAndChildPath> parentAndChildPaths) {
        HashSet<File> files = new HashSet<File>();
        for (ParentAndChildPath parentAndChildPath : parentAndChildPaths) {
            files.add(parentAndChildPath.toFile());
        }
        return files;
    }

    private void includeGroovySource(Task groovyc, Collection<ParentAndChildPath> groovySource) {
        MatchingTask matchingGroovyc = (MatchingTask)groovyc;
        for (ParentAndChildPath parentAndChildPath : groovySource) {
            Logger.getInstance().verbose(new StringBuffer().append("Adding explicit include: ").append(parentAndChildPath.child).toString());
            matchingGroovyc.setIncludes(parentAndChildPath.child);
        }
    }

    private void instrumentAndIgnoreOriginalJavaSource(Task groovyc, AntInstrumentationConfig config, File instrDir, Collection<ParentAndChildPath> toInstrument) throws CloverException {
        MatchingTask matchingGroovyc = (MatchingTask)groovyc;
        Instrumenter instrumenter = new Instrumenter(Logger.getInstance(), config);
        instrumenter.startInstrumentation();
        for (ParentAndChildPath parentAndChildPath : toInstrument) {
            instrumenter.instrument(parentAndChildPath.toFile(), instrDir);
        }
        String instrumentedSrcIncludes = new StringBuffer().append(instrDir.getName()).append("/**/*.java").toString();
        Logger.getInstance().verbose(new StringBuffer().append("Adding explicit include ").append(instrumentedSrcIncludes).toString());
        matchingGroovyc.setIncludes(instrumentedSrcIncludes);
        instrumenter.endInstrumentation();
    }

    public static File extractGroverJar(boolean deleteOnExit) {
        File jar = null;
        Throwable whyFailed = null;
        try {
            InputStream groverStream;
            Class<?> clazz = class$com$cenqua$clover$tasks$CloverEnvTask;
            if (clazz == null) {
                clazz = class$com$cenqua$clover$tasks$CloverEnvTask = new CloverEnvTask[0].getClass().getComponentType();
            }
            if ((groverStream = clazz.getResourceAsStream(new StringBuffer().append("/").append(CloverNames.getRepkgPrefix()).append(EMBEDDEDJARS_CLOVER).append("/").append(GROVER_JAR).toString())) != null) {
                File jarFile = File.createTempFile(GROVER, JAR);
                if (deleteOnExit) {
                    jarFile.deleteOnExit();
                }
                FileOutputStream jarOutStream = new FileOutputStream(jarFile);
                byte[] buffer = new byte[1000];
                int read = groverStream.read(buffer);
                while (read != -1) {
                    ((OutputStream)jarOutStream).write(buffer, 0, read);
                    read = groverStream.read(buffer);
                }
                jarOutStream.flush();
                ((OutputStream)jarOutStream).close();
                jar = jarFile;
            }
        }
        catch (Throwable t) {
            whyFailed = t;
        }
        if (jar == null) {
            Logger.getInstance().warn("Failed to extract and copy grover.jar to a temporary file. Clover instrumentation of Groovy source will not proceed.", whyFailed);
        }
        return jar;
    }

    private void ensureWorkingDirCreated(AntInstrumentationConfig config) {
        try {
            this.workingDir = FileUtils.createTempDir(GROVER, config.getTmpDir());
        }
        catch (Exception e) {
            Logger.getInstance().warn(new StringBuffer().append("Failed to create Clover working directory in ").append(config.getTmpDir()).append(". Clover instrumentation of Groovy source will not proceed.").toString(), e);
        }
    }

    private void ensureGroverJarCreated() {
        this.groverJar = GroovycSupport.extractGroverJar(this.cleanupAfterBuild);
    }

    private Collection<ParentAndChildPath> scanForOutOfDateSource(Project project, Task groovyc, Path origSrcDirs, File destDir, String extension) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        LinkedHashSet<ParentAndChildPath> toBeCompiled = new LinkedHashSet<ParentAndChildPath>();
        for (String origSrcDirPath : origSrcDirs.list()) {
            File origSrcDir = project.resolveFile(origSrcDirPath);
            if (!origSrcDir.exists()) continue;
            Logger.getInstance().verbose(new StringBuffer().append("Scanning for source to compile: ").append(origSrcDir.getAbsolutePath()).toString());
            toBeCompiled.addAll(this.findOutOfDateSource(groovyc, origSrcDir, destDir != null ? destDir : origSrcDir, this.invokeGetDirectoryScanner(groovyc, origSrcDir).getIncludedFiles(), extension));
        }
        if (toBeCompiled.size() > 0) {
            Logger.getInstance().verbose("Out of date source found:");
            for (ParentAndChildPath parentAndChildPath : toBeCompiled) {
                Logger.getInstance().verbose(parentAndChildPath.toFile().getAbsolutePath());
            }
        } else {
            Logger.getInstance().verbose("No out of date source found");
        }
        return toBeCompiled;
    }

    private boolean filesNeedingInstrumentation(Project project, Path srcPath, Collection<ParentAndChildPath> sourceToCompile) {
        Map<File, ParentAndChildPath> toCompileMap = this.mapToFiles(sourceToCompile);
        HashSet<File> toCompileFiles = new HashSet<File>(toCompileMap.keySet());
        LinkedHashSet<File> filteredOut = new LinkedHashSet<File>();
        LinkedHashSet<File> toInstrument = new LinkedHashSet<File>();
        AntInstrUtils.sieveSourceForInstrumentation(project, srcPath, AntInstrUtils.calcInstrPatternSet(project), AntInstrUtils.calcInstrFileSets(project), toCompileFiles, filteredOut, toInstrument);
        return toInstrument.size() > 0;
    }

    private Collection<ParentAndChildPath> applyCloverFilter(Project project, Task groovyc, Path srcPath, boolean commitFilterToGroovyc, Collection<ParentAndChildPath> javaSourceToCompile) {
        Map<File, ParentAndChildPath> toCompileMap = this.mapToFiles(javaSourceToCompile);
        HashSet<File> toCompileFiles = new HashSet<File>(toCompileMap.keySet());
        LinkedHashSet<File> filteredOut = new LinkedHashSet<File>();
        LinkedHashSet<File> toInstrument = new LinkedHashSet<File>();
        AntInstrUtils.sieveSourceForInstrumentation(project, srcPath, AntInstrUtils.calcInstrPatternSet(project), AntInstrUtils.calcInstrFileSets(project), toCompileFiles, filteredOut, toInstrument);
        if (commitFilterToGroovyc) {
            ParentAndChildPath parentAndChildPath;
            MatchingTask matchingGroovyc = (MatchingTask)groovyc;
            if (filteredOut.size() > 0) {
                Logger.getInstance().verbose("Adding explicit include(s) for Java source not being instrumented:");
                for (File file : filteredOut) {
                    parentAndChildPath = toCompileMap.get(file);
                    if (parentAndChildPath == null) continue;
                    Logger.getInstance().verbose(parentAndChildPath.child);
                    matchingGroovyc.setIncludes(parentAndChildPath.child);
                }
            }
            if (toInstrument.size() > 0) {
                Logger.getInstance().verbose("Adding explicit exclude(s) for Java source being instrumented:");
                for (File file : toInstrument) {
                    parentAndChildPath = toCompileMap.get(file);
                    if (parentAndChildPath == null) continue;
                    Logger.getInstance().verbose(parentAndChildPath.child);
                    matchingGroovyc.setExcludes(parentAndChildPath.child);
                }
            }
        }
        return this.grabFromFiles(toCompileMap, toInstrument);
    }

    private Collection<ParentAndChildPath> grabFromFiles(Map<File, ParentAndChildPath> toCompileMap, Collection<File> toInstrument) {
        HashSet<ParentAndChildPath> result = new HashSet<ParentAndChildPath>();
        for (File file : toInstrument) {
            result.add(toCompileMap.get(file));
        }
        return result;
    }

    private Map<File, ParentAndChildPath> mapToFiles(Collection<ParentAndChildPath> toCompile) {
        HashMap<File, ParentAndChildPath> map = new HashMap<File, ParentAndChildPath>();
        for (ParentAndChildPath parentAndChildPath : toCompile) {
            map.put(parentAndChildPath.toFile(), parentAndChildPath);
        }
        return map;
    }

    private void augmentCompilationClasspath(Project project, Task groovyc, AntInstrumentationConfig config) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, IOException {
        String[] paths;
        for (String path : paths = new String[]{GroovycSupport.newConfigDir(config, this.workingDir).getAbsolutePath(), this.groverJar.getAbsolutePath(), ClassPathUtil.getCloverJarPath()}) {
            Logger.getInstance().verbose(new StringBuffer().append("Adding ").append(path).append(" to Groovy compilation path").toString());
            this.invokeSetClasspath(groovyc, new Path(project, path));
        }
    }

    public static File newConfigDir(InstrumentationConfig config, File parent) throws IOException {
        File configDir = FileUtils.createTempDir("groverconfig", parent);
        File instrPropsFile = new File(configDir, CloverNames.getGroverConfigFileName());
        config.saveToFile(instrPropsFile);
        return configDir;
    }

    private Collection<ParentAndChildPath> findOutOfDateSource(Task groovyc, File srcDir, File destDir, String[] files, String extension) {
        LinkedHashSet<ParentAndChildPath> outOfDateFiles = new LinkedHashSet<ParentAndChildPath>();
        GlobPatternMapper mapper = new GlobPatternMapper();
        SourceFileScanner sfs = new SourceFileScanner(groovyc);
        mapper.setFrom(new StringBuffer().append("*.").append(extension).toString());
        mapper.setTo("*.class");
        String[] filteredFiles = sfs.restrict(files, srcDir, destDir, (FileNameMapper)mapper);
        if (filteredFiles.length > 0) {
            for (String path : filteredFiles) {
                outOfDateFiles.add(new ParentAndChildPath(srcDir, path));
            }
        }
        return outOfDateFiles;
    }

    private boolean isJointCompilation(Task groovyc) {
        Enumeration kids = groovyc.getRuntimeConfigurableWrapper().getChildren();
        while (kids.hasMoreElements()) {
            RuntimeConfigurable child = (RuntimeConfigurable)kids.nextElement();
            if (!child.getElementTag().equals("javac")) continue;
            return true;
        }
        return false;
    }

    private DirectoryScanner invokeGetDirectoryScanner(Object task, File file) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (DirectoryScanner)ReflectionUtils.invokeVirtualImplicit("getDirectoryScanner", task, new Object[]{file});
    }

    private Path invokeGetSrcdir(Object task) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (Path)ReflectionUtils.invokeVirtualImplicit("getSrcdir", task);
    }

    private File invokeGetDestdir(Object task) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (File)ReflectionUtils.invokeVirtualImplicit("getDestdir", task);
    }

    private void invokeSetSrcdir(Object task, Path path) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ReflectionUtils.invokeVirtualImplicit("setSrcdir", task, new Object[]{path});
    }

    private void invokeSetClasspath(Object task, Path path) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ReflectionUtils.invokeVirtualImplicit("setClasspath", task, new Object[]{path});
    }

    private void initGroovycTaskNames(Project project) {
        Hashtable taskDefs = project.getTaskDefinitions();
        if (taskDefs.size() > this.numTaskDefsLastSeen) {
            this.groovycTaskNames = new HashSet<String>();
            for (Map.Entry entry : taskDefs.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof Class) || !COMPILERS.contains(((Class)value).getName())) continue;
                this.groovycTaskNames.add((String)entry.getKey());
            }
            this.numTaskDefsLastSeen = taskDefs.size();
        }
    }

    private boolean isGroovyc(Task task) {
        return this.groovycTaskNames.contains(task.getTaskName());
    }

    private static class ParentAndChildPath {
        public final File parent;
        public final String child;

        public ParentAndChildPath(File parent, String child) {
            this.parent = parent;
            this.child = child;
        }

        public File toFile() {
            return new File(this.parent, this.child);
        }
    }
}

