/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.instr.java.ConcurrentInstrumentationException;
import com.atlassian.clover.lang.Language;
import com.atlassian.clover.registry.ReadOnlyRegistryException;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.context.ContextStore;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.MethodSignature;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.RegUpdate;
import com.cenqua.clover.registry.SourceRegion;
import com.cenqua.clover.registry.StatementInfo;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationSession {
    private final Clover2Registry reg;
    private final long startVersion;
    private final LinkedList<ClassInfo> classStack;
    private final LinkedList<MethodInfo> methodStack;
    private final Map<String, SessionPackageInfo> changedPackages;
    private final long startTS;
    private final long version;
    private long endTS;
    private SessionPackageInfo currentPackage;
    private FileInfo currentFile;
    private int currentFileIndex;
    private int currentOffsetFromFile;
    private String activeEncoding;
    private int nextIndexForNewFile;

    public InstrumentationSession(Clover2Registry reg, String activeEncoding) throws CloverException {
        this.activeEncoding = activeEncoding;
        if (reg.isReadOnly()) {
            throw new ReadOnlyRegistryException();
        }
        this.reg = reg;
        this.startVersion = reg.getVersion();
        this.classStack = new LinkedList();
        this.methodStack = new LinkedList();
        this.changedPackages = new HashMap<String, SessionPackageInfo>();
        this.nextIndexForNewFile = this.currentFileIndex = reg.getProject().getDataLength();
        this.startTS = this.endTS = System.currentTimeMillis();
        this.version = this.startTS > this.startVersion ? this.startTS : this.startVersion + 1L;
        this.currentOffsetFromFile = 0;
    }

    public RegUpdate finishAndApply() throws ConcurrentInstrumentationException {
        return this.reg.applyUpdate(this.startVersion, this.finish());
    }

    public Update finish() {
        this.endTS = System.currentTimeMillis();
        if (this.currentPackage != null) {
            this.exitPackage();
        }
        return new Update(this.version, this.startTS, System.currentTimeMillis(), this.nextIndexForNewFile, this.toPackages(this.changedPackages.values()), this.reg.getContextStore());
    }

    private Collection<PackageInfo> toPackages(Collection<SessionPackageInfo> shadowPackageInfos) {
        LinkedList<PackageInfo> pkgInfos = new LinkedList<PackageInfo>();
        for (SessionPackageInfo shadowPackageInfo : shadowPackageInfos) {
            pkgInfos.add(shadowPackageInfo.getSessionPkg());
        }
        return pkgInfos;
    }

    public int getCurrentIndex() {
        return this.currentFileIndex;
    }

    public int getCurrentFileMaxIndex() {
        return this.currentFileIndex + this.currentOffsetFromFile;
    }

    public int getCurrentOffsetFromFile() {
        return this.currentOffsetFromFile;
    }

    public Clover2Registry getRegistry() {
        return this.reg;
    }

    public FileInfo enterFile(String pkg, File file, int lineCount, int ncLineCount, long timestamp, long filesize, long checksum) {
        this.currentOffsetFromFile = 0;
        this.enterPackage(pkg);
        FileInfo finfo = (FileInfo)this.currentPackage.getFileInPackage(file.getName());
        long minVersion = -1L;
        if (finfo != null) {
            if (finfo.getChecksum() == checksum && finfo.getFilesize() == filesize) {
                this.currentFileIndex = finfo.getDataIndex();
                minVersion = finfo.getMinVersion();
            } else {
                this.currentFileIndex = this.nextIndexForNewFile;
            }
        } else {
            this.currentFileIndex = this.nextIndexForNewFile;
        }
        finfo = new FileInfo(this.currentPackage.getSessionPkg(), file, this.activeEncoding, this.currentFileIndex, lineCount, ncLineCount, timestamp, filesize, checksum, this.version);
        if (minVersion != -1L) {
            finfo.addVersions(minVersion, this.startTS);
        }
        this.currentFile = finfo;
        return finfo;
    }

    public void exitFile() {
        this.currentFile.setDataLength(this.currentOffsetFromFile);
        this.currentPackage.addFile(this.currentFile);
        this.nextIndexForNewFile = Math.max(this.currentFileIndex + this.currentOffsetFromFile, this.nextIndexForNewFile);
        this.currentPackage.setDataLength(Math.max(this.currentPackage.getDataLength(), this.currentFileIndex + this.currentOffsetFromFile - this.currentPackage.getDataIndex()));
        this.currentFile = null;
    }

    public ClassInfo enterClass(String name, SourceRegion region, boolean typeInterface, boolean typeEnum, boolean typeAnnotation) {
        ClassInfo clazz = new ClassInfo(this.currentPackage.getSessionPkg(), this.currentFile, this.currentOffsetFromFile, name, region, typeInterface, typeEnum, typeAnnotation);
        this.currentFile.addClass(clazz);
        this.pushCurrentClass(clazz);
        return clazz;
    }

    public ClassInfo exitClass(int endLine, int endCol) {
        ClassInfo clazz = this.popCurrentClass();
        clazz.setRegionEnd(endLine, endCol);
        clazz.setDataLength(this.currentOffsetFromFile - clazz.getRelativeDataIndex());
        return this.getCurrentClass();
    }

    public MethodInfo enterMethod(ContextSet context, SourceRegion region, MethodSignature signature, boolean test, int complexity) {
        return this.enterMethod(context, region, signature, test, complexity, Language.Construct.METHOD);
    }

    public MethodInfo enterMethod(ContextSet context, SourceRegion region, MethodSignature signature, boolean test, int complexity, Language.Construct construct) {
        MethodInfo method = new MethodInfo(this.getCurrentClass(), this.currentOffsetFromFile, context, region, signature, test, complexity, construct);
        this.currentOffsetFromFile += method.getDataLength();
        this.pushCurrentMethod(method);
        return method;
    }

    public MethodInfo enterMethod(ContextSet context, SourceRegion region, MethodSignature signature, boolean test) {
        return this.enterMethod(context, region, signature, test, 1);
    }

    public void exitMethod(int endLine, int endCol) {
        MethodInfo method = this.popCurrentMethod();
        method.setRegionEnd(endLine, endCol);
        method.setDataLength(this.currentOffsetFromFile - method.getRelativeDataIndex());
        this.getCurrentClass().addMethod(method);
    }

    public StatementInfo addStatement(ContextSet context, SourceRegion region, int complexity) {
        return this.addStatement(context, region, complexity, Language.Construct.STATEMENT);
    }

    public StatementInfo addStatement(ContextSet context, SourceRegion region, int complexity, Language.Construct construct) {
        MethodInfo currentMethod = this.getCurrentMethod();
        StatementInfo stmt = new StatementInfo(currentMethod, this.currentOffsetFromFile, context, region, complexity, construct);
        this.currentOffsetFromFile += stmt.getDataLength();
        currentMethod.addStatement(stmt);
        return stmt;
    }

    public BranchInfo addBranch(ContextSet context, SourceRegion region, int complexity, boolean instrumented) {
        return this.addBranch(context, region, complexity, instrumented, Language.Construct.BRANCH);
    }

    public BranchInfo addBranch(ContextSet context, SourceRegion region, int complexity, boolean instrumented, Language.Construct construct) {
        MethodInfo currentMethod = this.getCurrentMethod();
        BranchInfo branch = null;
        if (currentMethod != null) {
            branch = new BranchInfo(currentMethod, this.currentOffsetFromFile, context, region, complexity, instrumented, construct);
            this.currentOffsetFromFile += branch.getDataLength();
            currentMethod.addBranch(branch);
        }
        return branch;
    }

    public void setActiveEncoding(String encoding) {
        this.activeEncoding = encoding;
    }

    public PackageInfo enterPackage(String name) {
        SessionPackageInfo pkg;
        if (this.currentPackage != null) {
            if (this.currentPackage.isNamed(name)) {
                return this.currentPackage.getSessionPkg();
            }
            this.exitPackage();
        }
        if ((pkg = this.changedPackages.get(name)) == null) {
            PackageInfo modelPkg = (PackageInfo)this.reg.getProject().getNamedPackage(name);
            pkg = new SessionPackageInfo(modelPkg, new PackageInfo(this.reg.getProject(), name, modelPkg == null ? this.currentFileIndex : modelPkg.getDataIndex()));
        }
        this.currentPackage = pkg;
        return this.currentPackage.getSessionPkg();
    }

    public void exitPackage() {
        this.changedPackages.put(this.currentPackage.getName(), this.currentPackage);
        this.currentPackage = null;
    }

    public FileInfo getCurrentFile() {
        return this.currentFile;
    }

    public PackageInfo getCurrentPackage() {
        return this.currentPackage.getSessionPkg();
    }

    public ClassInfo getCurrentClass() {
        if (this.classStack.size() > 0) {
            return this.classStack.getLast();
        }
        return null;
    }

    public void pushCurrentClass(ClassInfo clazz) {
        this.classStack.add(clazz);
    }

    public ClassInfo popCurrentClass() {
        if (this.classStack.size() > 0) {
            return this.classStack.removeLast();
        }
        return null;
    }

    public MethodInfo getCurrentMethod() {
        if (this.methodStack.size() > 0) {
            return this.methodStack.getLast();
        }
        return null;
    }

    public void pushCurrentMethod(MethodInfo clazz) {
        this.methodStack.add(clazz);
    }

    public MethodInfo popCurrentMethod() {
        if (this.methodStack.size() > 0) {
            return this.methodStack.removeLast();
        }
        return null;
    }

    public long getStartTs() {
        return this.startTS;
    }

    public long getEndTS() {
        return this.endTS;
    }

    public long getVersion() {
        return this.version;
    }

    public static class SessionPackageInfo {
        private PackageInfo modelPkg;
        private PackageInfo sessionPkg;

        public SessionPackageInfo(PackageInfo modelPkg, PackageInfo sessionPkg) {
            this.modelPkg = modelPkg;
            this.sessionPkg = sessionPkg;
        }

        public BaseFileInfo getFileInPackage(String name) {
            BaseFileInfo fileInfo = this.sessionPkg.getFileInPackage(name);
            if (fileInfo == null) {
                fileInfo = this.modelPkg == null ? null : this.modelPkg.getFileInPackage(name);
            }
            return fileInfo;
        }

        public PackageInfo getModelPkg() {
            return this.modelPkg;
        }

        public PackageInfo getSessionPkg() {
            return this.sessionPkg;
        }

        public int getDataIndex() {
            return this.sessionPkg.getDataIndex();
        }

        public int getDataLength() {
            return this.sessionPkg.getDataLength();
        }

        public void setDataLength(int len) {
            this.sessionPkg.setDataLength(len);
        }

        public void addFile(FileInfo currentFile) {
            this.sessionPkg.addFile(currentFile);
        }

        public boolean isNamed(String name) {
            return this.sessionPkg.isNamed(name);
        }

        public String getName() {
            return this.sessionPkg.getName();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Update
    implements RegUpdate {
        private final long version;
        private final long startTS;
        private final long endTS;
        private final int slotCount;
        private final Collection<PackageInfo> changedPkgInfos;
        private final ContextStore ctxStore;
        private final List<FileInfo> fileInfos;

        public Update(long version, long startTS, long endTS, int slotCount, Collection<PackageInfo> changedPkgInfos, ContextStore ctxStore) {
            this.version = version;
            this.startTS = startTS;
            this.endTS = endTS;
            this.slotCount = slotCount;
            this.changedPkgInfos = changedPkgInfos;
            this.ctxStore = ctxStore;
            this.fileInfos = this.collectFileInfos();
        }

        private List<FileInfo> collectFileInfos() {
            LinkedList<FileInfo> fileInfos = new LinkedList<FileInfo>();
            for (PackageInfo newPkgInfo : this.changedPkgInfos) {
                for (FileInfo fileInfo : newPkgInfo.getFiles()) {
                    fileInfos.add(fileInfo);
                }
            }
            return fileInfos;
        }

        @Override
        public long getVersion() {
            return this.version;
        }

        @Override
        public long getStartTs() {
            return this.startTS;
        }

        @Override
        public long getEndTs() {
            return this.endTS;
        }

        @Override
        public int getSlotCount() {
            return this.slotCount;
        }

        @Override
        public List<FileInfo> getFileInfos() {
            return this.fileInfos;
        }

        public Collection<PackageInfo> getChangedPkgInfos() {
            return this.changedPkgInfos;
        }

        @Override
        public ContextStore getContextStore() {
            return this.ctxStore;
        }
    }
}

