/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.instr.Bindings;
import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.InstrumentationConfig;
import com.atlassian.clover.instr.java.InstrumentationState;
import com.atlassian.clover.instr.java.JavaMethodContext;
import com.atlassian.clover.instr.tests.ExpectedExceptionMiner;
import com.cenqua.clover.CloverNames;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.context.MethodRegexpContext;
import com.cenqua.clover.context.NamedContext;
import com.cenqua.clover.registry.FixedSourceRegion;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.MethodSignature;
import com.cenqua.clover.util.CloverUtils;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodRegistrationNode
extends Emitter {
    private static final Map DEFAULT_RETURN_VALUES;
    private MethodSignature signature;
    private MethodInfo method;

    public MethodRegistrationNode(ContextSet context, MethodSignature signature, int line, int col) {
        super(context, line, col);
        this.signature = signature;
    }

    protected boolean acceptsContextType(NamedContext context) {
        return context instanceof MethodRegexpContext;
    }

    public void init(InstrumentationState state) {
        InstrumentationConfig cfg = state.getCfg();
        boolean isTestMethod = state.isDetectTests() && state.getTestDetector().isMethodMatch(state, JavaMethodContext.createFor(this.signature));
        String javaLangPrefix = cfg.getJavaLangPrefix();
        boolean addTestRewriteInstr = state.isInstrEnabled() && cfg.isRecordTestResults() && isTestMethod;
        this.method = state.getSession().enterMethod(this.getElementContext(), new FixedSourceRegion(this.getLine(), this.getColumn()), this.signature, isTestMethod);
        if (addTestRewriteInstr) {
            boolean nonVoidReturn;
            List<String> expectedExceptions = state.isDetectTests() ? Arrays.asList(ExpectedExceptionMiner.extractExpectedExceptionsFor(this.signature, state.getCfg().isJava15(), true)) : Collections.EMPTY_LIST;
            boolean expectsExceptions = expectedExceptions.size() > 0;
            String syntheticTestName = CloverUtils.createSyntheticTestName(this.method);
            StringBuffer instr = new StringBuffer();
            instr.append("{");
            String typeInstr = "getClass().getName()";
            if (Modifier.isStatic(this.getSignature().getModifiers())) {
                typeInstr = this.getMethod().getContainingClass().getName() + ".class.getName()";
            }
            instr.append(Bindings.$CoverageRecorder$globalSliceStart(state.getRecorderPrefix(), typeInstr, Integer.toString(this.method.getDataIndex()))).append(";");
            instr.append("int ").append(CloverNames.namespaceVariable("p")).append("=").append(0).append(";");
            instr.append(javaLangPrefix).append("Throwable ").append(CloverNames.namespaceVariable("t")).append("=null;");
            instr.append("try{");
            boolean bl = nonVoidReturn = this.signature.getReturnType() != null && !"void".equals(this.signature.getReturnType());
            if (nonVoidReturn) {
                instr.append(this.signature.getReturnType()).append(" ").append(CloverNames.namespaceVariable("r")).append("=");
            }
            instr.append(syntheticTestName);
            instr.append("(").append(this.signature.listParamIdents()).append(");");
            instr.append(CloverNames.namespaceVariable("p")).append("=");
            if (expectsExceptions) {
                int i;
                instr.append(0).append(";").append(CloverNames.namespaceVariable("t")).append("=new ").append(javaLangPrefix).append("RuntimeException(");
                StringBuffer msgBuffer = new StringBuffer();
                msgBuffer.append("Expected one of the following exceptions to be thrown from test method ").append(this.method.getSimpleName()).append(": ").append("[");
                for (i = 0; i < expectedExceptions.size(); ++i) {
                    String expectedException = expectedExceptions.get(i);
                    msgBuffer.append(expectedException).append(i < expectedExceptions.size() - 1 ? ", " : "");
                }
                msgBuffer.append("]");
                instr.append("new String(new char[] {");
                for (i = 0; i < msgBuffer.length(); ++i) {
                    instr.append((int)msgBuffer.charAt(i)).append(",");
                }
                instr.append("}));");
            } else {
                instr.append(1).append(";");
            }
            if (nonVoidReturn) {
                instr.append("return ").append(CloverNames.namespaceVariable("r")).append(";");
            }
            instr.append("}catch(").append(javaLangPrefix).append("Throwable ").append(CloverNames.namespaceVariable("t2")).append(")").append("{");
            if (expectsExceptions) {
                instr.append("if(");
                for (int i = 0; i < expectedExceptions.size(); ++i) {
                    String expectedException = expectedExceptions.get(i);
                    instr.append(CloverNames.namespaceVariable("t2")).append(" instanceof ").append(expectedException);
                    if (i >= expectedExceptions.size() - 1) continue;
                    instr.append("||");
                }
                instr.append("){").append(CloverNames.namespaceVariable("p")).append("=").append(1).append(";").append(CloverNames.namespaceVariable("t")).append("=null;}else{").append(CloverNames.namespaceVariable("p")).append("=").append(0).append(";").append(CloverNames.namespaceVariable("t")).append("=").append(CloverNames.namespaceVariable("t2")).append(";}");
            }
            instr.append("if(").append(CloverNames.namespaceVariable("p")).append("==").append(0).append("&&").append(CloverNames.namespaceVariable("t")).append("==null){").append(CloverNames.namespaceVariable("t")).append("=").append(CloverNames.namespaceVariable("t2")).append(";}");
            instr.append(Bindings.$CoverageRecorder$rethrow(state.getRecorderPrefix(), CloverNames.namespaceVariable("t2"))).append(";");
            if (nonVoidReturn) {
                instr.append("return ").append(MethodRegistrationNode.defaultNullValueForType(this.signature.getReturnType())).append(";");
            }
            instr.append("}");
            instr.append("finally{");
            instr.append(Bindings.$CoverageRecorder$globalSliceEnd(state.getRecorderPrefix(), typeInstr, "\"" + this.method.getQualifiedName() + "\"", Integer.toString(this.method.getDataIndex()), CloverNames.namespaceVariable("p"), CloverNames.namespaceVariable("t"))).append(";");
            instr.append("}}");
            instr.append(this.signature.getRenamedNormalisedSignature(syntheticTestName));
            this.setInstr(instr.toString());
        }
    }

    private static String defaultNullValueForType(String returnType) {
        return String.valueOf(DEFAULT_RETURN_VALUES.get(returnType));
    }

    public MethodSignature getSignature() {
        return this.signature;
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public void addContext(NamedContext ctx) {
        super.addContext(ctx);
        if (this.method != null) {
            this.method.addContext(ctx);
        }
    }

    static {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("boolean", "false");
        values.put("byte", "0");
        values.put("short", "0");
        values.put("char", "0");
        values.put("int", "0");
        values.put("long", "0l");
        values.put("float", "0f");
        values.put("double", "0d");
        DEFAULT_RETURN_VALUES = Collections.unmodifiableMap(values);
    }
}

