/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import cloverantlr.CharStreamException;
import cloverantlr.CharStreamIOException;
import cloverantlr.NoViableAltForCharException;
import cloverantlr.RecognitionException;
import cloverantlr.Token;
import cloverantlr.TokenStreamException;
import cloverantlr.TokenStreamIOException;
import cloverantlr.TokenStreamRecognitionException;
import com.atlassian.clover.instr.java.InstrumentationConfig;
import com.atlassian.clover.instr.java.JavaLexer;
import java.io.Reader;

public class UnicodeJavaLexer
extends JavaLexer {
    public static final int MIN_CODE_POINT = 0;
    public static final int MAX_CODE_POINT = 0x10FFFF;

    public UnicodeJavaLexer(Reader in, InstrumentationConfig cfg) {
        super(in, cfg);
        this.setTabSize(1);
    }

    public Token nextToken() throws TokenStreamException {
        this.resetText();
        try {
            if (Character.isJavaIdentifierStart(this.LA(1))) {
                this.mIDENT(true);
                int _ttype = 0;
                _ttype = this._returnToken.getType();
                this._returnToken.setType(_ttype);
                return this._returnToken;
            }
        }
        catch (CharStreamException cse) {
            if (cse instanceof CharStreamIOException) {
                throw new TokenStreamIOException(((CharStreamIOException)cse).io);
            }
            throw new TokenStreamException(cse.getMessage());
        }
        catch (RecognitionException e) {
            throw new TokenStreamRecognitionException(e);
        }
        return super.nextToken();
    }

    public final void mIDENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        char la1;
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 50;
        this.nc();
        switch (this.LA(1)) {
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': 
            case 'i': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 'p': 
            case 'q': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': 
            case 'z': {
                this.matchRange('a', 'z');
                break;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'J': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': {
                this.matchRange('A', 'Z');
                break;
            }
            case '_': {
                this.match('_');
                break;
            }
            case '$': {
                this.match('$');
                break;
            }
            default: {
                la1 = this.LA(1);
                if (Character.isJavaIdentifierStart(la1)) {
                    this.match(la1);
                    break;
                }
                throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
            }
        }
        block13: while (true) {
            switch (this.LA(1)) {
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    this.matchRange('a', 'z');
                    continue block13;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': {
                    this.matchRange('A', 'Z');
                    continue block13;
                }
                case '_': {
                    this.match('_');
                    continue block13;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.matchRange('0', '9');
                    continue block13;
                }
                case '$': {
                    this.match('$');
                    continue block13;
                }
            }
            la1 = this.LA(1);
            if (!Character.isJavaIdentifierPart(la1)) break;
            this.match(la1);
        }
        _ttype = this.testLiteralsTable(_ttype);
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public void mSTRING_LITERAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 143;
        if (this.inputState.guessing == 0) {
            this.nc();
        }
        this.match('\"');
        while (true) {
            if (this.LA(1) == '\\') {
                this.mESC(false);
                continue;
            }
            char la = this.LA(1);
            if (la == '\n' || la == '\"' || !UnicodeJavaLexer.isValidCodePoint(la)) break;
            this.match(la);
        }
        this.match('\"');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    public void mCHAR_LITERAL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
        Token _token = null;
        int _begin = this.text.length();
        int _ttype = 142;
        if (this.inputState.guessing == 0) {
            this.nc();
        }
        this.match('\'');
        if (this.LA(1) == '\\') {
            this.mESC(false);
        } else if (UnicodeJavaLexer.isValidCodePoint(this.LA(1))) {
            this.matchNot('\'');
        } else {
            throw new NoViableAltForCharException(this.LA(1), this.getFilename(), this.getLine(), this.getColumn());
        }
        this.match('\'');
        if (_createToken && _token == null && _ttype != -1) {
            _token = this.makeToken(_ttype);
            _token.setText(new String(this.text.getBuffer(), _begin, this.text.length() - _begin));
        }
        this._returnToken = _token;
    }

    private static boolean isValidCodePoint(int codePoint) {
        return codePoint >= 0 && codePoint <= 0x10FFFF;
    }
}

