/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.format;

import com.atlassian.clover.registry.RegistryFormatException;
import com.atlassian.clover.registry.format.BufferUtils;
import com.atlassian.clover.registry.format.LazyLoader;
import com.atlassian.clover.registry.format.LazyProxy;
import com.cenqua.clover.CoverageData;
import com.cenqua.clover.InMemPerTestCoverage;
import com.cenqua.clover.PerTestCoverage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;

public class CoverageSegment {
    public static final long NONE_IDX = -1L;
    private final LazyProxy<int[]> hitCounts;
    private final LazyProxy<InMemPerTestCoverage> perTestCoverage;

    public CoverageSegment(CoverageData coverageData) {
        this.hitCounts = new LazyProxy.Preloaded<int[]>(coverageData.getHitCounts());
        this.perTestCoverage = new LazyProxy.Preloaded<InMemPerTestCoverage>((InMemPerTestCoverage)coverageData.getPerTestCoverage());
    }

    public CoverageSegment(FileChannel channel) throws IOException {
        long endOfSegment = channel.position();
        final Footer footer = this.loadFooter(channel, endOfSegment);
        this.hitCounts = new LazyLoader<int[]>(channel, endOfSegment - 12L - (long)footer.perTestCovByteLen - (long)footer.covByteLen + 1L){

            @Override
            protected int[] getImpl(FileChannel channel) throws IOException, RegistryFormatException {
                return CoverageSegment.this.loadHitCounts(channel, footer.covByteLen);
            }

            @Override
            protected /* synthetic */ Object getImpl(FileChannel x0) throws IOException, RegistryFormatException {
                return this.getImpl(x0);
            }
        };
        this.perTestCoverage = new LazyLoader<InMemPerTestCoverage>(channel, endOfSegment - 12L - (long)footer.perTestCovByteLen + 1L){

            @Override
            protected InMemPerTestCoverage getImpl(FileChannel channel) throws IOException, RegistryFormatException {
                return CoverageSegment.this.loadPerTestCoverage(channel);
            }

            @Override
            protected /* synthetic */ Object getImpl(FileChannel x0) throws IOException, RegistryFormatException {
                return this.getImpl(x0);
            }
        };
    }

    public int[] getHitCounts() {
        return this.hitCounts.get();
    }

    public PerTestCoverage getPerTestCoverage() {
        return this.perTestCoverage.get();
    }

    private Footer loadFooter(FileChannel channel, long endOfSegment) throws IOException {
        channel.position(endOfSegment - 12L + 1L);
        ByteBuffer footerBuffer = BufferUtils.readFully(channel, ByteBuffer.allocate(12));
        Footer footer = new Footer(footerBuffer.getInt(), footerBuffer.getInt());
        if (footerBuffer.getInt() != 740096) {
            throw new IOException("CoverageSegment did not start with marker 0x" + Integer.toHexString(740096));
        }
        return footer;
    }

    private InMemPerTestCoverage loadPerTestCoverage(FileChannel channel) throws IOException {
        ObjectInputStream miis = new ObjectInputStream(new BufferedInputStream(Channels.newInputStream(channel)));
        try {
            return (InMemPerTestCoverage)miis.readObject();
        }
        catch (ClassNotFoundException e) {
            IOException exception = new IOException("Failed to read PerTestCoverage from stream");
            exception.initCause(e);
            throw exception;
        }
    }

    private int[] loadHitCounts(FileChannel channel, int covByteLen) throws IOException {
        ByteBuffer hitCountsBuffer = ByteBuffer.allocate(covByteLen);
        BufferUtils.readFully(channel, hitCountsBuffer);
        int[] hitCounts = new int[covByteLen / 4];
        hitCountsBuffer.asIntBuffer().get(hitCounts);
        return hitCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(FileChannel channel) throws IOException {
        long startPos = channel.position();
        BufferUtils.writeFully(channel, BufferUtils.toByteBuffer(this.hitCounts.get()));
        long afterCovPos = channel.position();
        ObjectOutputStream oos = new ObjectOutputStream(Channels.newOutputStream(channel));
        try {
            oos.writeObject(this.perTestCoverage.get());
        }
        finally {
            oos.flush();
        }
        long afterPerTestCovPos = channel.position();
        ByteBuffer headerBuffer = ByteBuffer.allocate(12);
        headerBuffer.putInt((int)(afterCovPos - startPos));
        headerBuffer.putInt((int)(afterPerTestCovPos - afterCovPos));
        headerBuffer.putInt(740096);
        headerBuffer.flip();
        BufferUtils.writeFully(channel, headerBuffer);
    }

    private static class Footer {
        public static final int SIZE = 12;
        public static final int MARKER = 740096;
        public final int covByteLen;
        public final int perTestCovByteLen;

        public Footer(int covByteLen, int perTestCovByteLen) {
            this.covByteLen = covByteLen;
            this.perTestCovByteLen = perTestCovByteLen;
        }
    }
}

