/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.format;

import com.atlassian.clover.registry.CloverRegistryException;
import com.atlassian.clover.registry.format.CoverageSegment;
import com.atlassian.clover.registry.format.InaccessibleRegFileException;
import com.atlassian.clover.registry.format.InstrSessionSegment;
import com.atlassian.clover.registry.format.RegAccessMode;
import com.atlassian.clover.registry.format.RegFile;
import com.atlassian.clover.registry.format.RegHeader;
import com.atlassian.clover.registry.format.UpdatableRegFile;
import com.cenqua.clover.CoverageData;
import com.cenqua.clover.registry.RegUpdate;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreshRegFile
extends RegFile<UpdatableRegFile> {
    private final RegAccessMode accessMode;
    private final String name;
    private final CoverageSegment coverageSegment;

    public FreshRegFile(File file, RegAccessMode accessMode, String name, CoverageData coverageData) {
        super(file);
        this.accessMode = accessMode;
        this.name = name;
        this.coverageSegment = coverageData == null ? null : new CoverageSegment(coverageData);
    }

    public FreshRegFile(File file, RegAccessMode accessMode, String name) {
        this(file, accessMode, name, null);
    }

    public FreshRegFile(RegFile regFile, CoverageData coverageData) {
        this(regFile.getFile(), regFile.getAccessMode(), regFile.getName(), coverageData);
    }

    private static File ensureFileAccessible(File file) throws InaccessibleRegFileException {
        File absFile = file.getAbsoluteFile();
        if (absFile.exists() && (!absFile.canWrite() || absFile.isDirectory())) {
            throw new InaccessibleRegFileException(new StringBuffer().append("Clover registry file: ").append(absFile.getAbsolutePath()).append(" already exists but cannot be overwritten or is a directory.").toString());
        }
        if (!absFile.exists() && absFile.getParentFile() != null && absFile.getParentFile().exists() && !absFile.getParentFile().canWrite()) {
            throw new InaccessibleRegFileException(new StringBuffer().append("Clover registry file: ").append(absFile.getAbsolutePath()).append(" cannot be written to (parent directory doesn't exist or can't be written to).").toString());
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UpdatableRegFile saveImpl(List<? extends RegUpdate> deltas) throws IOException, CloverRegistryException {
        if (deltas.size() == 0) {
            throw new IllegalArgumentException("At least one registry update is required for saving");
        }
        File registryFile = FreshRegFile.ensureFileAccessible(this.getFile());
        File tmpfile = new File(registryFile.getParentFile(), new StringBuffer().append(registryFile.getName()).append(".tmp").toString());
        File tmpParentFile = tmpfile.getParentFile();
        if (tmpParentFile != null) {
            tmpParentFile.mkdirs();
        }
        tmpfile.delete();
        FileChannel channel = new RandomAccessFile(tmpfile, "rw").getChannel();
        LinkedList<InstrSessionSegment> sessions = new LinkedList<InstrSessionSegment>();
        long finalVersion = deltas.get(deltas.size() - 1).getVersion();
        RegHeader header = new RegHeader(this.accessMode, finalVersion, 0, -1L, -1L, this.getName());
        try {
            long covLoc;
            channel.position(0L);
            header.write(channel);
            if (this.coverageSegment != null) {
                this.coverageSegment.write(channel);
                covLoc = channel.position() - 1L;
            } else {
                covLoc = -1L;
            }
            int maxSlotLength = 0;
            for (RegUpdate regUpdate : deltas) {
                maxSlotLength = Math.max(maxSlotLength, regUpdate.getSlotCount());
                InstrSessionSegment session = new InstrSessionSegment(regUpdate.getVersion(), regUpdate.getStartTs(), regUpdate.getEndTs(), this.toRecords(regUpdate.getFileInfos()), regUpdate.getContextStore());
                session.write(channel);
                sessions.add(session);
            }
            header = new RegHeader(this.accessMode, finalVersion, maxSlotLength, covLoc, channel.position() - 1L, this.getName());
            channel.position(0L);
            header.write(channel);
        }
        finally {
            channel.close();
        }
        if (registryFile.exists() && !registryFile.delete()) {
            throw new IOException(new StringBuffer().append("Can't delete existing registry file ").append(registryFile).toString());
        }
        if (!tmpfile.renameTo(registryFile)) {
            throw new IOException(new StringBuffer().append("Failed to move tmp registry file ").append(tmpfile).append(" to final registry file").toString());
        }
        registryFile.setLastModified(finalVersion);
        return new UpdatableRegFile(this.getFile(), header);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RegAccessMode getAccessMode() {
        return this.accessMode;
    }

    @Override
    public boolean isAppendable() {
        return false;
    }

    @Override
    protected /* synthetic */ RegFile saveImpl(List x0) throws IOException, CloverRegistryException {
        return this.saveImpl(x0);
    }
}

