/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.format;

import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Iterable;
import com.atlassian.clover.registry.CloverRegistryException;
import com.atlassian.clover.registry.format.FileInfoRecord;
import com.atlassian.clover.registry.format.RegAccessMode;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.RegUpdate;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegFile<CDR extends RegFile> {
    private final File file;
    private final AtomicBoolean saved = new AtomicBoolean(false);

    public RegFile(File file) {
        this.file = file;
    }

    public final CDR save(List<? extends RegUpdate> deltas) throws IOException, CloverRegistryException {
        if (!this.saved.getAndSet(true)) {
            return this.saveImpl(deltas);
        }
        throw new IllegalStateException("Registry file already committed to disk");
    }

    public final CDR save(RegUpdate delta) throws IOException, CloverRegistryException {
        return this.save(Collections.singletonList(delta));
    }

    protected abstract CDR saveImpl(List<? extends RegUpdate> var1) throws IOException, CloverRegistryException;

    public abstract String getName();

    public File getFile() {
        return this.file;
    }

    protected List<FileInfoRecord> toRecords(Object<FileInfo> fileInfos) {
        LinkedList<FileInfoRecord> recs = new LinkedList<FileInfoRecord>();
        Iterator i$ = _Iterable.iterator(fileInfos);
        while (i$.hasNext()) {
            FileInfo fileInfo = (FileInfo)i$.next();
            recs.add(new FileInfoRecord(fileInfo));
        }
        return recs;
    }

    public abstract RegAccessMode getAccessMode();

    public abstract boolean isAppendable();
}

