/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.ErrorInfo;
import com.cenqua.clover.LiveCoverageRecording;
import com.cenqua.clover.Logger;
import com.cenqua.clover.PerTestRecorder;
import com_cenqua_clover.Clover;
import com_cenqua_clover.CoverageRecorder;
import java.io.File;
import java.io.IOException;

public abstract class BaseCoverageRecorder
extends CoverageRecorder {
    private static final int MIN_INTERVAL = 200;
    private static final Class[] FORCE_THESE_TO_LOAD;
    protected boolean flushNeeded = true;
    protected long lastFlush = -1L;
    protected int flushInterval = 0;
    protected boolean useAlternate = false;
    protected Thread shutdownFlusher;
    protected Thread activeFlusher;
    private boolean activeFlush;
    private boolean directedOnly = false;
    private boolean shutdownHookEnabled = true;
    private boolean useCurrentThreadGroup = true;
    private boolean sliceFlushingEnabled = true;
    private boolean flushInProgress;
    private boolean keepFlushing;
    private final long initTS;
    private final int hashcode;
    protected final long dbVersion;
    protected final String dbName;
    protected final String recName;
    protected final String alternateRecName;
    protected final PerTestRecorder testCoverage;
    protected final WriteStrategy writeStrategy;
    static /* synthetic */ Class class$com$cenqua$clover$LiveCoverageRecording;
    static /* synthetic */ Class class$com$cenqua$clover$LiveCoverageRecording$ToFile;

    public BaseCoverageRecorder(String dbName, long dbVersion, long cfgbits, WriteStrategy writeStrategy) {
        this.processConfigBits(cfgbits);
        this.testCoverage = this.newPerSliceRecorder();
        this.writeStrategy = writeStrategy;
        this.dbVersion = dbVersion;
        if (this.flushInterval < 200) {
            this.flushInterval = 200;
        }
        this.dbName = dbName;
        this.hashcode = this.hashCode();
        this.initTS = System.currentTimeMillis();
        this.recName = Clover.getRecordingName(this.hashcode, dbName, this.initTS);
        this.alternateRecName = this.recName + ".1";
    }

    private PerTestRecorder newPerSliceRecorder() {
        String perTestDiff = System.getProperty("clover.pertest.coverage");
        if ("diff".equalsIgnoreCase(perTestDiff)) {
            return new PerTestRecorder.Diffing(this);
        }
        if ("off".equalsIgnoreCase(perTestDiff) || "none".equalsIgnoreCase(perTestDiff) || "false".equalsIgnoreCase(perTestDiff)) {
            return new PerTestRecorder.Null();
        }
        String perTestThreadingModel = System.getProperty("clover.pertest.coverage.threading");
        if ("volatile".equalsIgnoreCase(perTestThreadingModel)) {
            return new PerTestRecorder.Holder.Volatile(this);
        }
        if ("synchronized".equalsIgnoreCase(perTestThreadingModel)) {
            return new PerTestRecorder.Holder.Synchronized(this);
        }
        return new PerTestRecorder.Holder.SingleThreaded(this);
    }

    private void processConfigBits(long cfg) {
        this.flushInterval = (int)(cfg & Integer.MAX_VALUE);
        int cfgbits = (int)(cfg >> 32);
        int flushpolicy = cfgbits & 7;
        this.activeFlush = false;
        if (flushpolicy == 0) {
            this.directedOnly = true;
        } else if (flushpolicy == 2) {
            this.activeFlush = true;
        }
        this.useCurrentThreadGroup = (cfgbits & 0x100) != 0;
        this.shutdownHookEnabled = (cfgbits & 0x80) == 0;
        this.sliceFlushingEnabled = (cfgbits & 0x200) == 0;
    }

    protected String chooseRecordingName() {
        return this.useAlternate ? this.alternateRecName : this.recName;
    }

    protected String write(int[][] hits, int elementCount) throws IOException {
        return this.writeStrategy.write(this.chooseRecordingName(), this.dbVersion, this.lastFlush, hits, elementCount);
    }

    public void startRun() {
        this.createLiveRecordingFile();
        int slice = Clover.getCurrentSlice();
        if (slice != -1) {
            this.sliceStart(Clover.getCurrentType(), Clover.getCurrentSliceStart(), slice, Clover.getCurrentTestRunID());
        }
        if (this.activeFlush) {
            this.activeFlusher = new CloverFlushThread(this.getTargetThreadGroup());
            this.keepFlushing = true;
            this.activeFlusher.setDaemon(true);
            this.activeFlusher.start();
            Logger.getInstance().debug("Started active flush thread for registry at " + this.dbName + ", interval= " + this.flushInterval + "");
        }
        if (this.shutdownHookEnabled) {
            try {
                this.shutdownFlusher = new Thread(this.getTargetThreadGroup(), "CloverShutdownFlusher"){

                    public void run() {
                        if (BaseCoverageRecorder.this.activeFlush) {
                            BaseCoverageRecorder.this.keepFlushing = false;
                            BaseCoverageRecorder.this.activeFlusher.interrupt();
                        }
                        BaseCoverageRecorder.this.forceFlush(null);
                    }
                };
                Runtime.getRuntime().addShutdownHook(this.shutdownFlusher);
                Logger.getInstance().debug("Added shutdown hook for registry at " + this.dbName + "");
            }
            catch (Throwable t) {
                Logger.getInstance().verbose("Got exception registering a shutdown hook", t);
            }
        }
        Logger.getInstance().debug("Started recorder for registry at \"" + this.dbName + "\": " + this);
    }

    private void createLiveRecordingFile() {
        File liveRecFile = new File(this.dbName + ".liverec");
        if (!liveRecFile.exists()) {
            boolean created = false;
            IOException whyNot = null;
            try {
                created = !liveRecFile.createNewFile();
                liveRecFile.deleteOnExit();
            }
            catch (IOException e) {
                whyNot = e;
            }
            if (!created) {
                Logger.getInstance().verbose("Failed to newly create the recording-is-live flag file at " + liveRecFile.getAbsolutePath(), whyNot);
            }
        }
    }

    private ThreadGroup getTargetThreadGroup() {
        ThreadGroup target = Thread.currentThread().getThreadGroup();
        if (this.useCurrentThreadGroup) {
            return target;
        }
        ThreadGroup parent = target;
        while (parent != null) {
            target = parent;
            parent = target.getParent();
        }
        return target;
    }

    public String getRecordingName() {
        return this.recName;
    }

    public long getDbVersion() {
        return this.dbVersion;
    }

    public String getDbName() {
        return this.dbName;
    }

    public Thread getShutdownFlusher() {
        return this.shutdownFlusher;
    }

    public void flushNeeded() {
        this.flushNeeded = true;
    }

    public void maybeFlush() {
        if (this.directedOnly || this.activeFlush) {
            return;
        }
        if (System.currentTimeMillis() - this.lastFlush > (long)this.flushInterval) {
            this.forceFlush();
        }
    }

    public void forceFlush() {
        this.forceFlush(Logger.getInstance());
    }

    public void flush() {
        this.flush(Logger.getInstance());
    }

    private void forceFlush(Logger logger) {
        this.flushNeeded = true;
        this.flush(logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(Logger logger) {
        if (!this.flushNeeded || this.flushInProgress) {
            return;
        }
        String string = this.recName;
        synchronized (string) {
            long now = System.currentTimeMillis();
            this.lastFlush = this.lastFlush >= now ? this.lastFlush + 1L : now;
            try {
                this.flushInProgress = true;
                String memento = this.write();
                boolean bl = this.useAlternate = !this.useAlternate;
                if (logger != null) {
                    logger.debug("[flushed recorder \"" + memento + "\" (file = \"" + (!this.useAlternate ? this.alternateRecName : this.recName) + "\", writeTimestamp = " + this.lastFlush + ", now = " + now + ")]");
                }
                this.flushNeeded = false;
            }
            catch (Exception e) {
                this.logFlushProblem(logger, e);
            }
            catch (Error e) {
                this.logFlushProblem(logger, e);
                throw e;
            }
            finally {
                this.flushInProgress = false;
            }
        }
    }

    private void logFlushProblem(Logger logger, Throwable t) {
        if (logger != null) {
            logger.error(t.getClass().getName() + " flushing coverage for recorder " + this.recName + ": " + t.getMessage());
        }
    }

    public void sliceStart(String runtimeType, long ts, int id, int rid) {
        if (this.sliceFlushingEnabled) {
            this.testCoverage.testStarted(runtimeType, ts, id, rid);
        }
    }

    public void sliceEnd(String runtimeType, String method, long ts, int id, int rid, int exitStatus, ErrorInfo ei) {
        if (this.sliceFlushingEnabled) {
            Logger logger = Logger.getInstance();
            try {
                String memento = this.testCoverage.testFinished(runtimeType, method, ts, id, rid, exitStatus, ei).transcribe();
                logger.debug("[flushed per-test recording (" + memento + ") ]");
            }
            catch (Exception e) {
                logger.error(e.getClass().getName() + " flushing per-test coverage for recorder " + this.recName + ": " + e.getMessage());
            }
            catch (Error e) {
                logger.error(e.getClass().getName() + " flushing per-test coverage for recorder " + this.recName + ": " + e.getMessage());
                throw e;
            }
        }
    }

    protected abstract String write() throws IOException;

    public abstract void inc(int var1);

    public abstract int iget(int var1);

    static {
        Class<?> clazz;
        Class[] classArray = new Class[3];
        Class clazz2 = class$com$cenqua$clover$LiveCoverageRecording;
        if (clazz2 == null) {
            clazz2 = classArray[0] = (class$com$cenqua$clover$LiveCoverageRecording = new LiveCoverageRecording[0].getClass().getComponentType());
        }
        if ((clazz = class$com$cenqua$clover$LiveCoverageRecording$ToFile) == null) {
            clazz = class$com$cenqua$clover$LiveCoverageRecording$ToFile = new LiveCoverageRecording.ToFile[0].getClass().getComponentType();
        }
        classArray[1] = clazz;
        classArray[2] = LiveCoverageRecording.ToFile.REQUIRED_CLASSES.getClass();
        FORCE_THESE_TO_LOAD = classArray;
    }

    static interface WriteStrategy {
        public static final WriteStrategy TO_FILE = new WriteStrategy(){

            public String write(String recordingFileName, long dbVersion, long lastFlush, int[][] hits, int elementCount) throws IOException {
                return new LiveCoverageRecording.ToFile(recordingFileName, dbVersion, lastFlush, hits, elementCount).transcribe();
            }
        };

        public String write(String var1, long var2, long var4, int[][] var6, int var7) throws IOException;
    }

    class CloverFlushThread
    extends Thread {
        public CloverFlushThread(ThreadGroup group) {
            super(group, "CloverFlushThread");
        }

        public void requestFlush() {
            BaseCoverageRecorder.this.forceFlush();
        }

        public void run() {
            while (BaseCoverageRecorder.this.keepFlushing) {
                try {
                    Thread.sleep(BaseCoverageRecorder.this.flushInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!BaseCoverageRecorder.this.keepFlushing || System.currentTimeMillis() - BaseCoverageRecorder.this.lastFlush < (long)BaseCoverageRecorder.this.flushInterval) continue;
                BaseCoverageRecorder.this.flush();
            }
        }
    }
}

