/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.CloverException;
import com.cenqua.clover.CloverLicense;
import com.cenqua.clover.CloverLicenseInfo;
import com.cenqua.clover.Logger;
import com.cenqua.clover.util.ClassPathUtil;
import com.cenqua.clover.util.format.ConsoleFormatter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class CloverStartup {
    private static LicenseLoader licenseLoader = new LicenseFileLoader();
    public static final long EVAL_PERIOD = 2592000000L;
    public static final long MAINT_SLACK = 604800000L;

    public static void loadLicense(Logger log) {
        CloverStartup.loadLicense(log, true, 0L);
    }

    public static void loadLicense(Logger log, boolean fail) {
        CloverStartup.loadLicense(log, fail, 0L);
    }

    public static void loadLicense(Logger log, boolean fail, long pluginInstallTs) {
        long buildDate;
        CloverStartup.logVersionInfo(log);
        String licenseCert = System.getProperty("clover.license.cert");
        CloverLicense license = licenseCert != null ? new LicenseCertLoader(licenseCert).loadLicense(log) : licenseLoader.loadLicense(log);
        if (license == null) {
            CloverStartup.terminate("Invalid or missing License.", " Please visit http://my.atlassian.com to obtain a valid license.");
            if (fail) {
                throw new RuntimeException(CloverLicenseInfo.TERMINATION_STMT + "." + CloverLicenseInfo.CONTACT_INFO_STMT);
            }
            return;
        }
        boolean checkMaintenance = true;
        if ("Clover Maven Plugin".equalsIgnoreCase(license.getOrganisation()) || "Clover Grails Plugin".equalsIgnoreCase(license.getOrganisation())) {
            File cloverJar = new File(ClassPathUtil.getCloverJarPath());
            if (cloverJar.exists() && cloverJar.canRead()) {
                license = CloverStartup.createEvalLicense(license, cloverJar.lastModified());
                checkMaintenance = false;
            }
        } else if (CloverStartup.isBuiltInEvaluationLicense(license)) {
            license = CloverStartup.createEvalLicense(license, pluginInstallTs);
            checkMaintenance = false;
        }
        if (license.isTerminated()) {
            if (fail) {
                throw new RuntimeException(license.getTerminationStatement() + "." + license.getContactInfoStatement());
            }
            CloverStartup.terminate(license.getTerminationStatement(), license.getContactInfoStatement());
        } else {
            CloverLicenseInfo.TERMINATED = false;
        }
        SimpleDateFormat df = new SimpleDateFormat("MMMM dd yyyy", Locale.US);
        try {
            buildDate = df.parse("April 13 2010").getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException("Internal Error: could not determine build date.");
        }
        if (checkMaintenance && license.maintenanceExpires() && buildDate > license.getMaintExpiry() + 604800000L) {
            CloverStartup.terminate("Clover upgrades for your license ended " + df.format(new Date(license.getMaintExpiry())) + ", and this version of Clover was built " + "April 13 2010", " Please visit http://www.atlassian.com/clover/renew for information on upgrading your license.");
            if (fail) {
                throw new RuntimeException(CloverLicenseInfo.TERMINATION_STMT + "." + CloverLicenseInfo.CONTACT_INFO_STMT);
            }
            return;
        }
        CloverLicenseInfo.NAME = license.getLicenseName();
        CloverLicenseInfo.SEN = license.getSupportEntitlementNumber();
        CloverLicenseInfo.OWNER_STMT = license.getOwnerStatement();
        CloverLicenseInfo.CONTACT_INFO_STMT = license.getContactInfoStatement();
        CloverLicenseInfo.PRE_EXPIRY_STMT = license.getPreExpiryStatement();
        CloverLicenseInfo.POST_EXPIRY_STMT = license.getPostExpiryStatement();
        CloverLicenseInfo.EXPIRED = license.isExpired();
        CloverLicenseInfo.EXPIRES = license.expires();
        CloverLicenseInfo.ALLOWED_PKG_PREFIXES = license.getAllowedPkgPrefixes();
        CloverLicenseInfo.DAYS_REMAINING = license.getDaysTillExpiry();
        CloverStartup.evaluateDaysLeft(CloverLicenseInfo.DAYS_REMAINING);
        long l = CloverLicenseInfo.PERMS = CloverLicenseInfo.TERMINATED ? 0L : license.getFeaturesSupported();
        if (!CloverLicenseInfo.EXPIRED) {
            log.info(ConsoleFormatter.format(CloverLicenseInfo.OWNER_STMT));
            if (CloverLicenseInfo.PRE_EXPIRY_STMT != null && CloverLicenseInfo.PRE_EXPIRY_STMT.length() > 0) {
                log.info(ConsoleFormatter.format(CloverLicenseInfo.PRE_EXPIRY_STMT));
            }
        } else {
            log.info(ConsoleFormatter.format(CloverLicenseInfo.OWNER_STMT));
            log.info(ConsoleFormatter.format(CloverLicenseInfo.POST_EXPIRY_STMT));
            log.info(ConsoleFormatter.format(CloverLicenseInfo.CONTACT_INFO_STMT));
        }
    }

    public static boolean isBuiltInEvaluationLicense(CloverLicense license) {
        return "Clover Plugin".equalsIgnoreCase(license.getOrganisation());
    }

    private static CloverLicense createEvalLicense(CloverLicense license, long installTs) {
        long softExp = installTs + 2592000000L;
        long hardExp = softExp + 604800000L;
        return new CloverLicense(license.getLicenseName(), license.getOrganisation(), license.getPreExpiryStatement(), license.getPostExpiryStatement(), license.getTerminationStatement(), license.getContactInfoStatement(), softExp, hardExp, license.getFeaturesSupported());
    }

    private static void terminate(String terminationStatement, String contactInfoStatement) {
        CloverLicenseInfo.TERMINATED = true;
        CloverLicenseInfo.EXPIRED = true;
        CloverLicenseInfo.EXPIRES = true;
        CloverLicenseInfo.PERMS = 0L;
        CloverLicenseInfo.NAME = null;
        CloverLicenseInfo.OWNER_STMT = null;
        CloverLicenseInfo.CONTACT_INFO_STMT = null;
        CloverLicenseInfo.PRE_EXPIRY_STMT = null;
        CloverLicenseInfo.POST_EXPIRY_STMT = null;
        CloverLicenseInfo.ALLOWED_PKG_PREFIXES = null;
        CloverLicenseInfo.TERMINATION_STMT = terminationStatement;
        CloverLicenseInfo.CONTACT_INFO_STMT = contactInfoStatement;
    }

    public static void logVersionInfo(Logger log) {
        log.info("Clover Version 3.0.2, built on April 13 2010 (build-790)");
        String loadedFrom = ClassPathUtil.getCloverJarPath();
        if (loadedFrom != null) {
            log.info("Loaded from: " + loadedFrom);
        } else {
            log.debug("Couldn't determine path we were loaded from.");
        }
    }

    public static void permsCheck(long feature) {
        if (!CloverStartup.hasPermission(feature)) {
            throw new RuntimeException("Sorry, you are not licensed to use the requested feature.");
        }
    }

    public static boolean hasPermission(long feature) {
        return !CloverLicenseInfo.TERMINATED && (CloverLicenseInfo.PERMS & feature) != 0L;
    }

    public static void setLicenseLoader(LicenseLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException("CloverStartup does not support a 'null' LicenseLoader.");
        }
        licenseLoader = loader;
    }

    private static void evaluateDaysLeft(long daysLeft) {
        if (daysLeft < 0L) {
            daysLeft = 0L;
        }
        String target = "$daysleft";
        StringBuffer preExpBuf = new StringBuffer();
        int length = CloverLicenseInfo.PRE_EXPIRY_STMT.length();
        int i = 0;
        while (i < length) {
            char c = CloverLicenseInfo.PRE_EXPIRY_STMT.charAt(i);
            if (c == '$' && CloverLicenseInfo.PRE_EXPIRY_STMT.substring(i).toLowerCase().startsWith(target)) {
                preExpBuf.append(daysLeft);
                i += target.length();
                continue;
            }
            preExpBuf.append(c);
            ++i;
        }
        CloverLicenseInfo.PRE_EXPIRY_STMT = preExpBuf.toString();
    }

    public static final class LicenseCertLoader
    implements LicenseLoader {
        final String license;

        public LicenseCertLoader(String licenseCert) {
            this.license = licenseCert;
        }

        public CloverLicense loadLicense(Logger log) {
            try {
                return new CloverLicense(this.license);
            }
            catch (CloverException e) {
                log.error("Error loading license: " + e.getMessage(), e);
                return null;
            }
        }
    }

    public static final class LicenseFileLoader
    implements LicenseLoader {
        static /* synthetic */ Class class$com$cenqua$clover$CloverStartup;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CloverLicense loadLicense(Logger log) {
            File licenseFile = null;
            String licenseFilename = System.getProperty("clover.license.path");
            if (licenseFilename != null) {
                licenseFile = new File(licenseFilename);
            } else {
                String cloverJarPath = ClassPathUtil.getCloverJarPath();
                if (cloverJarPath != null) {
                    File parentDir = new File(cloverJarPath).getParentFile();
                    licenseFile = new File(parentDir, "clover.license");
                    licenseFilename = licenseFile.getAbsolutePath();
                } else {
                    log.verbose("Couldn't determine Clover's jar path.");
                }
            }
            InputStream in = null;
            if (licenseFile != null && licenseFile.exists() && licenseFile.isFile()) {
                try {
                    in = new BufferedInputStream(new FileInputStream(licenseFile));
                    log.verbose("Loading license from: " + licenseFile.getAbsolutePath());
                }
                catch (IOException e) {
                    log.verbose("License at '" + licenseFile + "' could not be opened for reading.");
                }
            } else {
                log.verbose("License not found at '" + licenseFilename + "'");
            }
            if (in == null) {
                log.verbose("Looking for license on the classpath");
                Class<?> clazz = class$com$cenqua$clover$CloverStartup;
                if (clazz == null) {
                    clazz = class$com$cenqua$clover$CloverStartup = new CloverStartup[0].getClass().getComponentType();
                }
                in = clazz.getResourceAsStream("/clover.license");
            }
            if (in != null) {
                CloverLicense e;
                try {
                    e = new CloverLicense(CloverLicense.readFrom(in));
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        log.error("Error reading license: " + e2.getMessage());
                    }
                    catch (CloverException e3) {
                        log.error("Invalid license: " + e3.getMessage());
                    }
                }
                in.close();
                return e;
            } else {
                log.error("No license file found.");
            }
            return null;
        }
    }

    public static interface LicenseLoader {
        public static final String LICENSE_FILE_NAME = "clover.license";

        public CloverLicense loadLicense(Logger var1);
    }
}

