/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.BaseRecording;
import com.cenqua.clover.ErrorInfo;
import com.cenqua.clover.Logger;
import com.cenqua.clover.PerTestRecording;
import com.cenqua.clover.RuntimeType;
import com.cenqua.clover.util.CloverBitSet;
import com.cenqua.clover.util.FileUtils;
import com_cenqua_clover.Clover;
import com_cenqua_clover.CoverageRecorder;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;

public interface LivePerTestRecording
extends PerTestRecording {
    public static final LivePerTestRecording NULL = new LivePerTestRecording(){

        public String getTestTypeName() {
            return null;
        }

        public String getTestMethodName() {
            return null;
        }

        public int getExitStatus() {
            return -1;
        }

        public long getStart() {
            return 0L;
        }

        public long getEnd() {
            return 0L;
        }

        public boolean hasResult() {
            return false;
        }

        public boolean isResultPassed() {
            return false;
        }

        public String getStackTrace() {
            return null;
        }

        public String getExitMessage() {
            return null;
        }

        public String transcribe() {
            return null;
        }

        public long getDbVersion() {
            return 0L;
        }

        public int getFormat() {
            return 1;
        }
    };

    public String transcribe() throws IOException;

    public static class ToFile
    extends BaseRecording
    implements LivePerTestRecording {
        private final CloverBitSet coverage;
        private final String testTypeName;
        private final String testMethodName;
        private final long start;
        private final String exitMessage;
        private final String stackTrace;
        private final int exitStatus;

        public ToFile(String dbName, long dbVersion, int recorderId, CloverBitSet coverage, String testMethodName, long start, long end, RuntimeType testType, int slice, int testRunId, int exitStatus, ErrorInfo errorInfo) {
            super(new BaseRecording.Header(dbVersion, end, 1), new File(Clover.getSliceRecordingName(testType.id, slice, testRunId, recorderId, dbName, start)));
            this.coverage = coverage;
            this.testTypeName = testType.name;
            this.testMethodName = testMethodName;
            this.start = start;
            this.exitStatus = exitStatus;
            this.exitMessage = errorInfo == null ? null : errorInfo.getMessage();
            this.stackTrace = errorInfo == null ? null : errorInfo.getStackTrace();
        }

        public ToFile(CoverageRecorder recorder, CloverBitSet coverage, String testMethodName, long start, long end, RuntimeType testType, int slice, int testRunId, int exitStatus, ErrorInfo errorInfo) {
            this(recorder.getDbName(), recorder.getDbVersion(), recorder.hashCode(), coverage, testMethodName, start, end, testType, slice, testRunId, exitStatus, errorInfo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String transcribe() throws IOException {
            File file = this.createCoverageFolderFor(this.fileOnDisk);
            DataOutputStream out = new DataOutputStream(FileUtils.createDeflateOutputStream(file));
            try {
                this.header.write(out);
                out.writeUTF(this.testTypeName);
                out.writeUTF(this.testMethodName);
                out.writeInt(this.exitStatus);
                if (this.exitStatus == 0) {
                    FileUtils.writeChars(this.exitMessage, out);
                    FileUtils.writeChars(this.stackTrace, out);
                }
                out.writeLong(this.start);
                this.coverage.write(out);
                out.flush();
            }
            catch (IOException e) {
                Logger.getInstance().error("IO Exception flushing sliced coverage for recorder: " + this.fileOnDisk.getAbsolutePath(), e);
            }
            finally {
                out.close();
            }
            return file.getAbsolutePath();
        }

        public boolean get(int sliceIndex) {
            return this.coverage.member(sliceIndex);
        }

        public String getTestTypeName() {
            return this.testTypeName;
        }

        public String getTestMethodName() {
            return this.testMethodName;
        }

        public String getExitMessage() {
            return this.exitMessage;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        public int getExitStatus() {
            return this.exitStatus;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.header.getWriteTimeStamp();
        }

        public boolean hasResult() {
            return this.exitStatus != -1;
        }

        public boolean isResultPassed() {
            return this.exitStatus == 1;
        }
    }
}

