/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import clover.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import clover.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import clover.it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import clover.it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import clover.it.unimi.dsi.fastutil.ints.IntArrayList;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Integer;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._String;
import com.cenqua.clover.BasePerTestCoverage;
import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.Logger;
import com.cenqua.clover.PerTestRecordingTranscript;
import com.cenqua.clover.RecordingTranscripts;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.CoverageDataRange;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FileInfoVisitor;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.util.CloverBitSet;
import com.cenqua.clover.util.SizedLRUCacheMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamplingPerTestCoverage
extends BasePerTestCoverage {
    private final FileInfoSample[] fileInfoSamples;
    private final Int2ObjectSortedMap fileIdxToSamplings;
    private final Int2ObjectMap tciIdsToRecordingFiles;
    private final Int2ObjectMap tciIdToTCIMap;
    private final CoverageDataSpec spec;
    private final SizedLRUCacheMap<String, CloverBitSet> coverageCache;
    private BitSet coverageMask;
    private BitSet passOnlyCoverageMask;

    public SamplingPerTestCoverage(Clover2Registry registry, CoverageDataSpec spec, int estPerTestRecordings) {
        super(registry.getDataLength());
        this.spec = spec;
        final LinkedList fileSamples = new LinkedList();
        final IntArrayList methodIdx = new IntArrayList();
        registry.getProject().visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo file) {
                Iterator i$ = file.getClasses().iterator();
                while (i$.hasNext()) {
                    ClassInfo classInfo = (ClassInfo)i$.next();
                    MethodInfo[] arr$ = classInfo.getMethods();
                    int len$ = arr$.length;
                    for (int i$2 = 0; i$2 < len$; ++i$2) {
                        MethodInfo methodInfo = arr$[i$2];
                        methodIdx.add(methodInfo.getDataIndex());
                    }
                }
                fileSamples.add(new FileInfoSample(((FileInfo)file).getDataIndex(), methodIdx.toIntArray()));
                methodIdx.clear();
            }
        });
        this.fileInfoSamples = fileSamples.toArray(new FileInfoSample[fileSamples.size()]);
        Arrays.sort(this.fileInfoSamples, new Comparator<FileInfoSample>(){

            @Override
            public int compare(FileInfoSample fs1, FileInfoSample fs2) {
                return fs1.idx - fs2.idx;
            }

            @Override
            public /* synthetic */ int compare(Object x0, Object x1) {
                return this.compare((FileInfoSample)x0, (FileInfoSample)x1);
            }
        });
        this.fileIdxToSamplings = new Int2ObjectRBTreeMap();
        for (int i = 0; i < this.fileInfoSamples.length; ++i) {
            FileInfoSample fileSample = this.fileInfoSamples[i];
            this.fileIdxToSamplings.put(fileSample.idx, fileSample);
        }
        this.tciIdsToRecordingFiles = new Int2ObjectOpenHashMap();
        this.tciIdToTCIMap = new Int2ObjectOpenHashMap();
        this.coverageCache = new SizedLRUCacheMap(spec.getPerTestStorageSize().getSizeInBytes(), estPerTestRecordings, 1.1f);
    }

    @Override
    public void addCoverage(TestCaseInfo tci, PerTestRecordingTranscript recording) {
        CloverBitSet coverage = recording.getCoverage();
        for (int i = 0; i < this.fileInfoSamples.length; ++i) {
            this.fileInfoSamples[i].sample(tci, coverage);
        }
        HashSet<String> pathsToCoverage = (HashSet<String>)this.tciIdsToRecordingFiles.get(tci.getId());
        if (pathsToCoverage == null) {
            pathsToCoverage = new HashSet<String>();
            this.tciIdsToRecordingFiles.put(tci.getId(), pathsToCoverage);
        }
        pathsToCoverage.add(recording.getFile().getAbsolutePath());
        this.tciIdToTCIMap.put(tci.getId(), tci);
    }

    @Override
    public boolean hasPerTestData() {
        return !this.tciIdToTCIMap.isEmpty();
    }

    @Override
    public BitSet getAllHits() {
        if (this.coverageMask == null) {
            this.initMasks();
        }
        return (BitSet)this.coverageMask.clone();
    }

    private synchronized CloverBitSet getCoverageFor(String pathToCoverageFile) throws IOException {
        CloverBitSet coverage = (CloverBitSet)this.coverageCache.get(pathToCoverageFile);
        if (coverage == null) {
            File coverageFile = new File(pathToCoverageFile);
            coverage = RecordingTranscripts.readSliceFromDisk(coverageFile.getParentFile(), coverageFile.getName(), this.spec).getCoverage();
            this.coverageCache.put(pathToCoverageFile, coverage);
        }
        return coverage;
    }

    private BitSet getHitsFor(TestCaseInfo tci, BitSet result) {
        Set pathsToCoverage = (Set)this.tciIdsToRecordingFiles.get(tci.getId());
        if (pathsToCoverage != null) {
            for (String pathToCoverage : pathsToCoverage) {
                try {
                    this.getCoverageFor(pathToCoverage).applyTo(result);
                }
                catch (IOException e) {
                    Logger.getInstance().error(new StringBuffer().append("Failed to load per-test coverage file \"").append(pathToCoverage).append("\"").toString());
                }
            }
        }
        return result;
    }

    @Override
    public BitSet getHitsFor(TestCaseInfo tci) {
        return this.getHitsFor(tci, new BitSet(this.coverageSize));
    }

    @Override
    public BitSet getHitsFor(Set<TestCaseInfo> tcis) {
        BitSet result = new BitSet(this.coverageSize);
        for (TestCaseInfo tci : tcis) {
            this.getHitsFor(tci, result);
        }
        return result;
    }

    @Override
    public BitSet getHitsFor(Set<TestCaseInfo> tcis, CoverageDataRange range) {
        BitSet hits = this.getHitsFor(tcis);
        if (range != null) {
            BitSet mask = new BitSet();
            mask.set(range.getDataIndex(), range.getDataIndex() + range.getDataLength());
            hits.and(mask);
        }
        return hits;
    }

    @Override
    public BitSet getPassOnlyHits() {
        if (this.passOnlyCoverageMask == null) {
            this.initMasks();
        }
        return (BitSet)this.passOnlyCoverageMask.clone();
    }

    @Override
    public TestCaseInfo getTestById(int id) {
        return (TestCaseInfo)this.tciIdToTCIMap.get(id);
    }

    @Override
    public Set<TestCaseInfo> getTests() {
        return new HashSet<TestCaseInfo>(this.tciIdToTCIMap.values());
    }

    @Override
    public Set<TestCaseInfo> getTestsCovering(CoverageDataRange range) {
        Int2ObjectSortedMap head;
        int endIdx;
        HashSet<TestCaseInfo> tcis = new HashSet<TestCaseInfo>();
        int startIdx = range.getDataIndex();
        Int2ObjectSortedMap subFileIdxToSamplings = this.fileIdxToSamplings.subMap(startIdx, (endIdx = range.getDataLength() + range.getDataIndex()) + 1);
        if ((subFileIdxToSamplings.isEmpty() || subFileIdxToSamplings.firstIntKey() != startIdx) && !(head = this.fileIdxToSamplings.headMap(startIdx)).isEmpty()) {
            subFileIdxToSamplings = new Int2ObjectRBTreeMap(subFileIdxToSamplings);
            subFileIdxToSamplings.put(head.lastIntKey(), head.get(head.lastIntKey()));
        }
        Iterator iterator = subFileIdxToSamplings.values().iterator();
        while (iterator.hasNext()) {
            tcis.addAll(((FileInfoSample)iterator.next()).tcis);
        }
        Iterator tciIter = tcis.iterator();
        block3: while (tciIter.hasNext()) {
            Set pathToCoverageFiles = (Set)this.tciIdsToRecordingFiles.get(((TestCaseInfo)tciIter.next()).getId());
            if (pathToCoverageFiles == null) continue;
            for (String pathToCoverageFile : pathToCoverageFiles) {
                try {
                    CloverBitSet bitSet = this.getCoverageFor(pathToCoverageFile);
                    int firstBitSetAfterRange = bitSet.nextSetBit(startIdx);
                    if (firstBitSetAfterRange < startIdx || firstBitSetAfterRange >= endIdx) continue;
                    continue block3;
                }
                catch (IOException e) {
                    Logger.getInstance().warn(_String.format("Failed to load coverage file: \"%s\" while calculating hits in range [%d,%d]", new Object[]{pathToCoverageFile, _Integer.valueOf(range.getDataIndex()), _Integer.valueOf(range.getDataIndex() + range.getDataLength())}), e);
                }
            }
            tciIter.remove();
        }
        return tcis;
    }

    @Override
    public Map<TestCaseInfo, BitSet> mapTestsAndCoverageForFile(FileInfo fileInfo) {
        HashMap<TestCaseInfo, BitSet> tcisAndCoverage = new HashMap<TestCaseInfo, BitSet>();
        FileInfoSample fileSample = (FileInfoSample)this.fileIdxToSamplings.get(fileInfo.getDataIndex());
        if (fileSample != null) {
            int minBitSize = fileInfo.getDataIndex() + fileInfo.getDataLength();
            for (TestCaseInfo tci : fileSample.tcis) {
                BitSet totalTciCoverage = new BitSet(minBitSize);
                Set pathToCoverageFiles = (Set)this.tciIdsToRecordingFiles.get(tci.getId());
                if (pathToCoverageFiles == null) continue;
                for (String pathToCoverageFile : pathToCoverageFiles) {
                    try {
                        CloverBitSet coverageForFile = this.getCoverageFor(pathToCoverageFile);
                        tcisAndCoverage.put(tci, coverageForFile.applyTo(totalTciCoverage));
                    }
                    catch (IOException e) {
                        Logger.getInstance().warn(_String.format("Failed to load coverage file: \"%s\" while calculating hits in range [%d,%d]", new Object[]{pathToCoverageFile, _Integer.valueOf(fileInfo.getDataIndex()), _Integer.valueOf(fileInfo.getDataIndex() + fileInfo.getDataLength())}), e);
                    }
                }
            }
        }
        return tcisAndCoverage;
    }

    @Override
    protected void initMasks() {
        BitSet coverageMask = new BitSet(this.coverageSize);
        BitSet passOnlyCoverageMask = new BitSet(this.coverageSize);
        BitSet coverageNotUniqueMask = new BitSet(this.coverageSize);
        for (Map.Entry entry : this.tciIdsToRecordingFiles.entrySet()) {
            boolean success = ((TestCaseInfo)this.tciIdToTCIMap.get((Integer)entry.getKey())).isSuccess();
            Set pathsToCoverageFiles = (Set)entry.getValue();
            if (pathsToCoverageFiles.size() <= 0) continue;
            for (String pathToCoverageFile : pathsToCoverageFiles) {
                try {
                    CloverBitSet coverage = this.getCoverageFor(pathToCoverageFile);
                    int i = coverage.nextSetBit(0);
                    while (i >= 0) {
                        if (success) {
                            passOnlyCoverageMask.set(i);
                        }
                        if (coverageMask.get(i)) {
                            coverageNotUniqueMask.set(i);
                        } else {
                            coverageMask.set(i);
                        }
                        i = coverage.nextSetBit(i + 1);
                    }
                }
                catch (IOException e) {
                    Logger.getInstance().warn(_String.format("Failed to load coverage file while calculating unique coverage mask: \"%s\"", new Object[]{pathToCoverageFile}), e);
                }
            }
        }
        coverageNotUniqueMask.flip(0, coverageNotUniqueMask.size());
        this.coverageMask = coverageMask;
        this.uniqueCoverageMask = coverageNotUniqueMask;
        this.passOnlyCoverageMask = passOnlyCoverageMask;
    }

    private class FileInfoSample {
        private final int idx;
        private final int[] methodIdx;
        private final Set<TestCaseInfo> tcis;

        private FileInfoSample(int idx, int[] methodIdx) {
            this.idx = idx;
            this.methodIdx = methodIdx;
            this.tcis = new HashSet<TestCaseInfo>();
        }

        public void sample(TestCaseInfo tci, CloverBitSet coverage) {
            for (int i = 0; i < this.methodIdx.length; ++i) {
                if (!coverage.member(this.methodIdx[i])) continue;
                this.tcis.add(tci);
            }
        }
    }
}

