/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.context;

import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.cenqua.clover.util.CloverBitSet;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextSet
implements TaggedPersistent {
    private final CloverBitSet bitSet;

    public static ContextSet remap(ContextSet orig, Map<Integer, Integer> mapping) {
        CloverBitSet res = new CloverBitSet();
        CloverBitSet bs = orig.bitSet;
        for (int i = 0; i < bs.length(); ++i) {
            Integer mapValue;
            if (!bs.member(i) || (mapValue = mapping.get(new Integer(i))) == null) continue;
            res.add(mapValue);
        }
        return new ContextSet(res);
    }

    public ContextSet() {
        this.bitSet = new CloverBitSet(19);
    }

    public ContextSet(int size) {
        this.bitSet = new CloverBitSet(size);
    }

    public ContextSet(ContextSet copy) {
        this.bitSet = (CloverBitSet)copy.bitSet.clone();
    }

    private ContextSet(CloverBitSet bitSet) {
        this.bitSet = bitSet;
    }

    public boolean get(int bitIndex) {
        return this.bitSet.member(bitIndex);
    }

    public boolean intersects(ContextSet other) {
        return this.bitSet.intersects(other.bitSet);
    }

    public int nextSetBit(int fromIndex) {
        return this.bitSet.nextSetBit(fromIndex);
    }

    public int size() {
        return this.bitSet.size();
    }

    public ContextSet and(ContextSet set) {
        return new ContextSet(this.bitSet.and(set.bitSet));
    }

    public ContextSet clear(int bitIndex) {
        CloverBitSet clone = (CloverBitSet)this.bitSet.clone();
        clone.clear(bitIndex);
        return new ContextSet(clone);
    }

    public ContextSet or(ContextSet set) {
        return new ContextSet(this.bitSet.or(set.bitSet));
    }

    public ContextSet set(int bitIndex) {
        CloverBitSet clone = (CloverBitSet)this.bitSet.clone();
        clone.add(bitIndex);
        return new ContextSet(clone);
    }

    public ContextSet set(int bitIndex, boolean value) {
        CloverBitSet clone = (CloverBitSet)this.bitSet.clone();
        if (value) {
            clone.add(bitIndex);
        } else {
            clone.clear(bitIndex);
        }
        return new ContextSet(clone);
    }

    public ContextSet flip(int startIdx, int endIdx) {
        return new ContextSet(this.bitSet.flip(startIdx, endIdx));
    }

    public String toString() {
        return new StringBuffer().append("bitset{").append(this.bitSet.toString()).append("}").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.bitSet.equals(((ContextSet)o).bitSet);
    }

    public int hashCode() {
        return this.bitSet.hashCode();
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        long[] bitsAsLongs = this.bitSet.getBits();
        out.writeInt(bitsAsLongs.length);
        for (int i = 0; i < bitsAsLongs.length; ++i) {
            out.writeLong(bitsAsLongs[i]);
        }
    }

    public static ContextSet read(TaggedDataInput in) throws IOException {
        int numLongs = in.readInt();
        long[] bitsAsLongs = new long[numLongs];
        for (int i = 0; i < numLongs; ++i) {
            bitsAsLongs[i] = in.readLong();
        }
        return new ContextSet(new CloverBitSet(bitsAsLongs));
    }
}

