/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BaseClassInfo;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.HasMetrics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BaseFileInfo
implements HasMetrics {
    protected String name;
    protected String encoding;
    protected int lineCount;
    protected int ncLineCount;
    protected Map classes = new LinkedHashMap();
    protected long timestamp;
    protected long filesize;
    protected long checksum;
    protected transient BasePackageInfo containingPackage;
    protected transient BlockMetrics rawMetrics;
    protected transient BlockMetrics metrics;
    protected transient ContextSet contextFilter;

    public BaseFileInfo(BasePackageInfo containingPackage, String name, String encoding, int lineCount, int ncLineCount, long timestamp, long filesize, long checksum) {
        this.name = name;
        this.encoding = encoding;
        this.containingPackage = containingPackage;
        this.lineCount = lineCount;
        this.ncLineCount = ncLineCount;
        this.timestamp = timestamp;
        this.filesize = filesize;
        this.checksum = checksum;
    }

    public boolean isTestFile() {
        Iterator it = this.classes.entrySet().iterator();
        while (it.hasNext()) {
            BaseClassInfo clss = (BaseClassInfo)it.next().getValue();
            if (!clss.isTestClass()) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public BlockMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(BlockMetrics metrics) {
        this.metrics = metrics;
    }

    public BlockMetrics getRawMetrics() {
        return this.rawMetrics;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public String getPackagePath() {
        if (this.containingPackage == null) {
            throw new IllegalStateException("This FileInfo has no PackageInfo set on it yet");
        }
        return this.containingPackage.getPath() + this.getName();
    }

    public BasePackageInfo getContainingPackage() {
        return this.containingPackage;
    }

    public void setContainingPackage(BasePackageInfo containingPackage) {
        this.containingPackage = containingPackage;
        Iterator iter = this.classes.values().iterator();
        while (iter.hasNext()) {
            ((ClassInfo)iter.next()).setPackage(containingPackage);
        }
    }

    public ContextSet getContextFilter() {
        return this.getContainingPackage().getContextFilter();
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getNcLineCount() {
        return this.ncLineCount;
    }

    public void addClass(BaseClassInfo clazz) {
        this.classes.put(clazz.getName(), clazz);
    }

    public List getClasses() {
        return new ArrayList(this.classes.values());
    }

    public BaseClassInfo getNamedClass(String name) {
        return (BaseClassInfo)this.classes.get(name);
    }

    public boolean isEmpty() {
        return this.classes.size() == 0;
    }

    public int hashCode() {
        return this.getPackagePath().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseFileInfo that = (BaseFileInfo)o;
        return this.getPackagePath().equals(that.getPackagePath());
    }
}

