/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.atlassian.clover.lang.Language;
import com.cenqua.clover.registry.BasicElementInfo;
import com.cenqua.clover.registry.MethodSignature;
import com.cenqua.clover.registry.SourceRegion;

public class BasicMethodInfo
extends BasicElementInfo {
    private MethodSignature signature;
    private boolean test = false;
    private int dataLength;
    private transient String name;

    public BasicMethodInfo(SourceRegion region, int relativeDataIndex, int dataLength, int complexity, MethodSignature signature, boolean isTest) {
        this(region, relativeDataIndex, dataLength, complexity, signature, isTest, Language.Construct.METHOD);
    }

    public BasicMethodInfo(SourceRegion region, int relativeDataIndex, int dataLength, int complexity, MethodSignature signature, boolean isTest, Language.Construct construct) {
        super(region, relativeDataIndex, complexity, construct);
        this.signature = signature;
        this.test = isTest;
        this.dataLength = dataLength;
        this.name = this.getNameFor(signature);
    }

    public BasicMethodInfo(SourceRegion region, int relativeDataIndex, int complexity, MethodSignature signature, boolean isTest) {
        this(region, relativeDataIndex, complexity, signature, isTest, Language.Construct.METHOD);
    }

    public BasicMethodInfo(SourceRegion region, int relativeDataIndex, int complexity, MethodSignature signature, boolean isTest, Language.Construct construct) {
        this(region, relativeDataIndex, 1, complexity, signature, isTest, construct);
    }

    private String getNameFor(MethodSignature signature) {
        return signature.getName() + "(" + signature.listParamTypes() + ")" + (signature.getReturnType() != null ? " : " + signature.getReturnType() : "");
    }

    public MethodSignature getSignature() {
        return this.signature;
    }

    public boolean isTest() {
        return this.test;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public String getName() {
        return this.name;
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    public String toString() {
        return "BasicMethodInfo{name='" + this.name + '\'' + ", test=" + this.test + ", signature=" + this.signature + "} " + super.toString();
    }
}

