/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.cenqua.clover.TCILookupStore;
import com.cenqua.clover.TestCaseInfoLookup;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BaseClassInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.ClassMetrics;
import com.cenqua.clover.registry.CoverageDataProvider;
import com.cenqua.clover.registry.CoverageDataReceptor;
import com.cenqua.clover.registry.FileElementVisitor;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FixedSourceRegion;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.HasMetricsNode;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.SourceRegion;
import com.cenqua.clover.registry.TestCaseInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo
extends BaseClassInfo
implements HasMetricsNode,
CoverageDataReceptor,
TaggedPersistent {
    private List methods = new ArrayList();
    private int relativeDataIndex;
    private int dataLength;
    private transient CoverageDataProvider data;
    private transient TestCaseInfoLookup tciLookup;
    static /* synthetic */ Class class$com$cenqua$clover$registry$MethodInfo;

    public ClassInfo(PackageInfo packageInfo, FileInfo containingFile, int dataIndex, String name, SourceRegion region, boolean typeInterface, boolean typeEnum, boolean typeAnnotation) {
        super(packageInfo, containingFile, region, name, typeInterface, typeEnum, typeAnnotation);
        this.relativeDataIndex = dataIndex;
    }

    private ClassInfo(String name, String qualifiedName, int dataIndex, int dataLength, boolean typeInterface, boolean typeEnum, boolean typeAnnotation, boolean testClass, SourceRegion region, List<MethodInfo> methods) {
        super(name, qualifiedName, typeInterface, typeEnum, typeAnnotation, testClass, region);
        this.relativeDataIndex = dataIndex;
        this.dataLength = dataLength;
        this.methods = methods;
    }

    @Override
    public boolean isEmpty() {
        return this.methods.size() == 0;
    }

    public MethodInfo[] getMethods() {
        return this.methods.toArray(new MethodInfo[this.methods.size()]);
    }

    public void addMethod(MethodInfo meth) {
        this.methods.add(meth);
        this.testClass |= meth.isTest();
    }

    public void addTestCase(TestCaseInfo tci) {
        TestCaseInfoLookup lookup = this.tciLookup;
        if (lookup != null) {
            lookup.add(tci);
        }
        this.testClass = true;
    }

    private String calcTCILookupName() {
        return new StringBuffer().append("class@").append(this.getDataIndex()).append(":").append(this.getQualifiedName()).toString();
    }

    public Collection<TestCaseInfo> getTestCases() {
        TestCaseInfoLookup lookup = this.tciLookup;
        if (lookup != null) {
            return lookup.getTestCaseInfos();
        }
        return Collections.EMPTY_SET;
    }

    public TestCaseInfo getTestCase(Integer id) {
        TestCaseInfoLookup lookup = this.tciLookup;
        if (lookup != null) {
            return lookup.getBy(id);
        }
        return null;
    }

    public TestCaseInfo getTestCase(String testname) {
        TestCaseInfoLookup lookup = this.tciLookup;
        if (lookup != null) {
            return lookup.getBy(testname);
        }
        return null;
    }

    @Override
    public void setDataProvider(CoverageDataProvider data) {
        this.data = data;
        this.tciLookup = data instanceof TCILookupStore ? ((TCILookupStore)((Object)data)).namedTCILookupFor(this.calcTCILookupName()) : null;
        for (MethodInfo methodInfo : this.methods) {
            methodInfo.setDataProvider(data);
        }
        this.rawMetrics = null;
        this.metrics = null;
    }

    @Override
    public CoverageDataProvider getDataProvider() {
        return this.data;
    }

    @Override
    public int getDataIndex() {
        return ((FileInfo)this.containingFile).dataIndex + this.relativeDataIndex;
    }

    public int getRelativeDataIndex() {
        return this.relativeDataIndex;
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int length) {
        this.dataLength = length;
    }

    public void gatherSourceRegions(Set regions) {
        regions.add(this);
        for (MethodInfo methodInfo : this.methods) {
            methodInfo.gatherSourceRegions(regions);
        }
    }

    public void visitElements(FileElementVisitor visitor) {
        visitor.visitClass(this);
        for (MethodInfo methodInfo : this.methods) {
            methodInfo.visit(visitor);
        }
    }

    @Override
    public String getChildType() {
        return "method";
    }

    @Override
    public int getNumChildren() {
        return this.methods.size();
    }

    @Override
    public HasMetricsNode getChild(int i) {
        return (HasMetricsNode)this.methods.get(i);
    }

    @Override
    public int getIndexOfChild(HasMetricsNode child) {
        return this.methods.indexOf(child);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setComparator(Comparator cmp) {
        if (cmp != null) {
            Collections.sort(this.methods, cmp);
        } else {
            Collections.sort(this.methods, FixedSourceRegion.SOURCE_ORDER_COMP);
        }
    }

    @Override
    public BlockMetrics getMetrics() {
        if (this.metrics == null || this.getPackage().getContextFilter() != this.contextFilter) {
            this.contextFilter = this.getContainingFile().getContextFilter();
            this.metrics = this.calcMetrics(this.contextFilter, true);
        }
        return this.metrics;
    }

    @Override
    public BlockMetrics getRawMetrics() {
        if (this.rawMetrics == null) {
            this.rawMetrics = this.calcMetrics(null, false);
        }
        return this.rawMetrics;
    }

    private ClassMetrics calcMetrics(ContextSet filter, boolean filtered) {
        ClassMetrics classMetrics = new ClassMetrics(this);
        int covered = 0;
        int numMethods = 0;
        int numTestMethods = 0;
        for (MethodInfo methodInfo : this.methods) {
            if (methodInfo.isFiltered(filter)) continue;
            if (!filtered) {
                classMetrics.add(methodInfo.getRawMetrics());
            } else {
                classMetrics.add(methodInfo.getMetrics());
            }
            if (methodInfo.getHitCount() > 0) {
                ++covered;
            }
            if (methodInfo.isTest()) {
                ++numTestMethods;
            }
            ++numMethods;
        }
        classMetrics.setNumMethods(numMethods);
        classMetrics.setNumCoveredMethods(covered);
        classMetrics.setNumTestMethods(numTestMethods);
        TestCaseInfoLookup lookup = this.tciLookup;
        if (lookup != null) {
            int numTests = 0;
            int numPasses = 0;
            int numFailures = 0;
            int numErrors = 0;
            float executionTime = 0.0f;
            for (TestCaseInfo test : lookup.getTestCaseInfos()) {
                if (!test.isHasResult()) continue;
                ++numTests;
                if (test.isSuccess()) {
                    ++numPasses;
                } else if (test.isError()) {
                    ++numErrors;
                } else {
                    ++numFailures;
                }
                executionTime += test.getTime();
            }
            classMetrics.setNumTests(numTests);
            classMetrics.setNumTestPasses(numPasses);
            classMetrics.setNumTestFailures(numFailures);
            classMetrics.setNumTestErrors(numErrors);
            classMetrics.setTestExecutionTime(executionTime);
        }
        return classMetrics;
    }

    public ClassInfo copy(FileInfo newParent, HasMetricsFilter filter) {
        ClassInfo cinfo = new ClassInfo((PackageInfo)newParent.getContainingPackage(), newParent, this.relativeDataIndex, this.name, this, this.typeInterface, this.typeEnum, this.typeAnnotation);
        cinfo.setDataProvider(this.getDataProvider());
        for (MethodInfo methodInfo : this.methods) {
            if (!filter.accept(methodInfo)) continue;
            cinfo.addMethod(methodInfo.copy(cinfo));
        }
        cinfo.setDataLength(this.getDataLength());
        return cinfo;
    }

    public MethodInfo getTestMethodDeclaration(String methodname) {
        for (MethodInfo methodInfo : this.methods) {
            if (!methodInfo.getSimpleName().equals(methodname) || !methodInfo.isPublic() || methodInfo.getParamCount() != 0) continue;
            return methodInfo;
        }
        return null;
    }

    public int getNumMethods() {
        return this.methods.size();
    }

    public void setRegionEnd(int endLine, int endCol) {
        this.region = new FixedSourceRegion(this.region.getStartLine(), this.region.getStartColumn(), endLine, endCol);
    }

    public void setContainingFile(FileInfo fileInfo) {
        this.containingFile = fileInfo;
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.qualifiedName);
        out.writeInt(this.relativeDataIndex);
        out.writeInt(this.dataLength);
        out.writeBoolean(this.typeAnnotation);
        out.writeBoolean(this.typeEnum);
        out.writeBoolean(this.typeInterface);
        out.writeBoolean(this.testClass);
        FixedSourceRegion.writeRaw(this, out);
        out.writeInt(this.methods.size());
        for (MethodInfo methodInfo : this.methods) {
            Class<?> clazz = class$com$cenqua$clover$registry$MethodInfo;
            if (clazz == null) {
                clazz = new MethodInfo[0].getClass().getComponentType();
            }
            out.write(clazz, methodInfo);
        }
    }

    public static ClassInfo read(TaggedDataInput in) throws IOException {
        String name = in.readUTF();
        String qualifiedName = in.readUTF();
        int index = in.readInt();
        int length = in.readInt();
        boolean typeAnnotation = in.readBoolean();
        boolean typeEnum = in.readBoolean();
        boolean typeInterface = in.readBoolean();
        boolean isTest = in.readBoolean();
        FixedSourceRegion region = FixedSourceRegion.read(in);
        int numMethods = in.readInt();
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>(numMethods);
        for (int i = 0; i < numMethods; ++i) {
            Class<?> clazz = class$com$cenqua$clover$registry$MethodInfo;
            if (clazz == null) {
                clazz = new MethodInfo[0].getClass().getComponentType();
            }
            methods.add((MethodInfo)in.read(clazz));
        }
        ClassInfo classInfo = new ClassInfo(name, qualifiedName, index, length, typeInterface, typeEnum, typeAnnotation, isTest, region, methods);
        for (MethodInfo method : methods) {
            method.setContainingClass(classInfo);
        }
        return classInfo;
    }
}

