/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Iterable;
import com.atlassian.clover.instr.java.ConcurrentInstrumentationException;
import com.atlassian.clover.instr.java.InstrumentationSession;
import com.atlassian.clover.registry.CloverRegistryException;
import com.atlassian.clover.registry.CorruptedRegistryException;
import com.atlassian.clover.registry.format.CoverageSegment;
import com.atlassian.clover.registry.format.FileInfoRecord;
import com.atlassian.clover.registry.format.FreshRegFile;
import com.atlassian.clover.registry.format.InstrSessionSegment;
import com.atlassian.clover.registry.format.NoSuchRegistryFileException;
import com.atlassian.clover.registry.format.RegAccessMode;
import com.atlassian.clover.registry.format.RegContents;
import com.atlassian.clover.registry.format.RegContentsConsumer;
import com.atlassian.clover.registry.format.RegFile;
import com.atlassian.clover.registry.format.UpdatableRegFile;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CoverageData;
import com.cenqua.clover.Logger;
import com.cenqua.clover.ProgressListener;
import com.cenqua.clover.context.ContextStore;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.EmptyProjectUpdate;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FullProjectUpdate;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.InstrumentationTarget;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.ProjectView;
import com.cenqua.clover.registry.RegUpdate;
import com.cenqua.clover.util.CloverUtils;
import com.cenqua.clover.util.FileUtils;
import com.cenqua.clover.util.Path;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clover2Registry
implements InstrumentationTarget {
    private final ProjectView.Original model;
    private final LinkedList<InstrumentationInfo> instrumentationHistory;
    private final List<InstrumentationSession.Update> updatesToSave;
    private volatile RegFile regFile;
    private ContextStore contexts;
    private CoverageData coverageData;

    public Clover2Registry(File regFile, String name) {
        this(regFile, RegAccessMode.READWRITE, name);
    }

    public Clover2Registry(File regFile, RegAccessMode accessMode, String name) {
        this(new FreshRegFile(regFile, accessMode, name), new ProjectInfo(name), new ArrayList<InstrumentationInfo>(), new ContextStore());
    }

    Clover2Registry(RegFile regFile, ProjectInfo model, List<InstrumentationInfo> instrumentationHistory, ContextStore contexts) {
        this.regFile = regFile;
        this.model = new ProjectView.Original(model);
        this.instrumentationHistory = new LinkedList<InstrumentationInfo>(instrumentationHistory);
        this.contexts = contexts;
        this.updatesToSave = new CopyOnWriteArrayList();
    }

    public Clover2Registry copyForBackgroundCoverageLoad() {
        return new Clover2Registry(this.regFile, this.model.getProject().copy(), this.instrumentationHistory, this.contexts);
    }

    public static Clover2Registry fromInitString(String initstring, String name) throws CloverException {
        File regFile = new File(initstring);
        Clover2Registry reg = Clover2Registry.fromFile(regFile);
        if (reg == null) {
            reg = new Clover2Registry(regFile, name);
        }
        return reg;
    }

    public static Clover2Registry fromFile(File registryFile) throws CloverException {
        return Clover2Registry.fromFile(registryFile, null, null);
    }

    public static Clover2Registry fromFile(File registryFile, final HasMetricsFilter filter, ProgressListener progressListener) throws CloverException {
        try {
            final UpdatableRegFile regFile = new UpdatableRegFile(registryFile);
            final LinkedList instrHistory = new LinkedList();
            final ProjectInfo projInfo = new ProjectInfo(regFile.getName(), regFile.getVersion());
            final HashMap fileInfos = new HashMap();
            final long version = regFile.getVersion();
            final Clover2Registry[] resultReg = new Clover2Registry[1];
            regFile.readContents(new RegContentsConsumer(){

                public void consume(RegContents contents) throws IOException, CloverRegistryException {
                    ContextStore ctxStore = null;
                    Iterator i$ = _Iterable.iterator(contents.getSessions());
                    while (i$.hasNext()) {
                        InstrSessionSegment sessionSegment = (InstrSessionSegment)i$.next();
                        ctxStore = ctxStore == null ? sessionSegment.getCtxStore() : ctxStore;
                        Collection<FileInfoRecord> fileInfoRecs = sessionSegment.getFileInfoRecords();
                        instrHistory.add(new InstrumentationInfo(sessionSegment.getVersion(), sessionSegment.getStartTs(), sessionSegment.getEndTs()));
                        Clover2Registry.buildModel(version, filter, projInfo, fileInfos, sessionSegment, fileInfoRecs);
                    }
                    Clover2Registry.recreateDataIndicesAndLengths(regFile, projInfo);
                    Clover2Registry reg = new Clover2Registry(regFile, projInfo, instrHistory, ctxStore);
                    CoverageSegment coverage = contents.getCoverage();
                    if (coverage != null) {
                        CoverageData covData = new CoverageData(reg.getVersion(), coverage.getHitCounts(), coverage.getPerTestCoverage());
                        reg.setCoverageData(covData);
                        reg.getProject().setDataProvider(covData);
                    }
                    resultReg[0] = reg;
                }
            });
            return resultReg[0];
        }
        catch (RuntimeException e) {
            Logger.getInstance().debug(new StringBuffer().append("Exception reading registry file ").append(registryFile.getAbsolutePath()).toString(), e);
            throw new CorruptedRegistryException(registryFile.getAbsolutePath(), e);
        }
        catch (NoSuchRegistryFileException e) {
            return null;
        }
        catch (IOException e) {
            Logger.getInstance().debug(new StringBuffer().append("Exception reading registry file ").append(registryFile.getAbsolutePath()).toString(), e);
            throw new CorruptedRegistryException(registryFile.getAbsolutePath(), e);
        }
    }

    private static void buildModel(long version, HasMetricsFilter filter, ProjectInfo projInfo, Map<String, FileInfo> fileInfos, InstrSessionSegment sessionSegment, Collection<FileInfoRecord> fileInfoRecs) {
        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FosterPackageInfo
        extends BasePackageInfo {
            public String fosterName;
            final /* synthetic */ ProjectInfo val$projInfo;

            FosterPackageInfo(ProjectInfo projectInfo) {
                this.val$projInfo = projectInfo;
                super(projectInfo, "");
            }

            @Override
            public String getName() {
                return this.fosterName;
            }

            @Override
            public String getPath() {
                return CloverUtils.packageNameToPath(this.fosterName, this.isDefault());
            }

            @Override
            public boolean isDefault() {
                return FosterPackageInfo.isDefaultName(this.fosterName);
            }

            public FileInfo adopt(String fosterName, FileInfo fileInfo) {
                this.fosterName = fosterName;
                fileInfo.setContainingPackage(this);
                return fileInfo;
            }
        }
        FosterPackageInfo surrogatePackage = new FosterPackageInfo(projInfo);
        for (FileInfoRecord fileInfoRec : fileInfoRecs) {
            String pkgName = fileInfoRec.getPackageName();
            String filePath = new StringBuffer().append(fileInfoRec.getName()).append("@").append(pkgName).toString();
            if (!fileInfos.containsKey(filePath)) {
                FileInfo fileInfo = surrogatePackage.adopt(pkgName, fileInfoRec.getFileInfo());
                if (filter != null && !filter.accept(fileInfo)) continue;
                fileInfos.put(filePath, fileInfo);
                fileInfo.addVersion(version);
                PackageInfo pkgInfo = (PackageInfo)projInfo.getNamedPackage(pkgName);
                if (pkgInfo == null) {
                    pkgInfo = new PackageInfo(projInfo, pkgName, Integer.MAX_VALUE);
                    projInfo.addPackage(pkgInfo);
                }
                pkgInfo.addFile(fileInfo);
                continue;
            }
            fileInfos.get(filePath).addVersion(sessionSegment.getVersion());
        }
    }

    private static void recreateDataIndicesAndLengths(UpdatableRegFile regFile, ProjectInfo projInfo) {
        int projLen = Integer.MIN_VALUE;
        for (PackageInfo packageInfo : projInfo.getPackages()) {
            int pkgStartIdx = Integer.MAX_VALUE;
            int pkgEndIdx = Integer.MIN_VALUE;
            for (FileInfo fileInfo : packageInfo.getFiles()) {
                pkgStartIdx = Math.min(pkgStartIdx, fileInfo.getDataIndex());
                pkgEndIdx = Math.max(pkgEndIdx, fileInfo.getDataIndex() + fileInfo.getDataLength());
            }
            packageInfo.setDataIndex(pkgStartIdx);
            packageInfo.setDataLength(pkgEndIdx - pkgStartIdx);
            projLen = Math.max(projLen, pkgEndIdx);
        }
        projInfo.setDataLength(Math.max(projLen, regFile.getSlotCount()));
    }

    public static Clover2Registry createOrLoad(File registryFile, String projectName) throws IOException, CloverException {
        Clover2Registry registry;
        if (registryFile.exists()) {
            Logger.getInstance().info(new StringBuffer().append("Updating existing database at '").append(registryFile).append("'.").toString());
            registry = Clover2Registry.fromFile(registryFile);
        } else {
            Logger.getInstance().info(new StringBuffer().append("Creating new database at '").append(registryFile).append("'.").toString());
            File parentDir = registryFile.getParentFile();
            if (parentDir != null) {
                parentDir.mkdirs();
            }
            registry = new Clover2Registry(registryFile, projectName);
        }
        return registry;
    }

    public RegFile overwriteSaveToFile() throws IOException, CloverRegistryException {
        return this.overwriteSaveToFile(this.model.getProject(), this.instrumentationHistory, this.contexts, this.coverageData);
    }

    protected RegFile overwriteSaveToFile(ProjectInfo project, List<InstrumentationInfo> instrumentationHistory, ContextStore contexts, CoverageData coverageData) throws IOException, CloverRegistryException {
        long startTs;
        FreshRegFile regFile = new FreshRegFile(this.regFile, coverageData);
        LinkedList<RegUpdate> updates = new LinkedList<RegUpdate>();
        for (int i = 0; i < instrumentationHistory.size() - 1; ++i) {
            InstrumentationInfo instrInfo = instrumentationHistory.get(i);
            updates.add(new EmptyProjectUpdate(instrInfo.getVersion(), instrInfo.getStartTS(), instrInfo.getEndTS(), project.getDataLength()));
        }
        long endTs = startTs = System.currentTimeMillis();
        if (!instrumentationHistory.isEmpty()) {
            startTs = instrumentationHistory.get(instrumentationHistory.size() - 1).getStartTS();
            endTs = instrumentationHistory.get(instrumentationHistory.size() - 1).getEndTS();
        }
        updates.add(new FullProjectUpdate(project, contexts, startTs, endTs));
        this.regFile = regFile.save(updates);
        return regFile;
    }

    public RegFile appendSaveToFile() throws IOException, CloverRegistryException {
        if (this.regFile.isAppendable()) {
            this.regFile = this.regFile.save(this.updatesToSave);
        } else {
            this.overwriteSaveToFile();
        }
        this.updatesToSave.clear();
        return this.regFile;
    }

    public UpdatableRegFile applyAndAppendToFile(UpdatableRegFile regFile, InstrumentationSession.Update update) throws IOException, CloverRegistryException {
        return (UpdatableRegFile)regFile.save(this.applyUpdate(regFile.getVersion(), update));
    }

    @Override
    public RegUpdate applyUpdate(long expectedVersion, InstrumentationSession.Update update) throws ConcurrentInstrumentationException {
        this.model.applyUpdate(expectedVersion, update);
        this.instrumentationHistory.addFirst(new InstrumentationInfo(update.getVersion(), update.getStartTs(), update.getEndTs()));
        this.updatesToSave.add(update);
        return update;
    }

    public ProjectView.Filtered newProjectView(HasMetricsFilter.Invertable filter) {
        return this.model.newProjection(filter);
    }

    public InstrumentationSession startInstr() throws CloverException {
        return this.startInstr(null);
    }

    public InstrumentationSession startInstr(String encoding) throws CloverException {
        return new InstrumentationSession(this, encoding);
    }

    public boolean fileExists() {
        return this.regFile.getFile().exists();
    }

    public boolean isOutOfDate() {
        File file = this.getRegistryFile();
        return file.lastModified() == 0L || FileUtils.getInstance().compareLastModified(this.getVersion(), file) < 0;
    }

    public File getRegistryFile() {
        return this.regFile.getFile();
    }

    public String getProjectName() {
        return this.model.getProject().getName();
    }

    public void setProjectName(String name) {
        this.model.getProject().setName(name);
    }

    public long getVersion() {
        return this.model.getVersion();
    }

    public long getFirstVersion() {
        return this.instrumentationHistory.isEmpty() ? this.getVersion() : this.instrumentationHistory.get(this.instrumentationHistory.size() - 1).getVersion();
    }

    public void setVersion(long version) {
        this.model.setVersion(version);
    }

    public ProjectView.Original getModel() {
        return this.model;
    }

    public boolean isReadOnly() {
        return this.regFile.getAccessMode() == RegAccessMode.READONLY;
    }

    public void setCoverageData(CoverageData data) {
        this.coverageData = data;
    }

    public CoverageData getCoverageData() {
        return this.coverageData;
    }

    public int getDataLength() {
        return this.model.getProject().getDataLength();
    }

    public ProjectInfo getProject() {
        return this.model.getProject();
    }

    public List getInstrHistory() {
        return this.instrumentationHistory;
    }

    public ContextStore getContextStore() {
        return this.contexts;
    }

    public void setContextStore(ContextStore contexts) {
        this.contexts = contexts;
    }

    public String getInitstring() {
        return this.getRegistryFile().getAbsolutePath();
    }

    public long getPastInstrTimestamp(int numPastInstrs) {
        long msec = 0L;
        if (!this.instrumentationHistory.isEmpty()) {
            ListIterator<InstrumentationInfo> history = this.instrumentationHistory.listIterator(this.instrumentationHistory.size() - 1);
            while (0 < numPastInstrs-- && history.hasPrevious()) {
                msec = history.previous().getEndTS();
            }
        }
        return msec;
    }

    public void resolve(Path sourcePath) {
        this.model.resolve(sourcePath);
    }

    public static class InstrumentationInfo {
        private long startTS = 0L;
        private long endTS = 0L;
        private long version = 0L;

        public InstrumentationInfo(long version, long startTS, long endTS) {
            this.version = version;
            this.startTS = startTS;
            this.endTS = endTS;
        }

        public InstrumentationInfo(long startTS) {
            this.startTS = startTS;
        }

        public long getStartTS() {
            return this.startTS;
        }

        public void setStartTS(long startTS) {
            this.startTS = startTS;
        }

        public long getEndTS() {
            return this.endTS;
        }

        public void setEndTS(long endTS) {
            this.endTS = endTS;
        }

        public long getVersion() {
            return this.version;
        }

        public String toString() {
            return "InstrumentationInfo{startTS=" + this.startTS + ", endTS=" + this.endTS + ", version=" + this.version + '}';
        }
    }
}

