/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.lang.Language;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.BasicMethodInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.CoverageDataProvider;
import com.cenqua.clover.registry.ElementInfo;
import com.cenqua.clover.registry.FileElementVisitor;
import com.cenqua.clover.registry.FixedSourceRegion;
import com.cenqua.clover.registry.HasMetricsNode;
import com.cenqua.clover.registry.MethodSignature;
import com.cenqua.clover.registry.SourceRegion;
import com.cenqua.clover.registry.StatementInfo;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo
extends ElementInfo<BasicMethodInfo>
implements HasMetricsNode,
TaggedPersistent {
    public static final int DEFAULT_METHOD_COMPLEXITY = 1;
    private List<StatementInfo> statements = new ArrayList<StatementInfo>();
    private List<BranchInfo> branches = new ArrayList<BranchInfo>();
    private transient BlockMetrics rawMetrics;
    private transient BlockMetrics metrics;
    private transient ContextSet contextFilter;
    private transient CoverageDataProvider data;
    private transient ClassInfo containingClass;
    static /* synthetic */ Class class$com$cenqua$clover$registry$BranchInfo;
    static /* synthetic */ Class class$com$cenqua$clover$registry$StatementInfo;
    static /* synthetic */ Class class$com$cenqua$clover$context$ContextSet;
    static /* synthetic */ Class class$com$cenqua$clover$registry$MethodSignature;

    public MethodInfo(ClassInfo containingClass, int relativeDataIndex, ContextSet context, SourceRegion region, MethodSignature signature, boolean isTest, int complexity) {
        this(containingClass, relativeDataIndex, context, region, signature, isTest, complexity, Language.Construct.METHOD);
    }

    public MethodInfo(ClassInfo containingClass, int relativeDataIndex, ContextSet context, SourceRegion region, MethodSignature signature, boolean isTest, int complexity, Language.Construct construct) {
        this(containingClass, context, new BasicMethodInfo(region, relativeDataIndex, complexity, signature, isTest, construct));
    }

    private MethodInfo(ClassInfo containingClass, ContextSet context, BasicMethodInfo methodInfo) {
        super(context, methodInfo);
        this.containingClass = containingClass;
    }

    private MethodInfo(MethodSignature signature, ContextSet context, int relativeDataIndex, int dataLength, int complexity, Language.Construct construct, SourceRegion region, boolean isTest, List<StatementInfo> statements, List<BranchInfo> branches) {
        super(context, new BasicMethodInfo(region, relativeDataIndex, dataLength, complexity, signature, isTest, construct));
        this.statements = statements;
        this.branches = branches;
    }

    private MethodInfo(MethodSignature signature, ContextSet context, int relativeDataIndex, int dataLength, int complexity, SourceRegion region, boolean isTest, List<StatementInfo> statements, List<BranchInfo> branches) {
        this(signature, context, relativeDataIndex, dataLength, complexity, Language.Construct.METHOD, region, isTest, statements, branches);
    }

    @Override
    public String getName() {
        return ((BasicMethodInfo)this.sharedInfo).getName();
    }

    public String getSimpleName() {
        return ((BasicMethodInfo)this.sharedInfo).getSignature().getName();
    }

    public MethodSignature getSignature() {
        return ((BasicMethodInfo)this.sharedInfo).getSignature();
    }

    public String getQualifiedName() {
        return new StringBuffer().append(this.containingClass.getQualifiedName()).append(".").append(((BasicMethodInfo)this.sharedInfo).getSignature().getName()).toString();
    }

    public ClassInfo getContainingClass() {
        return this.containingClass;
    }

    public boolean isTest() {
        return ((BasicMethodInfo)this.sharedInfo).isTest();
    }

    @Override
    public boolean isEmpty() {
        return this.statements.size() == 0 && this.branches.size() == 0;
    }

    public StatementInfo[] getStatements() {
        return this.statements.toArray(new StatementInfo[this.statements.size()]);
    }

    public BranchInfo[] getBranches() {
        return this.branches.toArray(new BranchInfo[this.branches.size()]);
    }

    @Override
    public BlockMetrics getMetrics() {
        if (this.metrics == null || this.getContainingClass().getContextFilter() != this.contextFilter) {
            this.contextFilter = this.getContainingClass().getContextFilter();
            this.metrics = this.calcMetrics(this.contextFilter);
        }
        return this.metrics;
    }

    @Override
    public BlockMetrics getRawMetrics() {
        if (this.rawMetrics == null) {
            this.rawMetrics = this.calcMetrics(null);
        }
        return this.rawMetrics;
    }

    @Override
    public void setMetrics(BlockMetrics metrics) {
        this.metrics = metrics;
    }

    public void addStatement(StatementInfo stmt) {
        this.statements.add(stmt);
    }

    public void addBranch(BranchInfo branch) {
        this.branches.add(branch);
    }

    @Override
    public void setDataProvider(CoverageDataProvider data) {
        this.data = data;
        this.rawMetrics = null;
        this.metrics = null;
    }

    public void gatherSourceRegions(Set regions) {
        regions.add(this);
        regions.addAll(this.statements);
        regions.addAll(this.branches);
    }

    public void visit(FileElementVisitor visitor) {
        visitor.visitMethod(this);
        for (StatementInfo statementInfo : this.statements) {
            visitor.visitStatement(statementInfo);
        }
        for (BranchInfo branchInfo : this.branches) {
            visitor.visitBranch(branchInfo);
        }
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public int getNumChildren() {
        return 0;
    }

    @Override
    public String getChildType() {
        return null;
    }

    @Override
    public HasMetricsNode getChild(int i) {
        return null;
    }

    @Override
    public int getIndexOfChild(HasMetricsNode child) {
        return -1;
    }

    @Override
    public void setComparator(Comparator cmp) {
    }

    private BlockMetrics calcMetrics(ContextSet contextSet) {
        BlockMetrics blockMetrics = new BlockMetrics(this);
        int covered = 0;
        int numStatements = 0;
        int numBranches = 0;
        int complexity = 1;
        for (StatementInfo statementInfo : this.statements) {
            if (statementInfo.isFiltered(contextSet)) continue;
            if (statementInfo.getHitCount() > 0) {
                ++covered;
            }
            complexity += statementInfo.getComplexity();
            ++numStatements;
        }
        blockMetrics.setNumCoveredStatements(covered);
        blockMetrics.setNumStatements(numStatements);
        covered = 0;
        for (BranchInfo branchInfo : this.branches) {
            if (branchInfo.isFiltered(contextSet)) continue;
            if (branchInfo.getTrueHitCount() > 0) {
                ++covered;
            }
            if (branchInfo.getFalseHitCount() > 0) {
                ++covered;
            }
            complexity += branchInfo.getComplexity();
            numBranches += 2;
        }
        blockMetrics.setNumCoveredBranches(covered);
        blockMetrics.setNumBranches(numBranches);
        blockMetrics.setComplexity(complexity);
        this.setComplexity(complexity);
        return blockMetrics;
    }

    public MethodInfo copy(ClassInfo newParent) {
        MethodInfo method = new MethodInfo(newParent, this.getContext(), (BasicMethodInfo)this.sharedInfo);
        method.setDataProvider(this.getDataProvider());
        for (StatementInfo statementInfo : this.statements) {
            method.addStatement(statementInfo.copy(method));
        }
        for (BranchInfo branchInfo : this.branches) {
            method.addBranch(branchInfo.copy(method));
        }
        method.setDataLength(this.getDataLength());
        return method;
    }

    public boolean isPublic() {
        return Modifier.isPublic(((BasicMethodInfo)this.sharedInfo).getSignature().getModifiers());
    }

    public int getParamCount() {
        return ((BasicMethodInfo)this.sharedInfo).getSignature().getParamCount();
    }

    @Override
    public CoverageDataProvider getDataProvider() {
        return this.data;
    }

    @Override
    public int getDataLength() {
        return ((BasicMethodInfo)this.sharedInfo).getDataLength();
    }

    public void setDataLength(int length) {
        ((BasicMethodInfo)this.sharedInfo).setDataLength(length);
    }

    void setContainingClass(ClassInfo classInfo) {
        this.containingClass = classInfo;
    }

    @Override
    public BaseFileInfo getContainingFile() {
        return this.containingClass.getContainingFile();
    }

    public Language.Construct getConstruct() {
        return ((BasicMethodInfo)this.sharedInfo).getConstruct();
    }

    public void setRegionEnd(int endLine, int endCol) {
        SourceRegion region = ((BasicMethodInfo)this.sharedInfo).getRegion();
        ((BasicMethodInfo)this.sharedInfo).setRegion(new FixedSourceRegion(region.getStartLine(), region.getStartColumn(), endLine, endCol));
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        Class<?> clazz = class$com$cenqua$clover$registry$MethodSignature;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$registry$MethodSignature = new MethodSignature[0].getClass().getComponentType();
        }
        out.write(clazz, ((BasicMethodInfo)this.sharedInfo).getSignature());
        out.writeBoolean(this.isTest());
        Class<?> clazz2 = class$com$cenqua$clover$context$ContextSet;
        if (clazz2 == null) {
            clazz2 = class$com$cenqua$clover$context$ContextSet = new ContextSet[0].getClass().getComponentType();
        }
        out.write(clazz2, this.getContext());
        out.writeInt(((BasicMethodInfo)this.sharedInfo).getRelativeDataIndex());
        out.writeInt(this.getDataLength());
        out.writeInt(this.getComplexity());
        out.writeInt(((BasicMethodInfo)this.sharedInfo).getConstruct().getId());
        FixedSourceRegion.writeRaw(this, out);
        out.writeInt(this.statements.size());
        for (StatementInfo statement : this.statements) {
            Class<?> clazz3 = class$com$cenqua$clover$registry$StatementInfo;
            if (clazz3 == null) {
                clazz3 = new StatementInfo[0].getClass().getComponentType();
            }
            out.write(clazz3, statement);
        }
        out.writeInt(this.branches.size());
        for (BranchInfo branch : this.branches) {
            Class<?> clazz4 = class$com$cenqua$clover$registry$BranchInfo;
            if (clazz4 == null) {
                clazz4 = new BranchInfo[0].getClass().getComponentType();
            }
            out.write(clazz4, branch);
        }
    }

    public static MethodInfo read(TaggedDataInput in) throws IOException {
        Class<?> clazz = class$com$cenqua$clover$registry$MethodSignature;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$registry$MethodSignature = new MethodSignature[0].getClass().getComponentType();
        }
        MethodSignature signature = (MethodSignature)in.read(clazz);
        boolean isTest = in.readBoolean();
        Class<?> clazz2 = class$com$cenqua$clover$context$ContextSet;
        if (clazz2 == null) {
            clazz2 = class$com$cenqua$clover$context$ContextSet = new ContextSet[0].getClass().getComponentType();
        }
        ContextSet context = (ContextSet)in.read(clazz2);
        int index = in.readInt();
        int length = in.readInt();
        int complexity = in.readInt();
        Language.Construct construct = Language.Construct.fromId(in.readInt());
        FixedSourceRegion region = FixedSourceRegion.read(in);
        int numStatements = in.readInt();
        ArrayList<StatementInfo> statements = new ArrayList<StatementInfo>(numStatements);
        for (int i = 0; i < numStatements; ++i) {
            Class<?> clazz3 = class$com$cenqua$clover$registry$StatementInfo;
            if (clazz3 == null) {
                clazz3 = new StatementInfo[0].getClass().getComponentType();
            }
            statements.add((StatementInfo)in.read(clazz3));
        }
        int numBranches = in.readInt();
        ArrayList<BranchInfo> branches = new ArrayList<BranchInfo>(numBranches);
        for (int i = 0; i < numBranches; ++i) {
            Class<?> clazz4 = class$com$cenqua$clover$registry$BranchInfo;
            if (clazz4 == null) {
                clazz4 = new BranchInfo[0].getClass().getComponentType();
            }
            branches.add((BranchInfo)in.read(clazz4));
        }
        MethodInfo methodInfo = new MethodInfo(signature, context, index, length, complexity, construct, region, isTest, statements, branches);
        for (StatementInfo statement : statements) {
            statement.setContainingMethod(methodInfo);
        }
        for (BranchInfo branch : branches) {
            branch.setContainingMethod(methodInfo);
        }
        return methodInfo;
    }

    public String toString() {
        return new StringBuffer().append("MethodInfo{sharedInfo='").append(this.sharedInfo).append('\'').append("} ").toString();
    }
}

