/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import com.atlassian.clover.instr.java.CloverToken;
import com.atlassian.clover.instr.java.TokenListUtil;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.cenqua.clover.registry.Modifiers;
import com.cenqua.clover.registry.Parameter;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSignature
implements TaggedPersistent {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Parameter[] EMPTY_PARAMS = new Parameter[0];
    private Map<String, List<String>> tags;
    private Modifiers modifiers;
    private String name;
    private String typeParams;
    private String returnType;
    private Parameter[] parameters;
    private String[] throwsTypes;
    public transient String normSeqPrefix;
    public transient String normSeqSuffix;
    static /* synthetic */ Class class$com$cenqua$clover$registry$Modifiers;
    static /* synthetic */ Class class$com$cenqua$clover$registry$Parameter;

    public MethodSignature(String name) {
        this.name = name;
        this.tags = new HashMap<String, List<String>>();
    }

    public MethodSignature(String name, String typeParams, String returnType, Parameter[] parameters, String[] throwsTypes, Modifiers modifiers) {
        this(null, null, null, name, typeParams, returnType, parameters, throwsTypes);
        this.modifiers = modifiers;
    }

    public MethodSignature(CloverToken firstToken, CloverToken nameToken, CloverToken lastToken, String name, String typeParams, String returnType, Parameter[] parameters, String[] throwsTypes) {
        this(firstToken, nameToken, lastToken, new HashMap<String, List<String>>(), new Modifiers(), name, typeParams, returnType, parameters, throwsTypes);
    }

    public MethodSignature(CloverToken firstToken, CloverToken nameToken, CloverToken lastToken, Map<String, List<String>> tags, Modifiers modifiers, String name, String typeParams, String returnType, Parameter[] parameters, String[] throwsTypes) {
        if (firstToken != null || lastToken != null) {
            int mods = modifiers.getModifiers();
            mods &= 0xFFFFFFFA;
            this.normSeqPrefix = new StringBuffer().append(Modifier.toString(mods |= 2)).append(typeParams != null ? new StringBuffer().append(" ").append(typeParams).toString() : "").append(returnType != null ? new StringBuffer().append(" ").append(returnType).toString() : "").append(" ").toString();
            this.normSeqSuffix = TokenListUtil.getNormalisedSequence(nameToken.getNext(), lastToken);
        }
        this.tags = this.flyweightIfEmptyFor(tags);
        this.modifiers = modifiers;
        this.name = name;
        this.typeParams = typeParams;
        this.returnType = returnType;
        this.parameters = this.flyweightIfEmptyFor(parameters);
        this.throwsTypes = this.flyweightIfEmptyFor(throwsTypes);
    }

    public Map<String, List<String>> getTags() {
        return this.tags;
    }

    public int getModifiers() {
        return this.modifiers.getModifiers();
    }

    public void setModifiers(int modifiers) {
        this.modifiers.setModifiers(modifiers);
    }

    public Modifiers getFullModifiers() {
        return this.modifiers;
    }

    public Map getAnnotations() {
        return this.modifiers.getAnnotations();
    }

    public String getName() {
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getTypeParams() {
        return this.typeParams;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public boolean hasParams() {
        return this.parameters != null && this.parameters.length > 0;
    }

    public int getParamCount() {
        return this.parameters == null ? 0 : this.parameters.length;
    }

    public String listParamTypes() {
        StringBuffer types = new StringBuffer();
        String sep = "";
        for (int i = 0; this.parameters != null && i < this.parameters.length; ++i) {
            types.append(sep);
            types.append(this.parameters[i].getType());
            sep = ",";
        }
        return types.toString();
    }

    public String listParamIdents() {
        StringBuffer idents = new StringBuffer();
        String sep = "";
        for (int i = 0; this.parameters != null && i < this.parameters.length; ++i) {
            idents.append(sep);
            idents.append(this.parameters[i].getName());
            sep = ",";
        }
        return idents.toString();
    }

    public boolean hasThrowsTypes() {
        return this.throwsTypes != null && this.throwsTypes.length > 0;
    }

    public String[] getThrowsTypes() {
        return this.throwsTypes;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRenamedNormalisedSignature(String newName) {
        if (this.normSeqPrefix == null) {
            throw new IllegalStateException("This signature is not renameable.");
        }
        StringBuffer renamed = new StringBuffer();
        renamed.append(this.normSeqPrefix);
        renamed.append(" ");
        renamed.append(newName);
        renamed.append(this.normSeqSuffix);
        return renamed.toString();
    }

    private <K, V> Map<K, V> flyweightIfEmptyFor(Map<K, V> map) {
        return map == null || map.isEmpty() ? Collections.EMPTY_MAP : map;
    }

    private String[] flyweightIfEmptyFor(String[] strings) {
        return strings != null && strings.length == 0 ? EMPTY_STRINGS : strings;
    }

    private Parameter[] flyweightIfEmptyFor(Parameter[] params) {
        return params != null && params.length == 0 ? EMPTY_PARAMS : params;
    }

    public static void writeNull(DataOutput out) throws IOException {
        out.writeBoolean(false);
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.typeParams);
        out.writeUTF(this.returnType);
        Class<?> clazz = class$com$cenqua$clover$registry$Modifiers;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$registry$Modifiers = new Modifiers[0].getClass().getComponentType();
        }
        out.write(clazz, this.modifiers);
        Set<Map.Entry<String, List<String>>> entries = this.tags.entrySet();
        out.writeInt(entries.size());
        for (Map.Entry<String, List<String>> entry : entries) {
            out.writeUTF(entry.getKey());
            List<String> values = entry.getValue();
            out.writeInt(values.size());
            for (String value : values) {
                out.writeUTF(value);
            }
        }
        int numParameters = this.parameters == null ? 0 : this.parameters.length;
        out.writeInt(numParameters);
        for (int i = 0; i < numParameters; ++i) {
            Class<?> clazz2 = class$com$cenqua$clover$registry$Parameter;
            if (clazz2 == null) {
                clazz2 = new Parameter[0].getClass().getComponentType();
            }
            out.write(clazz2, this.parameters[i]);
        }
        int numThrowsTypes = this.throwsTypes == null ? 0 : this.throwsTypes.length;
        out.writeInt(numThrowsTypes);
        for (int i = 0; i < numThrowsTypes; ++i) {
            out.writeUTF(this.throwsTypes[i]);
        }
    }

    public static MethodSignature read(TaggedDataInput in) throws IOException {
        String name = in.readUTF();
        String typeParam = in.readUTF();
        String returnType = in.readUTF();
        Class<?> clazz = class$com$cenqua$clover$registry$Modifiers;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$registry$Modifiers = new Modifiers[0].getClass().getComponentType();
        }
        Modifiers modifiers = (Modifiers)in.read(clazz);
        int numTagEntries = in.readInt();
        HashMap<String, List<String>> tags = new HashMap<String, List<String>>();
        for (int i = 0; i < numTagEntries; ++i) {
            String key = in.readUTF();
            int numValues = in.readInt();
            LinkedList<String> values = new LinkedList<String>();
            for (int j = 0; j < numValues; ++j) {
                values.add(in.readUTF());
            }
            tags.put(key, values);
        }
        int numParameters = in.readInt();
        Parameter[] parameters = numParameters == 0 ? EMPTY_PARAMS : new Parameter[numParameters];
        for (int i = 0; i < numParameters; ++i) {
            Class<?> clazz2 = class$com$cenqua$clover$registry$Parameter;
            if (clazz2 == null) {
                clazz2 = new Parameter[0].getClass().getComponentType();
            }
            parameters[i] = (Parameter)in.read(clazz2);
        }
        int numThrowsTypes = in.readInt();
        String[] throwsTypes = numThrowsTypes == 0 ? EMPTY_STRINGS : new String[numThrowsTypes];
        for (int i = 0; i < numThrowsTypes; ++i) {
            throwsTypes[i] = in.readUTF();
        }
        return new MethodSignature(null, null, null, tags, modifiers, name, typeParam, returnType, parameters, throwsTypes);
    }

    public String getNormalizedSignature() {
        String modifiers = Modifier.toString(this.getModifiers());
        StringBuffer builder = new StringBuffer();
        builder.append(modifiers).append(" ");
        if (this.typeParams != null && !"".equals(this.typeParams)) {
            builder.append(this.typeParams).append(" ");
        }
        if (this.getReturnType() != null && this.getReturnType().length() > 0) {
            builder.append(this.getReturnType()).append(" ");
        }
        builder.append(this.getName());
        this.appendParameters(builder);
        this.appendThrowsClause(builder);
        return builder.toString();
    }

    private void appendThrowsClause(StringBuffer builder) {
        if (this.hasThrowsTypes()) {
            builder.append(" throws ");
            for (String e : this.getThrowsTypes()) {
                builder.append(e).append(", ");
            }
            MethodSignature.removeLastTwo(builder);
        }
    }

    private void appendParameters(StringBuffer builder) {
        builder.append("(");
        if (this.hasParams()) {
            for (Parameter param : this.getParameters()) {
                builder.append(param.getType()).append(" ").append(param.getName()).append(", ");
            }
            if (this.getParameters().length > 0) {
                MethodSignature.removeLastTwo(builder);
            }
        }
        builder.append(")");
    }

    private static void removeLastTwo(StringBuffer builder) {
        builder.delete(builder.length() - 2, builder.length());
    }

    public String toString() {
        return new StringBuffer().append("MethodSignature{throwsTypes=").append(this.throwsTypes == null ? null : Arrays.asList(this.throwsTypes)).append(", tags=").append(this.tags).append(", modifiers=").append(this.modifiers).append(", name='").append(this.name).append('\'').append(", typeParams='").append(this.typeParams).append('\'').append(", returnType='").append(this.returnType).append('\'').append(", parameters=").append(this.parameters == null ? null : Arrays.asList(this.parameters)).append('}').toString();
    }
}

