/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.registry;

import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicLong;
import com.atlassian.clover.instr.java.ConcurrentInstrumentationException;
import com.atlassian.clover.instr.java.InstrumentationSession;
import com.cenqua.clover.registry.CoverageDataProvider;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.InstrumentationTarget;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.RegUpdate;
import com.cenqua.clover.util.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public interface ProjectView
extends InstrumentationTarget {
    public static final ProjectView NONE = new ProjectView(){

        public ProjectInfo getProject() {
            return null;
        }

        public RegUpdate applyUpdate(long expectedVersion, InstrumentationSession.Update update) throws ConcurrentInstrumentationException {
            return null;
        }

        public void resolve(Path sourcePath) {
        }
    };

    public ProjectInfo getProject();

    public void resolve(Path var1);

    public static class Filtered
    implements ProjectView {
        private final HasMetricsFilter.Invertable filter;
        private final ProjectInfo project;

        public Filtered(HasMetricsFilter.Invertable filter, ProjectInfo orig) {
            this.filter = filter;
            this.project = orig.copy(filter);
        }

        public ProjectInfo getProject() {
            return this.project;
        }

        public RegUpdate applyUpdate(long expectedVersion, InstrumentationSession.Update update) throws ConcurrentInstrumentationException {
            this.project.setVersion(update.getVersion());
            CoverageDataProvider dataProvider = this.project.getDataProvider();
            int projLen = this.project.getDataLength();
            Iterator<PackageInfo> i$ = update.getChangedPkgInfos().iterator();
            while (i$.hasNext()) {
                PackageInfo updatedPkgInfo = i$.next();
                PackageInfo pkgInfo = (PackageInfo)this.project.getNamedPackage(updatedPkgInfo.getName());
                Iterator i$2 = updatedPkgInfo.getFiles().iterator();
                while (i$2.hasNext()) {
                    FileInfo fileInfo = (FileInfo)i$2.next();
                    if (!this.filter.accept(fileInfo)) continue;
                    if (pkgInfo == null) {
                        pkgInfo = new PackageInfo(this.project, updatedPkgInfo.getName(), updatedPkgInfo.getDataIndex());
                        pkgInfo.setDataProvider(dataProvider);
                        this.project.addPackage(pkgInfo);
                    }
                    FileInfo fileInfoCopy = fileInfo.copy(pkgInfo, this.filter);
                    fileInfoCopy.setDataProvider(dataProvider);
                    fileInfoCopy.setContainingPackage(pkgInfo);
                    pkgInfo.addFile(fileInfoCopy);
                }
                if (pkgInfo != null) {
                    pkgInfo.setDataLength(updatedPkgInfo.getDataIndex() + updatedPkgInfo.getDataLength() - pkgInfo.getDataIndex());
                    pkgInfo.invalidateCaches();
                }
                projLen = Math.max(projLen, update.getSlotCount());
            }
            this.project.setDataLength(projLen);
            this.project.invalidateCaches();
            return update;
        }

        private void setVersion(long version) {
            this.project.setVersion(version);
        }

        public void resolve(Path sourcePath) {
            this.project.resolve(sourcePath);
        }
    }

    public static class Original
    implements ProjectView {
        private final AtomicLong version;
        private final ProjectInfo project;
        private final Collection<Filtered> filteredViews;

        public Original(ProjectInfo project) {
            this.version = new AtomicLong(project.getVersion());
            this.project = project;
            this.filteredViews = new LinkedList<Filtered>();
        }

        public ProjectInfo getProject() {
            return this.project;
        }

        public Filtered newProjection(HasMetricsFilter.Invertable filter) {
            Filtered filteredView = new Filtered(filter, this.project);
            this.filteredViews.add(filteredView);
            return filteredView;
        }

        public RegUpdate applyUpdate(long expectedVersion, InstrumentationSession.Update update) throws ConcurrentInstrumentationException {
            if (!this.version.compareAndSet(expectedVersion, update.getVersion())) {
                throw new ConcurrentInstrumentationException("Expected registry version: " + this.version.get() + ". Actual registry version: " + update.getVersion());
            }
            this.project.setVersion(update.getVersion());
            CoverageDataProvider dataProvider = this.project.getDataProvider();
            int projLen = this.project.getDataLength();
            Iterator<Object> i$ = update.getChangedPkgInfos().iterator();
            while (i$.hasNext()) {
                PackageInfo updatedPkgInfo = i$.next();
                PackageInfo pkgInfo = (PackageInfo)this.project.getNamedPackage(updatedPkgInfo.getName());
                if (pkgInfo == null) {
                    updatedPkgInfo.setDataProvider(dataProvider);
                    this.project.addPackage(updatedPkgInfo);
                } else {
                    Iterator i$2 = updatedPkgInfo.getFiles().iterator();
                    while (i$2.hasNext()) {
                        FileInfo fileInfo = (FileInfo)i$2.next();
                        fileInfo.setContainingPackage(pkgInfo);
                        fileInfo.setDataProvider(dataProvider);
                        pkgInfo.addFile(fileInfo);
                    }
                    pkgInfo.setDataLength(updatedPkgInfo.getDataIndex() + updatedPkgInfo.getDataLength() - pkgInfo.getDataIndex());
                    pkgInfo.invalidateCaches();
                }
                projLen = Math.max(projLen, update.getSlotCount());
            }
            this.project.setDataLength(projLen);
            this.project.invalidateCaches();
            i$ = this.filteredViews.iterator();
            while (i$.hasNext()) {
                Filtered projection = (Filtered)i$.next();
                projection.applyUpdate(expectedVersion, update);
            }
            return update;
        }

        public long getVersion() {
            return this.version.get();
        }

        public void setVersion(long version) {
            this.version.set(version);
            this.project.setVersion(version);
            Iterator<Filtered> i$ = this.filteredViews.iterator();
            while (i$.hasNext()) {
                Filtered filteredView = i$.next();
                filteredView.setVersion(version);
            }
        }

        public void resolve(Path sourcePath) {
            this.project.resolve(sourcePath);
        }
    }
}

