/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.console;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._String;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CloverStartup;
import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.Logger;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.ClassMetrics;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.LineInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectMetrics;
import com.cenqua.clover.registry.StatementInfo;
import com.cenqua.clover.util.Color;
import com.cenqua.clover.util.Formatting;
import com.cenqua.clover.util.Path;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ConsoleReporter {
    private static final Logger LOG = Logger.getInstance();
    private final Config cfg;
    static /* synthetic */ Class class$com$cenqua$clover$reporters$console$ConsoleReporter;

    public ConsoleReporter(Config cfg) {
        this.cfg = cfg;
    }

    public void report(PrintWriter out, CloverDatabase db) {
        out.print("Clover Coverage Report");
        if (this.cfg.title != null) {
            out.println(" - " + this.cfg.title);
        } else {
            out.println();
        }
        out.println("Coverage Timestamp: " + new Date(db.getRecordingTimestamp()));
        List<? extends BasePackageInfo> packages = db.getModel().getPackages();
        if (this.cfg.showPackages) {
            out.println();
            out.println("Package Summary - ");
        }
        Iterator<? extends BasePackageInfo> pkgs = packages.iterator();
        while (pkgs.hasNext()) {
            PackageInfo pkg = (PackageInfo)pkgs.next();
            if (this.cfg.packageSet != null && !this.cfg.packageSet.contains(pkg.getName())) continue;
            if (this.cfg.showPackages) {
                out.println(pkg.getName() + ": " + Formatting.getPercentStr(pkg.getMetrics().getPcCoveredElements()));
            }
            List fileInfos = pkg.getFiles();
            Iterator files = fileInfos.iterator();
            while (files.hasNext()) {
                FileInfo fInfo = (FileInfo)files.next();
                if (this.cfg.showClasses) {
                    out.println("---------------------------------------");
                    out.println("File: " + fInfo.getPackagePath());
                    List classes = fInfo.getClasses();
                    Iterator it = classes.iterator();
                    while (it.hasNext()) {
                        ClassInfo cInfo = (ClassInfo)it.next();
                        ClassMetrics metrics = (ClassMetrics)cInfo.getMetrics();
                        out.println("Package: " + cInfo.getPackage().getName());
                        this.printMetricsSummary(out, "Class: " + cInfo.getName(), metrics);
                    }
                }
                LineInfo[] lines = fInfo.getLineInfo();
                for (int linenum = 0; linenum < lines.length; ++linenum) {
                    BranchInfo[] branches;
                    int m;
                    MethodInfo[] starts;
                    LineInfo info = lines[linenum];
                    if (info == null) continue;
                    if (this.cfg.showMethods && (starts = info.getMethodStarts()) != null) {
                        for (m = 0; m < starts.length; ++m) {
                            if (starts[m].getHitCount() != 0) continue;
                            out.println(fInfo.getPhysicalFile().getAbsolutePath() + ":" + starts[m].getStartLine() + ":" + starts[m].getStartColumn() + ": method not entered.");
                        }
                    }
                    if (!this.cfg.showStatements) continue;
                    StatementInfo[] stmts = info.getStatements();
                    if (stmts != null) {
                        for (m = 0; m < stmts.length; ++m) {
                            if (stmts[m].getHitCount() != 0) continue;
                            out.println(fInfo.getPhysicalFile().getAbsolutePath() + ":" + stmts[m].getStartLine() + ":" + stmts[m].getStartColumn() + ": statement not executed.");
                        }
                    }
                    if ((branches = info.getBranches()) == null) continue;
                    for (int m2 = 0; m2 < branches.length; ++m2) {
                        String prefix = fInfo.getPhysicalFile().getAbsolutePath() + ":" + branches[m2].getStartLine() + ":" + branches[m2].getStartColumn() + ": ";
                        if (!branches[m2].isInstrumented()) {
                            out.println(prefix + "was not instumented, due to assignment in expression.");
                            continue;
                        }
                        if (branches[m2].getTrueHitCount() == 0 && branches[m2].getFalseHitCount() == 0) {
                            out.println(prefix + "branch not evaluated.");
                            continue;
                        }
                        if (branches[m2].getTrueHitCount() == 0) {
                            out.println(prefix + "true branch never taken.");
                            continue;
                        }
                        if (branches[m2].getFalseHitCount() != 0) continue;
                        out.println(prefix + "false branch never taken.");
                    }
                }
            }
        }
        out.println();
        out.println();
        ProjectMetrics overview = (ProjectMetrics)db.getModel().getMetrics();
        this.printMetricsSummary(out, "Coverage Overview -", overview);
        out.flush();
    }

    void printMetricsSummary(PrintWriter out, String title, ClassMetrics metrics) {
        out.println(title);
        out.println("Coverage:-");
        String methodSummary = ConsoleReporter.infoSummaryString(metrics.getNumCoveredMethods(), metrics.getNumMethods(), metrics.getPcCoveredMethods());
        String stmtSummary = ConsoleReporter.infoSummaryString(metrics.getNumCoveredStatements(), metrics.getNumStatements(), metrics.getPcCoveredStatements());
        String branchSummary = ConsoleReporter.infoSummaryString(metrics.getNumCoveredBranches(), metrics.getNumBranches(), metrics.getPcCoveredBranches());
        String totalSummary = Color.make(Formatting.getPercentStr(metrics.getPcCoveredElements())).b().toString();
        out.print("      Methods: " + methodSummary);
        this.printPcBar(out, methodSummary, metrics.getPcCoveredMethods());
        out.print("   Statements: " + stmtSummary);
        this.printPcBar(out, stmtSummary, metrics.getPcCoveredStatements());
        out.print("     Branches: " + branchSummary);
        this.printPcBar(out, branchSummary, metrics.getPcCoveredBranches());
        out.print("        Total: " + totalSummary);
        this.printPcBar(out, totalSummary, metrics.getPcCoveredElements());
        out.println("Complexity:-");
        out.println("   Avg Method: " + metrics.getAvgMethodComplexity());
        out.println("      Density: " + metrics.getComplexityDensity());
        out.println("        Total: " + metrics.getComplexity());
    }

    private void printPcBar(PrintWriter out, String summary, float amt) {
        int padLen = 32 - summary.length();
        out.print(_String.format("%" + padLen + "s", new Object[]{" "}));
        int len = 80;
        int pc = (int)(amt * 80.0f);
        for (int i = 0; i <= 80; ++i) {
            if (i < pc) {
                out.print(Color.make(" ").bg().green());
                continue;
            }
            out.print(Color.make(" ").bg().red());
        }
        out.println();
    }

    private static String infoSummaryString(int covered, int total, float percent) {
        StringBuffer buf = new StringBuffer();
        buf.append(covered).append("/").append(total);
        buf.append(" (").append(Color.make(Formatting.getPercentStr(percent)).b()).append(")");
        return buf.toString();
    }

    private static void usage() {
        System.err.println();
        StringBuffer stringBuffer = new StringBuffer().append("  USAGE: ");
        Class<?> clazz = class$com$cenqua$clover$reporters$console$ConsoleReporter;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$reporters$console$ConsoleReporter = new ConsoleReporter[0].getClass().getComponentType();
        }
        System.err.println(stringBuffer.append(clazz.getName()).append(" [OPTIONS] PARAMS").toString());
        System.err.println();
        System.err.println("  PARAMS:");
        System.err.println("    -i, --initstring <string>\tclover initstring\n\n  OPTIONS:\n    -l, --level <string>\tThe level of detail to report. Valid\n\t\t\t\tvalues are \"summary\",\"class\",\"method\",\"statement\".\n\t\t\t\tDefault value is \"summary\".\n\n    -p, --sourcepath\t\tThe sourcepath that Clover should search on for source files.\n\n    -s, --span <interval>\tSpecifies how far back in time to\n\t\t\t\tinclude coverage recordings from since the last Clover build. In Interval\n\t\t\t\tformat. \"60s\" = 60 seconds, \"1h\" = 1 hour, \"1d\" = 1 day etc.\n\n    -t, --title <string>\treport title.\n");
    }

    public static void main(String[] args) {
        System.exit(ConsoleReporter.mainImpl(args));
    }

    public static int mainImpl(String[] args) {
        CloverStartup.loadLicense(LOG);
        Config config = new Config();
        if (!config.processArgs(args)) {
            ConsoleReporter.usage();
            return 1;
        }
        ConsoleReporter reporter = new ConsoleReporter(config);
        try {
            CloverDatabase db = new CloverDatabase(config.initstring);
            db.loadCoverageData(new CoverageDataSpec(config.getSpan().getValueInMillis()));
            if (config.getSourcepath() != null) {
                db.resolve(config.getSourcepath());
            }
            reporter.report(new PrintWriter(System.out), db);
            return 0;
        }
        catch (Exception e) {
            LOG.error("An error occurred while generating the report: " + e.getMessage(), e);
            return 1;
        }
    }

    public static class Config {
        String level = "summary";
        String title;
        String initstring;
        Set packageSet;
        boolean showPackages = false;
        boolean showClasses = false;
        boolean showMethods = false;
        boolean showStatements = false;
        Interval span = Interval.DEFAULT_SPAN;
        Path sourcepath = null;

        public void setPackageSet(Set packageSet) {
            this.packageSet = packageSet;
        }

        public void setInitString(String initString) {
            this.initstring = initString;
        }

        public void setLevel(String level) {
            this.level = level;
        }

        public Interval getSpan() {
            return this.span;
        }

        public void setSpan(Interval span) {
            this.span = span;
        }

        public Path getSourcepath() {
            return this.sourcepath;
        }

        public void setSourcepath(Path sourcepath) {
            this.sourcepath = sourcepath;
        }

        public boolean validate() {
            boolean valid;
            boolean bl = valid = this.level != null && (this.level.equalsIgnoreCase("summary") || this.level.equalsIgnoreCase("package") || this.level.equalsIgnoreCase("class") || this.level.equalsIgnoreCase("method") || this.level.equalsIgnoreCase("statement"));
            if (!valid) {
                System.err.println("  *** ERROR: Invalid reporting level \"" + this.level + "\"");
                return false;
            }
            if (this.level.equalsIgnoreCase("package")) {
                this.showPackages = true;
            } else if (this.level.equalsIgnoreCase("class")) {
                this.showClasses = true;
            } else if (this.level.equalsIgnoreCase("method")) {
                this.showClasses = true;
                this.showMethods = true;
            } else if (this.level.equalsIgnoreCase("statement")) {
                this.showClasses = true;
                this.showMethods = true;
                this.showStatements = true;
            }
            boolean bl2 = valid = this.initstring != null && this.initstring.length() > 0;
            if (!valid) {
                System.err.println("  *** ERROR: initstring not set");
                return false;
            }
            return true;
        }

        boolean processArgs(String[] args) {
            try {
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].equals("-l") || args[i].equals("--level")) {
                        this.level = args[++i];
                        continue;
                    }
                    if (args[i].equals("-i") || args[i].equals("--initstring")) {
                        this.initstring = args[++i];
                        continue;
                    }
                    if (args[i].equals("-t") || args[i].equals("--title")) {
                        this.title = args[++i];
                        continue;
                    }
                    if (args[i].equals("-p") || args[i].equals("--sourcepath")) {
                        this.sourcepath = new Path(args[++i]);
                        continue;
                    }
                    if (args[i].equals("-s") || args[i].equals("--span")) {
                        ++i;
                        try {
                            this.setSpan(new Interval(args[i]));
                            continue;
                        }
                        catch (NumberFormatException e) {
                            System.err.println("  *** ERROR: Invalid interval format. Should be integer followed by unit (s, m, h, d, w).");
                            return false;
                        }
                    }
                    System.err.println("  *** ERROR: unknown parameter \"" + args[i] + "\"");
                    return false;
                }
                return this.validate();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println("  *** ERROR: Invalid number of parameters");
                return false;
            }
        }
    }
}

