/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html.source;

import clover.org.apache.velocity.VelocityContext;
import cloverantlr.TokenStreamException;
import com.atlassian.clover.lang.Language;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.Logger;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ElementInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.LineInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.SourceRegion;
import com.cenqua.clover.registry.StatementInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.html.HtmlRenderingSupport;
import com.cenqua.clover.reporters.html.JSONObjectFactory;
import com.cenqua.clover.reporters.html.source.LineRenderInfo;
import com.cenqua.clover.reporters.html.source.PlaintextSourceRenderKit;
import com.cenqua.clover.reporters.html.source.SourceRenderKit;
import com.cenqua.clover.util.ChecksummingReader;
import com.cenqua.clover.util.Formatting;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceRenderHelper {
    private static final Map<String, SourceRenderKit> RENDER_KITS;
    private static final String[][] METHOD_OPTIONS;
    private static final String[][] FIELD_OPTIONS;
    private static final String[][] STATEMENT_OPTIONS;
    private static final String[][] BRANCH_OPTIONS;
    private static final String[][] TERNARY_OPTIONS;
    private static final String[][] ELVIS_OPTIONS;
    private static final String[][] SAFE_METHOD_OPTIONS;
    private static final String[][] SAFE_PROPERTY_OPTIONS;
    private static final String[][] SAFE_ATTRIBUTE_OPTIONS;
    private CloverDatabase database;
    private Current report;
    private HtmlRenderingSupport renderingHelper;
    private boolean outOfDate;

    private static Map<String, SourceRenderKit> addRenderer(Language language, String className) {
        HashMap<String, SourceRenderKit> kits = new HashMap<String, SourceRenderKit>();
        try {
            SourceRenderKit groovyRenderKit = (SourceRenderKit)Class.forName(className).newInstance();
            for (String extension : language.getExtensions()) {
                kits.put(extension, groovyRenderKit);
            }
        }
        catch (Exception e) {
            Logger.getInstance().error(new StringBuffer().append("Failed to register syntax highlighters for ").append(language.name()).append(" files - syntax highlighting will not be performed for these").toString(), e);
        }
        return kits;
    }

    public SourceRenderHelper(CloverDatabase database, Current report, HtmlRenderingSupport renderingHelper) {
        this.database = database;
        this.report = report;
        this.renderingHelper = renderingHelper;
    }

    public void insertLineInfosForFile(FileInfo fileInfo, VelocityContext context, ContextSet contextSet, String emptyChar, List[] testLineInfo) throws TokenStreamException {
        try {
            LineRenderInfo[] renderInfo = this.gatherSrcRenderInfo(context, fileInfo, contextSet, emptyChar, testLineInfo);
            context.put("renderInfo", renderInfo);
            context.put("jsonSrcFileLines", JSONObjectFactory.getJSONSrcFileLines(renderInfo, fileInfo.getName()));
            if (this.outOfDate) {
                this.addWarning(context, "The source file used to generate this report was changed after Clover generated coverage information. The coverage reported may not match the source lines. You should regenerate the coverage information and the report to ensure the files are in sync.");
                Logger.getInstance().warn(new StringBuffer().append("Source file ").append(fileInfo.getPhysicalFile()).append(" has changed since coverage information was").append(" generated").toString());
            }
        }
        catch (FileNotFoundException e) {
            Logger.getInstance().error(e);
            this.putErrorMessage(context, new StringBuffer().append("Clover could not read the source file \"").append(fileInfo.getPhysicalFile().getAbsolutePath()).append("\"").toString());
        }
        catch (Exception e) {
            Logger.getInstance().error(e);
            this.putErrorMessage(context, "Clover encountered a problem rendering the source for this file.");
        }
    }

    private void putErrorMessage(VelocityContext context, String message) {
        context.put("errormsg", message);
    }

    private void addWarning(VelocityContext context, String message) {
        ArrayList<String> warningMessages = (ArrayList<String>)context.get("warningMessages");
        if (warningMessages == null) {
            warningMessages = new ArrayList<String>();
        }
        warningMessages.add(message);
        context.put("warningMessages", warningMessages);
    }

    public LineRenderInfo[] gatherSrcRenderInfo(VelocityContext vc, FileInfo finfo, ContextSet contextSet, String emptyCoverageChar, List[] testLineInfo) throws Exception {
        ChecksummingReader csr;
        finfo.setDataProvider(this.database.getCoverageData());
        int lineCount = finfo.getLineCount();
        ArrayList<LineRenderInfo> renderedLines = new ArrayList<LineRenderInfo>(lineCount);
        String spaceChar = this.report.getFormat().getSpaceChar();
        if (spaceChar == null || spaceChar.length() == 0) {
            spaceChar = " ";
        }
        String tabStr = "";
        for (int j = 0; j < this.report.getFormat().getTabWidth(); ++j) {
            tabStr = new StringBuffer().append(tabStr).append(spaceChar).toString();
        }
        Logger.getInstance().debug(new StringBuffer().append("Renderers: ").append(RENDER_KITS).toString());
        try {
            SourceRenderKit renderKit = RENDER_KITS.get(this.extensionOf(finfo.getName()));
            if (renderKit == null) {
                Logger.getInstance().debug(new StringBuffer().append("Using plaintext renderer for file ").append(finfo.getName()).toString());
                renderKit = new PlaintextSourceRenderKit();
            } else {
                Logger.getInstance().debug(new StringBuffer().append("Found source renderer ").append(renderKit.getClass().getName()).append(" for file ").append(finfo.getName()).toString());
            }
            csr = this.render(finfo, renderedLines, emptyCoverageChar, spaceChar, tabStr, renderKit);
        }
        catch (Throwable t) {
            Logger.getInstance().error(new StringBuffer().append("Failed to render syntax highlights for ").append(finfo.getPhysicalFile().getAbsolutePath()).toString(), t);
            this.putErrorMessage(vc, "Clover encountered a problem rendering the source for this file. Syntax highlighting has been disabled.");
            renderedLines.clear();
            csr = this.render(finfo, renderedLines, emptyCoverageChar, spaceChar, tabStr, new PlaintextSourceRenderKit());
        }
        LineInfo[] lines = finfo.getLineInfo(renderedLines.size() + 1);
        for (int i = 0; i < renderedLines.size(); ++i) {
            List testsForLine;
            LineInfo linfo;
            String ccstr;
            int headlineHits;
            String msg;
            ContextSet filteredCtx;
            boolean hilightBad;
            boolean hilightInfo;
            boolean hasSomeCoverage;
            block28: {
                hasSomeCoverage = false;
                hilightInfo = false;
                hilightBad = false;
                filteredCtx = null;
                msg = "";
                headlineHits = -1;
                ccstr = emptyCoverageChar;
                linfo = lines[i + 1];
                if (linfo != null) {
                    List<ElementInfo> lineElements = linfo.getColumnOrderedElementInfos();
                    for (ElementInfo lineElement : lineElements) {
                        if (filteredCtx != null || lineElement.isFiltered(contextSet)) {
                            filteredCtx = lineElement.getContext();
                            break block28;
                        }
                        if (lineElement.getHitCount() <= 0) continue;
                        hasSomeCoverage = true;
                        break;
                    }
                    for (ElementInfo lineElement : lineElements) {
                        String[] messages;
                        if (this.noHits(lineElement)) {
                            messages = this.calcCoverageMsg(lineElement, emptyCoverageChar);
                            msg = messages[0];
                            ccstr = messages[1];
                            headlineHits = this.hitCounts(lineElement);
                            hilightBad = true;
                            break;
                        }
                        messages = this.calcCoverageMsg(lineElement, emptyCoverageChar);
                        msg = messages[0];
                        ccstr = messages[1];
                        headlineHits = this.hitCounts(lineElement);
                    }
                }
            }
            if (headlineHits >= 0) {
                hilightInfo = true;
                if (ccstr.equals(emptyCoverageChar) && filteredCtx == null) {
                    ccstr = new StringBuffer().append("").append(headlineHits).toString();
                }
            }
            if (renderedLines.size() <= i || renderedLines.get(i) == null) {
                renderedLines.add(new LineRenderInfo(emptyCoverageChar));
            }
            LineRenderInfo thisLine = (LineRenderInfo)renderedLines.get(i);
            if (linfo != null && linfo.hasClassStarts()) {
                thisLine.classStart = linfo.getClassStarts()[0];
            }
            if (linfo != null && linfo.hasMethodStarts()) {
                thisLine.methodStart = linfo.getMethodStarts()[0];
            }
            if (linfo != null && linfo.hasFailStackEntries()) {
                thisLine.failedStackEntries = linfo.getFailStackEntries();
            }
            boolean classStart = thisLine.classStart != null;
            String hitClass = "missedByTest";
            List list = testsForLine = testLineInfo == null || i + 1 >= testLineInfo.length ? null : testLineInfo[i + 1];
            if (testsForLine != null) {
                for (TestCaseInfo tci : testsForLine) {
                    if (!tci.isSuccess()) {
                        hitClass = "hitByFailedTest";
                        continue;
                    }
                    hitClass = "hitByTest";
                    break;
                }
            }
            if (filteredCtx != null) {
                thisLine.lineNumberCSS = "lineCount Filtered";
                thisLine.coverageCountCSS = "coverageCount Filtered";
                thisLine.testHitCSS = "missedByTest";
                thisLine.sourceCSS = "srcLineFiltered";
                thisLine.filtered = true;
                filteredCtx = filteredCtx.and(contextSet);
                String contextString = this.database.getContextStore().getContextsAsString(filteredCtx);
                msg = new StringBuffer().append("Filtered by: ").append(this.renderingHelper.htmlEscapeStr(contextString)).toString();
            } else if (hilightBad) {
                thisLine.lineNumberCSS = new StringBuffer().append("lineCount ").append(hasSomeCoverage ? "Good" : "Bad").toString();
                thisLine.coverageCountCSS = "coverageCount Bad";
                thisLine.sourceCSS = "srcLineHilight";
                thisLine.testHitCSS = hitClass;
            } else if (hilightInfo) {
                thisLine.lineNumberCSS = "lineCount Good";
                thisLine.coverageCountCSS = "coverageCount Good";
                thisLine.sourceCSS = "srcLine";
                thisLine.testHitCSS = hitClass;
            } else {
                thisLine.lineNumberCSS = "lineCount NoHilight";
                thisLine.coverageCountCSS = "coverageCount NoHilight";
                thisLine.sourceCSS = "srcLine";
            }
            if (this.outOfDate) {
                thisLine.lineNumberCSS = "lineWarning";
            }
            thisLine.hilight = hilightInfo && filteredCtx == null;
            thisLine.coverageStr = ccstr;
            thisLine.msg = msg;
            thisLine.testHits = testsForLine != null ? testsForLine : Collections.EMPTY_LIST;
        }
        this.outOfDate = csr.getChecksum() != finfo.getChecksum();
        return renderedLines.toArray(new LineRenderInfo[renderedLines.size()]);
    }

    private String[] calcCoverageMsg(ElementInfo lineElement, String emptyCoverageChar) {
        if (lineElement instanceof MethodInfo) {
            return new String[]{this.calcMethodCoverageMsg((MethodInfo)lineElement), emptyCoverageChar};
        }
        if (lineElement instanceof StatementInfo) {
            return new String[]{this.calcStatementCoverageMsg((StatementInfo)lineElement), emptyCoverageChar};
        }
        return this.calcBranchCoverageMsg((BranchInfo)lineElement, emptyCoverageChar);
    }

    private boolean noHits(ElementInfo lineElement) {
        return lineElement instanceof BranchInfo ? ((BranchInfo)lineElement).getTrueHitCount() == 0 || ((BranchInfo)lineElement).getFalseHitCount() == 0 : lineElement.getHitCount() == 0;
    }

    private int hitCounts(ElementInfo lineElement) {
        if (lineElement instanceof BranchInfo) {
            int tc = ((BranchInfo)lineElement).getTrueHitCount();
            int fc = ((BranchInfo)lineElement).getFalseHitCount();
            int hits = tc == Integer.MAX_VALUE || fc == Integer.MAX_VALUE ? Integer.MAX_VALUE : tc + fc;
            return hits < 0 ? Integer.MAX_VALUE : hits;
        }
        return lineElement.getHitCount();
    }

    private String[] calcBranchCoverageMsg(BranchInfo branchInfo, String emptyCoverageChar) {
        String[][] options;
        if (!branchInfo.isInstrumented()) {
            return new String[]{new StringBuffer().append(this.getRegionStartStr(branchInfo)).append("coverage not measured due to assignment in expression.").toString(), "?"};
        }
        switch (branchInfo.getConstruct()) {
            case ELVIS_OPERATOR: {
                options = ELVIS_OPTIONS;
                break;
            }
            case SAFE_METHOD: {
                options = SAFE_METHOD_OPTIONS;
                break;
            }
            case SAFE_ATTRIBUTE: {
                options = SAFE_ATTRIBUTE_OPTIONS;
                break;
            }
            case SAFE_PROPERTY: {
                options = SAFE_PROPERTY_OPTIONS;
                break;
            }
            default: {
                options = BRANCH_OPTIONS;
            }
        }
        return new String[]{new StringBuffer().append(this.getRegionStartStr(branchInfo)).append(options[0][0]).append(" ").append(options[1][0]).append(" ").append(Formatting.pluralizedVal(branchInfo.getTrueHitCount(), "time")).append(", ").append(options[0][1]).append(" ").append(options[1][1]).append(" ").append(Formatting.pluralizedVal(branchInfo.getFalseHitCount(), "time")).append(".").toString(), emptyCoverageChar};
    }

    private String calcStatementCoverageMsg(StatementInfo statementInfo) {
        return new StringBuffer().append(this.getRegionStartStr(statementInfo)).append(STATEMENT_OPTIONS[0][0]).append(statementInfo.getHitCount() == 0 ? new StringBuffer().append(" ").append(STATEMENT_OPTIONS[1][1]).append(".").toString() : new StringBuffer().append(" ").append(STATEMENT_OPTIONS[1][0]).append(" ").append(Formatting.pluralizedVal(statementInfo.getHitCount(), "time")).append(".").toString()).toString();
    }

    private String calcMethodCoverageMsg(MethodInfo methodInfo) {
        String[][] options;
        switch (methodInfo.getConstruct()) {
            case FIELD_EXPRESSION: {
                options = FIELD_OPTIONS;
                break;
            }
            default: {
                options = METHOD_OPTIONS;
            }
        }
        return new StringBuffer().append(this.getRegionStartStr(methodInfo)).append(options[0][0]).append(methodInfo.getHitCount() == 0 ? new StringBuffer().append(" ").append(options[1][1]).append(".").toString() : new StringBuffer().append(" ").append(options[1][0]).append(" ").append(Formatting.pluralizedVal(methodInfo.getHitCount(), "time")).append(".").toString()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChecksummingReader render(FileInfo finfo, List renderedLines, String emptyCoverageMsg, String spaceChar, String tabStr, SourceRenderKit renderKit) throws Exception {
        Logger.getInstance().debug(new StringBuffer().append("Rendering ").append(finfo.getName()).append(" with renderer ").append(renderKit.getClass().getName()).toString());
        ChecksummingReader csr = SourceRenderHelper.getChecksummingReader(finfo);
        try {
            renderKit.render(csr, finfo, renderedLines, this.renderingHelper, emptyCoverageMsg, tabStr, spaceChar);
        }
        finally {
            csr.close();
        }
        return csr;
    }

    private String extensionOf(String path) {
        return path.substring(Math.max(0, path.lastIndexOf(46)), path.length());
    }

    public static List<String> getSrcLines(FileInfo finfo) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(finfo.getSourceReader());
        ArrayList<String> srclines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            srclines.add(line);
        }
        return srclines;
    }

    private static ChecksummingReader getChecksummingReader(FileInfo finfo) throws FileNotFoundException, UnsupportedEncodingException {
        return new ChecksummingReader(finfo.getSourceReader());
    }

    private String getRegionStartStr(SourceRegion reg) {
        return new StringBuffer().append("Line ").append(reg.getStartLine()).append(", Col ").append(reg.getStartColumn()).append(": ").toString();
    }

    static {
        METHOD_OPTIONS = new String[][]{{"method"}, {"entered", "not entered"}};
        FIELD_OPTIONS = new String[][]{{"field"}, {"initialised", "not initialised"}};
        STATEMENT_OPTIONS = new String[][]{{"statement"}, {"executed", "not executed"}};
        BRANCH_OPTIONS = new String[][]{{"true branch", "false branch"}, {"executed", "executed"}};
        TERNARY_OPTIONS = new String[][]{{"true branch", "false branch"}, {"executed", "executed"}};
        ELVIS_OPTIONS = new String[][]{{"elvis expression", ""}, {"defaulted", "evaluated alternate expression"}};
        SAFE_METHOD_OPTIONS = new String[][]{{"safe method call", ""}, {"had non-null target", "null target"}};
        SAFE_PROPERTY_OPTIONS = new String[][]{{"safe property call", ""}, {"had non-null target", "null target"}};
        SAFE_ATTRIBUTE_OPTIONS = new String[][]{{"safe attribute call", ""}, {"had non-null target", "null target"}};
        RENDER_KITS = new HashMap<String, SourceRenderKit>(){
            {
                this.putAll(SourceRenderHelper.addRenderer(Language.GROOVY, "com.atlassian.clover.reporters.html.source.groovy.GroovySourceRenderKit"));
                this.putAll(SourceRenderHelper.addRenderer(Language.JAVA, "com.cenqua.clover.reporters.html.source.java.JavaSourceRenderKit"));
            }
        };
    }
}

