/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html.source.java;

import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.reporters.html.HtmlRenderingSupport;
import com.cenqua.clover.reporters.html.source.LineRenderInfo;
import com.cenqua.clover.reporters.html.source.PlaintextHtmlSourceRenderer;
import com.cenqua.clover.reporters.html.source.java.JavaSourceListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaHtmlSourceRenderer
extends PlaintextHtmlSourceRenderer
implements JavaSourceListener {
    protected static final String CLOSE_SPAN = "</span>";
    protected static final String OPEN_KEYWORD = "<span class=\"keyword\">";
    protected static final String CLOSE_KEYWORD = "</span>";
    protected static final String OPEN_STRING = "<span class=\"string\">";
    protected static final String CLOSE_STRING = "</span>";
    protected static final String OPEN_JDOCTAG = "<span class=\"javadoc\">";
    protected static final String CLOSE_JDOCTAG = "</span>";
    protected static final String OPEN_COMMENT = "<span class=\"comment\">";
    protected static final String CLOSE_COMMENT = "</span>";
    private final ProjectInfo projectInfo;
    private final PackageInfo packageInfo;
    private final Set<PackageInfo> pkgsInScope = new HashSet<PackageInfo>();
    private final Map classesInScope = new HashMap();

    public JavaHtmlSourceRenderer(FileInfo fileInfo, List<LineRenderInfo> lineInfo, HtmlRenderingSupport renderingHelper, String emptyCoverageMsg, String tab, String space) {
        super(lineInfo, renderingHelper, emptyCoverageMsg, tab, space);
        this.packageInfo = (PackageInfo)fileInfo.getContainingPackage();
        this.projectInfo = (ProjectInfo)this.packageInfo.getContainingProject();
    }

    @Override
    public void onImport(String imp) {
        if (imp.endsWith("*")) {
            String pkg = imp.substring(0, imp.lastIndexOf(46));
            PackageInfo pkgInfo = (PackageInfo)this.projectInfo.getNamedPackage(pkg);
            if (pkgInfo != null) {
                this.pkgsInScope.add(pkgInfo);
            }
        } else {
            ClassInfo cInfo = (ClassInfo)this.projectInfo.findClass(imp);
            if (cInfo != null) {
                this.classesInScope.put(cInfo.getName(), cInfo);
            }
        }
    }

    private ClassInfo searchInScope(String ident) {
        ClassInfo cInfo = (ClassInfo)this.classesInScope.get(ident);
        if (cInfo == null && (cInfo = (ClassInfo)this.projectInfo.findClass(new StringBuffer().append(this.packageInfo.getName()).append(".").append(ident).toString())) == null) {
            for (PackageInfo pkgInfo : this.pkgsInScope) {
                cInfo = (ClassInfo)this.projectInfo.findClass(new StringBuffer().append(pkgInfo.getName()).append(".").append(ident).toString());
                if (cInfo == null) continue;
                this.classesInScope.put(ident, cInfo);
            }
        }
        return cInfo;
    }

    @Override
    public void onStringLiteral(String s) {
        this.out.append(OPEN_STRING);
        this.out.append(this.renderingHelper.htmlEscapeStr(s, this.tab, this.space));
        this.out.append("</span>");
    }

    @Override
    public void onKeyword(String s) {
        this.out.append(OPEN_KEYWORD);
        this.out.append(s);
        this.out.append("</span>");
    }

    @Override
    public void onCommentChunk(String s) {
        this.out.append(OPEN_COMMENT);
        this.out.append(this.renderingHelper.htmlEscapeStr(s, this.tab, this.space));
        this.out.append("</span>");
    }

    @Override
    public void onJavadocTag(String s) {
        this.out.append(OPEN_JDOCTAG);
        this.out.append(s);
        this.out.append("</span>");
    }

    @Override
    public void onPackageSegment(String packageName, String seg) {
        if (this.projectInfo.getNamedPackage(packageName) != null) {
            this.out.append("<a href=\"").append(this.renderingHelper.getPackageRelPath(packageName, this.packageInfo.getName())).append("pkg-summary.html\">");
            this.out.append(seg);
            this.out.append("</a>");
        } else {
            this.out.append(seg);
        }
    }

    @Override
    public void onImportSegment(String accum, String seg) {
        if (this.projectInfo.getNamedPackage(accum) != null) {
            this.out.append("<a href=\"").append(this.renderingHelper.getPackageRelPath(accum, this.packageInfo.getName())).append("pkg-summary.html\">");
            this.out.append(seg);
            this.out.append("</a>");
        } else {
            ClassInfo clazz = (ClassInfo)this.projectInfo.findClass(accum);
            if (clazz != null) {
                this.out.append("<a href=\"").append(this.renderingHelper.getRootRelPath(this.packageInfo.getName())).append(this.renderingHelper.getSrcFileLink(true, clazz)).append("\">");
                this.out.append(seg);
                this.out.append("</a>");
            } else {
                this.out.append(seg);
            }
        }
    }

    @Override
    public void onIdentifier(String id) {
        ClassInfo cInfo = this.searchInScope(id);
        if (cInfo != null) {
            this.out.append("<a href=\"").append(this.renderingHelper.getRootRelPath(this.packageInfo.getName())).append(this.renderingHelper.getSrcFileLink(true, cInfo)).append("\">");
            this.out.append(id);
            this.out.append("</a>");
        } else {
            this.out.append(id);
        }
    }
}

