/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.json;

import clover.com.google.gson.Gson;
import clover.com.google.gson.GsonBuilder;
import clover.org.apache.velocity.VelocityContext;
import clover.retrotranslator.edu.emory.mathcs.backport.java.util.concurrent.Callable;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Integer;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._String;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.HasMetrics;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.reporters.html.HtmlRenderingSupport;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderTreeMapAction
implements Callable {
    private final ProjectInfo project;
    private final File outdir;
    private final VelocityContext mContext;
    private final HtmlRenderingSupport renderSupport = new HtmlRenderingSupport();

    public RenderTreeMapAction(ProjectInfo project, File outdir, VelocityContext context) {
        this.project = project;
        this.outdir = outdir;
        this.mContext = context;
    }

    @Override
    public Object call() throws Exception {
        String jsonStr = this.renderTreeMapJson("treemap-json.js", "processTreeMapJson", true);
        String filename = "treemap.html";
        this.mContext.put("projectInfo", this.project);
        this.mContext.put("currentPageURL", "treemap.html");
        this.mContext.put("headerMetrics", this.project.getMetrics());
        this.mContext.put("headerMetricsRaw", this.project.getRawMetrics());
        this.mContext.put("siblingPresent", Boolean.TRUE);
        this.mContext.put("topLevel", Boolean.TRUE);
        HtmlReportUtil.mergeTemplateToFile(new File(this.outdir, "treemap.html"), this.mContext, "html_res/treemap.vm");
        return jsonStr;
    }

    public String renderTreeMapJson(String filename, String callback, boolean classLevel) throws Exception {
        String jsonStr = this.generateJson(classLevel);
        this.mContext.put("callback", callback);
        this.mContext.put("json", jsonStr);
        HtmlReportUtil.mergeTemplateToFile(new File(this.outdir, filename), this.mContext, "html_res/api-json.vm");
        return jsonStr;
    }

    String generateJson(boolean classLevel) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        List<? extends BasePackageInfo> pkgInfos = this.project.getPackages();
        ArrayList<Node> pkgNodes = new ArrayList<Node>(pkgInfos.size());
        Node projectNode = this.createNode(this.project.getDataIndex(), "", this.project, pkgNodes);
        for (PackageInfo packageInfo : pkgInfos) {
            List classes = packageInfo.getClasses(HasMetricsFilter.ACCEPT_ALL);
            ArrayList<Node> classesList = new ArrayList<Node>(classes.size());
            pkgNodes.add(this.createNode(packageInfo.getDataIndex(), packageInfo.getName(), packageInfo, classesList));
            Iterator iterator = classes.iterator();
            while (classLevel && iterator.hasNext()) {
                ClassInfo classInfo = (ClassInfo)iterator.next();
                String path = classInfo.getContainingFile() != null ? this.renderSupport.getSrcFileLink(true, classInfo).toString() : null;
                classesList.add(this.createNode(classInfo.getDataIndex(), classInfo.getName(), classInfo, Collections.EMPTY_LIST, path));
            }
        }
        String jsonStr = gson.toJson(projectNode);
        return jsonStr;
    }

    private Node createNode(int index, String nodeName, HasMetrics hasMetrics, List<Node> children) {
        return this.createNode(index, nodeName, hasMetrics, children, null);
    }

    private Node createNode(int index, String nodeName, HasMetrics hasMetrics, List<Node> children, String path) {
        BlockMetrics metrics = hasMetrics.getMetrics();
        String pcStr = this.renderSupport.getPercentStr(metrics.getPcCoveredElements());
        String title = _String.format("%s %s Elements, %s Coverage", new Object[]{nodeName, _Integer.valueOf(metrics.getNumElements()), pcStr});
        Data data = new Data(metrics.getNumElements(), metrics.getPcCoveredElements() * 100.0f, path, title);
        Node node = new Node(new StringBuffer().append(hasMetrics.getName()).append(index).toString(), nodeName, data, children);
        return node;
    }

    private static class Data {
        final float $area;
        final float $color;
        final String path;
        final String title;

        private Data(float area, float color, String path, String title) {
            this.$area = area;
            this.$color = color;
            this.path = path;
            this.title = title;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node {
        final String id;
        final String name;
        final Data data;
        final Collection<Node> children;

        private Node(String id, String name, Data data, Collection<Node> children) {
            this.id = id;
            this.name = name;
            this.data = data;
            this.children = children;
        }
    }
}

