/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.xml;

import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.Logger;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BasePackageInfo;
import com.cenqua.clover.registry.BlockMetrics;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.ClassInfo;
import com.cenqua.clover.registry.ClassMetrics;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FileMetrics;
import com.cenqua.clover.registry.LineInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.PackageMetrics;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.ProjectMetrics;
import com.cenqua.clover.registry.StatementInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.CloverReporter;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.Format;
import com.cenqua.clover.reporters.xml.XMLWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class XMLReporter
extends CloverReporter {
    private ContextSet contextSet;
    static /* synthetic */ Class class$com$cenqua$clover$reporters$xml$XMLReporter;

    public XMLReporter(CloverReportConfig config) throws CloverException {
        this(config.getCoverageDatabase(), config);
    }

    public XMLReporter(CloverDatabase database, CloverReportConfig config) {
        super(database, config);
        this.contextSet = database.getContextSet(this.reportConfig.getFormat().getFilter());
    }

    public int executeImpl() throws CloverException {
        try {
            if (!this.reportConfig.isAlwaysReport() && !this.database.hasCoverage()) {
                Logger.getInstance().warn("No coverage recordings found. No report will be generated.");
                return 1;
            }
            XMLWriter out = this.initWriter();
            Logger.getInstance().info("Writing report to '" + this.reportConfig.getOutFile() + "'");
            out.writeXMLDecl();
            HashMap<String, String> attribs = new HashMap<String, String>();
            attribs.put("clover", "3.0.2");
            attribs.put("generated", String.valueOf(System.currentTimeMillis()));
            out.writeElementStart("coverage", attribs);
            this.writeProject(out, "project", this.database.getAppOnlyModel());
            this.writeProject(out, "testproject", this.database.getTestOnlyModel());
            out.writeElementEnd("coverage");
            out.close();
            return 0;
        }
        catch (IOException e) {
            throw new CloverException("IO Exception: " + e.getMessage());
        }
    }

    protected long getPerms() {
        return 1L;
    }

    private XMLWriter initWriter() throws IOException {
        File outFile = this.reportConfig.getOutFile();
        if (outFile.getParent() != null && !outFile.getParentFile().exists()) {
            outFile.getParentFile().mkdirs();
        }
        BufferedOutputStream os = this.reportConfig.isCompress() ? new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(outFile))) : new BufferedOutputStream(new FileOutputStream(outFile));
        return new XMLWriter(os, "UTF-8");
    }

    private void writeProject(XMLWriter out, String enclosingTag, ProjectInfo proj) throws IOException {
        HashMap<String, String> attribs = new HashMap<String, String>();
        if (this.reportConfig.getTitle() != null) {
            attribs.put("name", this.reportConfig.getTitle());
        }
        long ts = this.database.getRecordingTimestamp();
        if (this.reportConfig.getEffectiveDate() != null) {
            ts = this.reportConfig.getEffectiveDate().getTime();
        }
        attribs.put("timestamp", String.valueOf(ts));
        out.writeElementStart(enclosingTag, attribs);
        this.writeMetrics(out, proj.getMetrics());
        List<? extends BasePackageInfo> packages = proj.getPackages();
        if (packages != null && packages.size() > 0) {
            boolean summaryReport = false;
            if (this.reportConfig instanceof Current) {
                summaryReport = ((Current)this.reportConfig).getSummary();
            }
            Iterator<? extends BasePackageInfo> it = packages.iterator();
            while (it.hasNext()) {
                PackageInfo pkg = (PackageInfo)it.next();
                attribs = new HashMap();
                attribs.put("name", pkg.getName());
                out.writeElementStart("package", attribs);
                this.writeMetrics(out, pkg.getMetrics());
                if (!summaryReport) {
                    this.writeFilesForPkg(out, pkg);
                }
                out.writeElementEnd("package");
            }
        }
        out.writeElementEnd(enclosingTag);
    }

    private void writeMetrics(XMLWriter out, BlockMetrics metrics) throws IOException {
        HashMap<String, String> attribs = new HashMap<String, String>();
        attribs.put("elements", String.valueOf(metrics.getNumElements()));
        attribs.put("statements", String.valueOf(metrics.getNumStatements()));
        attribs.put("conditionals", String.valueOf(metrics.getNumBranches()));
        attribs.put("coveredelements", String.valueOf(metrics.getNumCoveredElements()));
        attribs.put("coveredstatements", String.valueOf(metrics.getNumCoveredStatements()));
        attribs.put("coveredconditionals", String.valueOf(metrics.getNumCoveredBranches()));
        attribs.put("complexity", String.valueOf(metrics.getComplexity()));
        if (metrics instanceof ClassMetrics) {
            ClassMetrics cm = (ClassMetrics)metrics;
            attribs.put("methods", String.valueOf(cm.getNumMethods()));
            attribs.put("coveredmethods", String.valueOf(cm.getNumCoveredMethods()));
            if (metrics.getNumTestsRun() > 0 && !(metrics instanceof FileMetrics)) {
                attribs.put("testpasses", String.valueOf(metrics.getNumTestPasses()));
                attribs.put("testfailures", String.valueOf(metrics.getNumTestFailures()));
                attribs.put("testruns", String.valueOf(metrics.getNumTestsRun()));
                attribs.put("testduration", String.valueOf(metrics.getTestExecutionTime()));
            }
            if (metrics instanceof FileMetrics) {
                FileMetrics fm = (FileMetrics)metrics;
                attribs.put("classes", String.valueOf(fm.getNumClasses()));
                attribs.put("loc", String.valueOf(fm.getLineCount()));
                attribs.put("ncloc", String.valueOf(fm.getNcLineCount()));
                if (metrics instanceof PackageMetrics) {
                    PackageMetrics pm = (PackageMetrics)metrics;
                    attribs.put("files", String.valueOf(pm.getNumFiles()));
                    if (metrics instanceof ProjectMetrics) {
                        ProjectMetrics pjm = (ProjectMetrics)metrics;
                        attribs.put("packages", String.valueOf(pjm.getNumPackages()));
                    }
                }
            }
        }
        out.writeElement("metrics", attribs);
    }

    private void writeFilesForPkg(XMLWriter out, PackageInfo pkg) throws IOException {
        List files = pkg.getFiles();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            FileInfo file = (FileInfo)it.next();
            HashMap<String, String> attribs = new HashMap<String, String>();
            attribs.put("name", file.getName());
            attribs.put("path", file.getPhysicalFile().getAbsolutePath());
            out.writeElementStart("file", attribs);
            this.writeMetrics(out, file.getMetrics());
            this.writeClassesForFile(out, file.getClasses());
            if (this.reportConfig.getFormat().getSrcLevel()) {
                this.writeLineInfo(out, file);
            }
            out.writeElementEnd("file");
        }
    }

    private void writeClassesForFile(XMLWriter out, List classes) throws IOException {
        Iterator it = classes.iterator();
        while (it.hasNext()) {
            ClassInfo info = (ClassInfo)it.next();
            HashMap<String, String> attribs = new HashMap<String, String>();
            attribs.put("name", info.getName());
            out.writeElementStart("class", attribs);
            this.writeMetrics(out, info.getMetrics());
            out.writeElementEnd("class");
        }
    }

    private void writeLineInfo(XMLWriter out, FileInfo finfo) throws IOException {
        int linecount = finfo.getLineCount();
        LineInfo[] linfo = finfo.getLineInfo();
        for (int i = 1; i <= linecount; ++i) {
            BranchInfo[] branches;
            StatementInfo[] stmts;
            LineInfo info = linfo[i];
            if (linfo[i] == null) continue;
            MethodInfo[] starts = info.getMethodStarts();
            if (starts != null) {
                for (int m = 0; m < starts.length; ++m) {
                    MethodInfo method;
                    ClassInfo clazz;
                    TestCaseInfo tci;
                    if (starts[m].isFiltered(this.contextSet)) continue;
                    HashMap<String, String> attribs = new HashMap<String, String>();
                    attribs.put("num", String.valueOf(i));
                    attribs.put("type", "method");
                    attribs.put("count", String.valueOf(starts[m].getHitCount()));
                    attribs.put("complexity", String.valueOf(starts[m].getComplexity()));
                    attribs.put("signature", XMLWriter.escapeAttributeValue(starts[m].getName()));
                    if (starts[m].isTest() && (tci = (clazz = (method = starts[m]).getContainingClass()).getTestCase(clazz.getQualifiedName() + "." + method.getSimpleName())) != null && tci.isHasResult()) {
                        attribs.put("testsuccess", XMLWriter.escapeAttributeValue("" + tci.isSuccess()));
                        attribs.put("testduration", XMLWriter.escapeAttributeValue(String.valueOf(tci.getTime())));
                    }
                    out.writeElement("line", attribs);
                }
            }
            if ((stmts = info.getStatements()) != null) {
                for (int m = 0; m < stmts.length; ++m) {
                    if (stmts[m].isFiltered(this.contextSet)) continue;
                    HashMap<String, String> attribs = new HashMap<String, String>();
                    attribs.put("num", String.valueOf(i));
                    attribs.put("type", "stmt");
                    attribs.put("count", String.valueOf(stmts[m].getHitCount()));
                    out.writeElement("line", attribs);
                }
            }
            if ((branches = info.getBranches()) == null) continue;
            for (int m = 0; m < branches.length; ++m) {
                if (branches[m].isFiltered(this.contextSet)) continue;
                HashMap<String, String> attribs = new HashMap<String, String>();
                attribs.put("num", String.valueOf(i));
                attribs.put("type", "cond");
                attribs.put("truecount", String.valueOf(branches[m].getTrueHitCount()));
                attribs.put("falsecount", String.valueOf(branches[m].getFalseHitCount()));
                out.writeElement("line", attribs);
            }
        }
    }

    private static CloverReportConfig processArgs(String[] args) {
        Current cfg = new Current();
        cfg.setFormat(Format.DEFAULT_XML);
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-o") || args[i].equals("--outfile")) {
                    cfg.setOutFile(new File(args[++i]));
                    continue;
                }
                if (args[i].equals("-i") || args[i].equals("--initstring")) {
                    cfg.setInitString(args[++i]);
                    continue;
                }
                if (args[i].equals("-t") || args[i].equals("--title")) {
                    cfg.setTitle(args[++i]);
                    continue;
                }
                if (args[i].equals("-l") || args[i].equals("--lineinfo")) {
                    cfg.getFormat().setSrcLevel(true);
                    continue;
                }
                if (args[i].equals("-a") || args[i].equals("--alwaysreport")) {
                    cfg.setAlwaysReport(true);
                    continue;
                }
                if (args[i].equals("-f") || args[i].equals("--filter")) {
                    cfg.getFormat().setFilter(args[++i]);
                    continue;
                }
                if (args[i].equals("-tc") || args[i].equals("--threadcount")) {
                    ++i;
                    try {
                        int threadCount = Integer.parseInt(args[i]);
                        if (threadCount < 0) {
                            XMLReporter.usage("Invalid thread count. Should be zero or a positive integer.");
                            return null;
                        }
                        cfg.setNumThreads(threadCount);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        XMLReporter.usage("Invalid thread count. Should be an integer.");
                        return null;
                    }
                }
                if (args[i].equals("-s") || args[i].equals("--span")) {
                    ++i;
                    try {
                        cfg.setSpan(new Interval(args[i]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        XMLReporter.usage("Invalid interval format. Should be integer followed by unit (s, m, h, d, w).");
                        return null;
                    }
                }
                if (args[i].equals("-d") || args[i].equals("--debug")) {
                    Logger.setDebug(true);
                    continue;
                }
                if (args[i].equals("-v") || args[i].equals("--verbose")) {
                    Logger.setVerbose(true);
                    continue;
                }
                if (!args[i].equals("-if") && !args[i].equals("--includefailcoverage")) continue;
                cfg.setIncludeFailedTestCoverage(true);
            }
            if (!cfg.validate()) {
                XMLReporter.usage(cfg.getValidationFailureReason());
                cfg = null;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            XMLReporter.usage("Missing a parameter.");
            cfg = null;
        }
        return cfg;
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        StringBuffer stringBuffer = new StringBuffer().append("  USAGE: ");
        Class<?> clazz = class$com$cenqua$clover$reporters$xml$XMLReporter;
        if (clazz == null) {
            clazz = class$com$cenqua$clover$reporters$xml$XMLReporter = new XMLReporter[0].getClass().getComponentType();
        }
        System.err.println(stringBuffer.append(clazz.getName()).append(" [OPTIONS] PARAMS\n\n").append("  PARAMS:\n").append("    -i,  --initstring <string>\tclover initstring\n\n").append("    -o,  --outfile <dir>\tthe file to write XML output to.\n\n").append("  OPTIONS:\n").append("    -l,  --lineinfo  \t\tinclude source-level coverage info\n\n").append("    -t,  --title  <string>\treport title.\n\n").append("    -s,  --span <interval>\tSpecifies how far back in time to\n").append("\t\t\t\tinclude coverage recordings from since the last Clover build. In Interval\n").append("\t\t\t\tformat. \"60s\" = 60 seconds, \"1h\" = 1 hour, \"1d\" = 1 day etc.\n\n").append("    -d,  --debug \t\tswitch logging level to debug\n\n").append("    -v,  --verbose \t\tswitch logging level to verbose\n\n").append("    -a,  --alwaysreport\t\tgenerate report even if there is no coverage to report on\n\n").append("    -if, --includefailcoverage\tinclude coverage from failed tests. Default is false.\n\n").append("    -tc, --threadcount <int>\tnumber of additional threads to be allocated to report generation. Default is 0.\n\n").append("    -f,  --filter <string>\tcomma separated list of contexts to filter\n").toString());
        System.err.println();
    }

    public static void main(String[] args) {
        XMLReporter.loadLicense();
        XMLReporter.runReport(args);
    }

    public static int runReport(String[] args) {
        CloverReportConfig config = XMLReporter.processArgs(args);
        if (XMLReporter.canProceedWithReporting(config)) {
            try {
                return new XMLReporter(config).execute();
            }
            catch (CloverException e) {
                Logger.getInstance().error("An error occurred while generating the report: " + e.getMessage(), e);
            }
        }
        return 1;
    }
}

