/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.tasks;

import com.atlassian.clover.PrematureLibraryLoader;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.util.ClassPathUtil;
import com_cenqua_clover.CloverVersionInfo;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;

public class CloverEnvTask
extends Task {
    public static final String CLOVER_ADAPTER = "org.apache.tools.ant.taskdefs.CloverCompilerAdapter";
    static /* synthetic */ Class class$org$apache$tools$ant$Project;

    private static void logClassPathMessage() {
        System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\nError determining the correct path to clover.jar. \nEnsure there is not an older copy of clover.jar on Ant's classpath. \nNB: Clover2 no longer requires clover.jar to be placed in Ant's lib directory.\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
    }

    private static void logDebug(String message) {
        CloverEnvTask.logDebug(message, null);
    }

    private static void logDebug(String message, Throwable t) {
        if (CloverEnvTask.isDebug()) {
            System.out.println(message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    public void init() throws BuildException {
        PrematureLibraryLoader.doOnce();
        super.init();
    }

    public void execute() throws BuildException {
        this.logEnvironment();
        ProjectHelper helper = (ProjectHelper)this.getProject().getReference("ant.projectHelper");
        try {
            Class<?> clazz = class$org$apache$tools$ant$Project;
            if (clazz == null) {
                clazz = class$org$apache$tools$ant$Project = new Project[0].getClass().getComponentType();
            }
            URLClassLoader loader = ClassPathUtil.findSystemClassLoader(clazz);
            URL importURL = loader.getResource("clover.xml");
            this.log("Loading clover.xml: " + importURL);
            helper.parse(this.getProject(), (Object)importURL);
        }
        catch (BuildException ex) {
            throw ProjectHelper.addLocationToBuildException((BuildException)ex, (Location)this.getLocation());
        }
        catch (CloverException e) {
            this.log("Error importing clover.xml into project.");
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        catch (Throwable e) {
            this.log("An unexpected error occurred while trying to import the bundled clover build file.");
            throw new BuildException(e.getMessage(), e);
        }
    }

    private void logEnvironment() {
        if (CloverEnvTask.isDebug()) {
            Diagnostics.doReport((PrintStream)System.out);
            this.log("Clover loaded from: " + ClassPathUtil.getCloverJarPath());
            this.log(CloverVersionInfo.formatVersionInfo());
        }
    }

    private static boolean isDebug() {
        return System.getProperty("clover.debug") != null;
    }

    static {
        block7: {
            try {
                String cloverJarPath = ClassPathUtil.getCloverJarPath();
                if (cloverJarPath != null) {
                    try {
                        URLClassLoader loader;
                        Class<?> clazz = class$org$apache$tools$ant$Project;
                        if (clazz == null) {
                            clazz = class$org$apache$tools$ant$Project = new Project[0].getClass().getComponentType();
                        }
                        if (!ClassPathUtil.isClassOnClassPath(CLOVER_ADAPTER, loader = ClassPathUtil.findSystemClassLoader(clazz))) {
                            ClassPathUtil.extendClassPath(cloverJarPath, loader);
                            CloverEnvTask.logDebug("Added '" + cloverJarPath + "' to the System Classloader '" + loader + "'");
                            ClassPathUtil.assertOnClassPath(CLOVER_ADAPTER, loader);
                            break block7;
                        }
                        CloverEnvTask.logDebug(cloverJarPath + " is already on the System Classloader.");
                    }
                    catch (Throwable e) {
                        CloverEnvTask.logDebug("Error adding Clover '" + cloverJarPath + "' to the System Classloader: Cause " + e.getMessage(), e);
                    }
                    break block7;
                }
                CloverEnvTask.logDebug("Unable to determine the Clover jar path. Not extending System Classloader.");
            }
            catch (Throwable t) {
                CloverEnvTask.logClassPathMessage();
                CloverEnvTask.logDebug(t.getMessage(), t);
            }
        }
    }
}

