/*
 * Decompiled with CFR 0.152.
 */
package com_cenqua_clover;

import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Integer;
import clover.retrotranslator.net.sf.retrotranslator.runtime.java.lang._Long;
import com.cenqua.clover.Environment;
import com.cenqua.clover.ErrorInfo;
import com.cenqua.clover.FixedSizeCoverageRecorder;
import com.cenqua.clover.GrowableCoverageRecorder;
import com.cenqua.clover.Logger;
import com.cenqua.clover.NullRecorder;
import com.cenqua.clover.RecorderLogging;
import com.cenqua.clover.remote.DistributedClover;
import com.cenqua.clover.remote.RpcMessage;
import com_cenqua_clover.CoverageRecorder;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public final class Clover {
    public static final int NO_SLICE = -1;
    public static final String SECURITY_EXCEPTION_MSG = "[CLOVER] FATAL ERROR: Clover could not be initialised because it has insufficient security privileges. Please consult the Clover documentation on the security policy file changes required.";
    private static int currentSlice = -1;
    private static long currentSliceStart = 0L;
    private static String currentType;
    private static int typeID;
    private static int testRunID;
    private static Map<String, Integer> typeIDs;
    private static final HashMap<String, CoverageRecorder> RECORDERS;
    private static DistributedClover DISTRIBUTED_CLOVER;
    static /* synthetic */ Class class$com_cenqua_clover$Clover;

    private Clover() {
    }

    public static void globalFlush() {
        Clover.allRecordersFlush();
    }

    public static int getCurrentSlice() {
        return currentSlice;
    }

    public static String getCurrentType() {
        return currentType;
    }

    public static long getCurrentSliceStart() {
        return currentSliceStart;
    }

    public static int getCurrentTestRunID() {
        return testRunID;
    }

    public static CoverageRecorder getRecorder(String initString, long dbVersion, long cfgbits, int maxNumElements) {
        return Clover.getRecorder(initString.toCharArray(), "OFF".toCharArray(), dbVersion, cfgbits, maxNumElements);
    }

    public static CoverageRecorder getRecorder(String initChars, String serverChars, long dbVersion, long cfgbits, int maxNumElements) {
        return Clover.getRecorder(initChars.toCharArray(), serverChars == null ? "OFF".toCharArray() : serverChars.toCharArray(), dbVersion, cfgbits, maxNumElements);
    }

    public static CoverageRecorder getRecorder(final char[] initChars, final char[] serverChars, final long dbVersion, final long cfgbits, final int maxNumElements) {
        if (Logger.isDebug()) {
            Logger.getInstance().debug("Clover.getRecorder(" + String.valueOf(initChars) + ", " + (serverChars == null ? "null" : String.valueOf(serverChars)) + ", " + dbVersion + ", " + cfgbits + ", " + maxNumElements + ") " + "called from (first 10 stack elements):\n" + Clover.callerChain(10));
        }
        return AccessController.doPrivileged(new PrivilegedAction<CoverageRecorder>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CoverageRecorder run() {
                String initStr = new String(initChars);
                String recorderKey = new StringBuffer().append(initStr).append("_").append(dbVersion).append("_").append(cfgbits).toString();
                HashMap hashMap = RECORDERS;
                synchronized (hashMap) {
                    CoverageRecorder recorder = (CoverageRecorder)RECORDERS.get(recorderKey);
                    if (recorder != null) {
                        Logger.getInstance().debug(new StringBuffer().append("[found existing recorder for ").append(recorderKey).append("]").toString());
                        recorder = recorder.withCapacityFor(maxNumElements);
                    } else {
                        Logger.getInstance().debug(new StringBuffer().append("[creating new recorder for ").append(recorderKey).append("]").toString());
                        recorder = Clover.createRecorder(initStr, dbVersion, cfgbits, maxNumElements);
                        recorder.startRun();
                    }
                    RECORDERS.put(recorderKey, recorder);
                    if (DISTRIBUTED_CLOVER == null) {
                        DISTRIBUTED_CLOVER = new DistributedClover();
                        DISTRIBUTED_CLOVER.initClientServer(serverChars);
                    }
                    return recorder;
                }
            }

            @Override
            public /* synthetic */ Object run() {
                return this.run();
            }
        });
    }

    private static String callerChain(int maxDepth) {
        LinkedList<StackTraceElement> elements = new LinkedList<StackTraceElement>(Arrays.asList(new Exception().getStackTrace()));
        elements.removeFirst();
        elements.removeFirst();
        StringBuffer buf = new StringBuffer();
        Iterator iterator = elements.iterator();
        int depth = 0;
        while (iterator.hasNext() && depth < maxDepth) {
            StackTraceElement element = (StackTraceElement)iterator.next();
            if (element.getClassName().startsWith("sun.reflect") || element.getClassName().startsWith("java.lang.reflect")) {
                iterator.remove();
                continue;
            }
            buf.append(element);
            buf.append("\n");
            ++depth;
        }
        return buf.toString();
    }

    public static int getTypeID(String runtimeType) {
        int result;
        Integer val = typeIDs.get(runtimeType);
        if (val == null) {
            result = typeID++;
            typeIDs.put(runtimeType, new Integer(result));
        } else {
            result = val;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetRecorders() {
        HashMap<String, CoverageRecorder> hashMap = RECORDERS;
        synchronized (hashMap) {
            RECORDERS.clear();
        }
    }

    public static boolean hasRecorded() {
        return RECORDERS.size() > 0;
    }

    public static void allRecordersFlush() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                HashMap hashMap = RECORDERS;
                synchronized (hashMap) {
                    for (CoverageRecorder recorder : RECORDERS.values()) {
                        recorder.forceFlush();
                    }
                }
                return null;
            }

            @Override
            public /* synthetic */ Object run() {
                return this.run();
            }
        });
    }

    public static void allRecordersSliceStart(final String type, final int slice, final long startTime) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                HashMap hashMap = RECORDERS;
                synchronized (hashMap) {
                    currentSlice = slice;
                    currentSliceStart = startTime > 0L ? startTime : System.currentTimeMillis();
                    currentType = type;
                    for (CoverageRecorder recorder : RECORDERS.values()) {
                        recorder.sliceStart(type, currentSliceStart, slice, testRunID);
                    }
                    if (DISTRIBUTED_CLOVER.hasService()) {
                        DISTRIBUTED_CLOVER.remoteFlush(new RpcMessage(_Integer.valueOf(1), new Object[]{type, _Integer.valueOf(slice), _Long.valueOf(currentSliceStart)}));
                    }
                }
                return null;
            }

            @Override
            public /* synthetic */ Object run() {
                return this.run();
            }
        });
    }

    public static void allRecordersSliceEnd(final String type, final String method, final int slice, final int p, final ErrorInfo ei) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                HashMap hashMap = RECORDERS;
                synchronized (hashMap) {
                    currentSlice = -1;
                    long ts = System.currentTimeMillis();
                    for (CoverageRecorder recorder : RECORDERS.values()) {
                        recorder.sliceEnd(type, method, ts, slice, testRunID, p, ei);
                    }
                    if (DISTRIBUTED_CLOVER.hasService()) {
                        DISTRIBUTED_CLOVER.remoteFlush(new RpcMessage(_Integer.valueOf(2), new Object[]{type, method, _Integer.valueOf(slice), _Integer.valueOf(p), ei}));
                    }
                    testRunID++;
                }
                return null;
            }

            @Override
            public /* synthetic */ Object run() {
                return this.run();
            }
        });
    }

    public static CoverageRecorder createRecorder(String dbName, long dbVersion, long cfgbits, int maxNumElements) {
        block5: {
            File dbFile = Clover.resolveRegistryFile(dbName);
            try {
                if (dbFile.exists() && !dbFile.isDirectory() && dbFile.canRead()) {
                    return FixedSizeCoverageRecorder.createFor(dbFile, dbVersion, maxNumElements, cfgbits);
                }
                if (Boolean.getBoolean("clover.offrails.coverage")) {
                    return GrowableCoverageRecorder.createFor(dbFile.getAbsolutePath(), dbVersion, cfgbits, maxNumElements);
                }
                Clover.logRecorderCreationFailure(dbFile, null);
            }
            catch (SecurityException e) {
                Logger.getInstance().warn(SECURITY_EXCEPTION_MSG);
                Clover.logRecorderCreationFailure(dbFile, e);
            }
            catch (Throwable e) {
                Clover.logRecorderCreationFailure(dbFile, e);
                if (!(e instanceof Error)) break block5;
                throw (Error)e;
            }
        }
        return NullRecorder.INSTANCE;
    }

    private static void logRecorderCreationFailure(File dbFile, Throwable t) {
        Logger.getInstance().error("CLOVER: Unable to load the coverage database at \"" + dbFile.getAbsolutePath() + "\"");
        Logger.getInstance().error("CLOVER: No coverage data will be gathered.");
        if (t != null) {
            Logger.getInstance().error("CLOVER: " + t.getClass().getName());
            if (t.getMessage() != null) {
                Logger.getInstance().error("CLOVER: " + t.getMessage(), t);
            }
        }
    }

    static File resolveRegistryFile(String dbName) {
        try {
            String initStringProp = Environment.substituteSysPropRefs(System.getProperty("clover.initstring"));
            if (initStringProp != null && initStringProp.length() > 0) {
                Logger.getInstance().verbose("overriding initstring: " + initStringProp);
                return new File(initStringProp);
            }
            String initStringBaseProp = Environment.substituteSysPropRefs(System.getProperty("clover.initstring.basedir"));
            if (initStringBaseProp != null && initStringBaseProp.length() > 0) {
                Logger.getInstance().verbose("overriding initstring basedir: " + initStringBaseProp);
                File dbFile = new File(dbName);
                return new File(initStringBaseProp, dbFile.getName());
            }
            String initStringPrefixProp = Environment.substituteSysPropRefs(System.getProperty("clover.initstring.prefix"));
            if (initStringPrefixProp != null && initStringPrefixProp.length() > 0) {
                Logger.getInstance().verbose("prepending initstring prefix: " + initStringPrefixProp);
                String newInit = initStringPrefixProp + dbName;
                if ((initStringPrefixProp.endsWith("/") || initStringPrefixProp.endsWith("\\")) && (dbName.startsWith("\\") || dbName.startsWith("/"))) {
                    newInit = initStringPrefixProp + dbName.substring(1);
                }
                return new File(newInit);
            }
        }
        catch (SecurityException e) {
            Logger.getInstance().verbose("Failed to retrieve Clover properties clover.initstring*", e);
        }
        return new File(dbName);
    }

    public static String getRecordingName(int hash, String dbname, long ts) {
        return dbname + Integer.toString(hash, 36) + "_" + Long.toString(ts, 36);
    }

    public static String getSliceRecordingName(int typeid, int methodID, int runID, int hash, String dbname, long ts) {
        long globalSliceID = (long)typeid << 32 | (long)methodID;
        return dbname + Long.toString(globalSliceID, 36) + "_" + Integer.toString(runID, 36) + "_" + Integer.toString(hash, 36) + "_" + Long.toString(ts, 36) + ".s";
    }

    public static void l(String m) {
        Logger.getInstance().error(m);
    }

    public static void l(String m, Throwable t) {
        Logger.getInstance().error(m, t);
    }

    public static ErrorInfo getErrorInfo(Throwable t) {
        return t == null ? null : new ErrorInfo(t.getMessage(), Clover.stackTraceFor(t));
    }

    public static CoverageRecorder getNullRecorder() {
        return NullRecorder.INSTANCE;
    }

    public static String stackTraceFor(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    static {
        long l = System.currentTimeMillis();
        Class<?> clazz = class$com_cenqua_clover$Clover;
        if (clazz == null) {
            clazz = class$com_cenqua_clover$Clover = new Clover[0].getClass().getComponentType();
        }
        typeID = Math.abs((int)(l + (long)clazz.hashCode()));
        testRunID = 0;
        RecorderLogging.init();
        typeIDs = Collections.synchronizedMap(new HashMap());
        RECORDERS = new HashMap();
        DISTRIBUTED_CLOVER = null;
    }
}

