/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;

class AllVerticesIterator
implements Iterator<ExecutionVertex> {
    private final Iterator<ExecutionJobVertex> jobVertices;
    private ExecutionVertex[] currVertices;
    private int currPos;

    public AllVerticesIterator(Iterator<ExecutionJobVertex> jobVertices) {
        this.jobVertices = jobVertices;
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.currVertices != null) {
                if (this.currPos < this.currVertices.length) {
                    return true;
                }
                this.currVertices = null;
                continue;
            }
            if (!this.jobVertices.hasNext()) break;
            this.currVertices = this.jobVertices.next().getTaskVertices();
            this.currPos = 0;
        }
        return false;
    }

    @Override
    public ExecutionVertex next() {
        if (this.hasNext()) {
            return this.currVertices[this.currPos++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

