/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;

public class IntermediateResult {
    private final IntermediateDataSetID id;
    private final ExecutionJobVertex producer;
    private final IntermediateResultPartition[] partitions;
    private final int numParallelProducers;
    private int partitionsAssigned;
    private int numConsumers;
    private final int connectionIndex;

    public IntermediateResult(IntermediateDataSetID id, ExecutionJobVertex producer, int numParallelProducers) {
        this.id = id;
        this.producer = producer;
        this.partitions = new IntermediateResultPartition[numParallelProducers];
        this.numParallelProducers = numParallelProducers;
        this.connectionIndex = (int)(Math.random() * 2.147483647E9);
    }

    public void setPartition(int partitionNumber, IntermediateResultPartition partition) {
        if (partition == null || partitionNumber < 0 || partitionNumber >= this.numParallelProducers) {
            throw new IllegalArgumentException();
        }
        if (this.partitions[partitionNumber] != null) {
            throw new IllegalStateException("Partition #" + partitionNumber + " has already been assigned.");
        }
        this.partitions[partitionNumber] = partition;
        ++this.partitionsAssigned;
    }

    public IntermediateDataSetID getId() {
        return this.id;
    }

    public ExecutionJobVertex getProducer() {
        return this.producer;
    }

    public IntermediateResultPartition[] getPartitions() {
        return this.partitions;
    }

    public int getNumberOfAssignedPartitions() {
        return this.partitionsAssigned;
    }

    public int registerConsumer() {
        int index = this.numConsumers++;
        for (IntermediateResultPartition p : this.partitions) {
            if (p.addConsumerGroup() == index) continue;
            throw new RuntimeException("Inconsistent consumer mapping between intermediate result partitions.");
        }
        return index;
    }

    public int getConnectionIndex() {
        return this.connectionIndex;
    }
}

