/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;

public class IntermediateResultPartition {
    private final IntermediateResult totalResut;
    private final ExecutionVertex producer;
    private final int partition;
    private List<List<ExecutionEdge>> consumers;

    public IntermediateResultPartition(IntermediateResult totalResut, ExecutionVertex producer, int partition) {
        this.totalResut = totalResut;
        this.producer = producer;
        this.partition = partition;
        this.consumers = new ArrayList<List<ExecutionEdge>>(0);
    }

    public ExecutionVertex getProducer() {
        return this.producer;
    }

    public int getPartition() {
        return this.partition;
    }

    public IntermediateResult getIntermediateResult() {
        return this.totalResut;
    }

    public List<List<ExecutionEdge>> getConsumers() {
        return this.consumers;
    }

    int addConsumerGroup() {
        int pos = this.consumers.size();
        if (pos != 0) {
            throw new RuntimeException("Currenty, each intermediate result can only have one consumer.");
        }
        this.consumers.add(new ArrayList());
        return pos;
    }

    void addConsumer(ExecutionEdge edge, int consumerNumber) {
        this.consumers.get(consumerNumber).add(edge);
    }
}

