/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.flink.runtime.event.job.AbstractEvent;
import org.apache.flink.runtime.event.job.ExecutionStateChangeEvent;
import org.apache.flink.runtime.event.job.JobEvent;
import org.apache.flink.runtime.event.job.ManagementEvent;
import org.apache.flink.runtime.event.job.RecentJobEvent;
import org.apache.flink.runtime.event.job.VertexEvent;
import org.apache.flink.runtime.execution.ExecutionListener;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.archive.ArchiveListener;
import org.apache.flink.runtime.profiling.ProfilingListener;
import org.apache.flink.runtime.profiling.types.ProfilingEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventCollector
extends TimerTask
implements ProfilingListener {
    private static final Logger LOG = LoggerFactory.getLogger(EventCollector.class);
    private final long timerTaskInterval;
    private final Map<JobID, List<AbstractEvent>> collectedEvents = new HashMap<JobID, List<AbstractEvent>>();
    private final Map<JobID, RecentJobEvent> recentJobs = new HashMap<JobID, RecentJobEvent>();
    private final Map<JobID, ExecutionGraph> recentManagementGraphs = new HashMap<JobID, ExecutionGraph>();
    private final Timer timer;
    private List<ArchiveListener> archivists = new ArrayList<ArchiveListener>();

    public EventCollector(int clientQueryInterval) {
        this.timerTaskInterval = (long)clientQueryInterval * 1000L * 2L;
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this, this.timerTaskInterval, this.timerTaskInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getEventsForJob(JobID jobID, List<AbstractEvent> eventList, boolean includeManagementEvents) {
        Map<JobID, List<AbstractEvent>> map = this.collectedEvents;
        synchronized (map) {
            List<AbstractEvent> eventsForJob = this.collectedEvents.get(jobID);
            if (eventsForJob != null) {
                for (AbstractEvent event : eventsForJob) {
                    boolean isManagementEvent = event instanceof ManagementEvent;
                    if (isManagementEvent && !includeManagementEvents) continue;
                    eventList.add(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRecentJobs(List<RecentJobEvent> eventList) {
        Map<JobID, RecentJobEvent> map = this.recentJobs;
        synchronized (map) {
            eventList.addAll(this.recentJobs.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map<JobID, Object> map = this.collectedEvents;
        synchronized (map) {
            this.collectedEvents.clear();
        }
        map = this.recentJobs;
        synchronized (map) {
            this.recentJobs.clear();
        }
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(JobID jobID, AbstractEvent event) {
        Map<JobID, List<AbstractEvent>> map = this.collectedEvents;
        synchronized (map) {
            List<AbstractEvent> eventList = this.collectedEvents.get(jobID);
            if (eventList == null) {
                eventList = new ArrayList<AbstractEvent>();
                this.collectedEvents.put(jobID, eventList);
            }
            eventList.add(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecentJobEvent(JobID jobID, String jobName, boolean isProfilingEnabled, long submissionTimestamp, JobStatus jobStatus) {
        long currentTime = System.currentTimeMillis();
        RecentJobEvent recentJobEvent = new RecentJobEvent(jobID, jobName, jobStatus, isProfilingEnabled, submissionTimestamp, currentTime);
        Map<JobID, RecentJobEvent> map = this.recentJobs;
        synchronized (map) {
            this.recentJobs.put(jobID, recentJobEvent);
        }
    }

    public void registerJob(ExecutionGraph executionGraph, boolean profilingAvailable, long submissionTimestamp) {
        executionGraph.registerExecutionListener(new ExecutionListenerWrapper(this, executionGraph));
        executionGraph.registerJobStatusListener(new JobStatusListenerWrapper(this, executionGraph.getJobName(), profilingAvailable, submissionTimestamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Iterator<Object> it;
        long currentTime = System.currentTimeMillis();
        Map<JobID, Object> map = this.collectedEvents;
        synchronized (map) {
            it = this.collectedEvents.keySet().iterator();
            while (it.hasNext()) {
                JobID jobID = it.next();
                List<AbstractEvent> eventList = this.collectedEvents.get(jobID);
                if (eventList == null) continue;
                Iterator<AbstractEvent> it2 = eventList.iterator();
                while (it2.hasNext()) {
                    AbstractEvent event = it2.next();
                    if (event.getTimestamp() + this.timerTaskInterval >= currentTime) continue;
                    this.archiveEvent(jobID, event);
                    it2.remove();
                }
                if (!eventList.isEmpty()) continue;
                it.remove();
            }
        }
        map = this.recentJobs;
        synchronized (map) {
            it = this.recentJobs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                JobStatus jobStatus = ((RecentJobEvent)entry.getValue()).getJobStatus();
                if (jobStatus != JobStatus.FINISHED && jobStatus != JobStatus.CANCELED && jobStatus != JobStatus.FAILED || ((RecentJobEvent)entry.getValue()).getTimestamp() + this.timerTaskInterval >= currentTime) continue;
                this.archiveJobevent((JobID)entry.getKey(), (RecentJobEvent)entry.getValue());
                it.remove();
                Map<JobID, ExecutionGraph> map2 = this.recentManagementGraphs;
                synchronized (map2) {
                    this.archiveManagementGraph((JobID)entry.getKey(), this.recentManagementGraphs.get(entry.getKey()));
                    this.recentManagementGraphs.remove(entry.getValue());
                }
            }
        }
    }

    @Override
    public void processProfilingEvents(ProfilingEvent profilingEvent) {
        this.addEvent(profilingEvent.getJobID(), profilingEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addExecutionGraph(JobID jobID, ExecutionGraph executionGraph) {
        Map<JobID, ExecutionGraph> map = this.recentManagementGraphs;
        synchronized (map) {
            this.recentManagementGraphs.put(jobID, executionGraph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionGraph getManagementGraph(JobID jobID) {
        Map<JobID, ExecutionGraph> map = this.recentManagementGraphs;
        synchronized (map) {
            return this.recentManagementGraphs.get(jobID);
        }
    }

    public void registerArchivist(ArchiveListener al) {
        this.archivists.add(al);
    }

    private void archiveEvent(JobID jobId, AbstractEvent event) {
        for (ArchiveListener al : this.archivists) {
            al.archiveEvent(jobId, event);
        }
    }

    private void archiveJobevent(JobID jobId, RecentJobEvent event) {
        for (ArchiveListener al : this.archivists) {
            al.archiveJobevent(jobId, event);
        }
    }

    private void archiveManagementGraph(JobID jobId, ExecutionGraph graph) {
        for (ArchiveListener al : this.archivists) {
            al.archiveExecutionGraph(jobId, graph);
        }
    }

    private static final class JobStatusListenerWrapper
    implements JobStatusListener {
        private final EventCollector eventCollector;
        private final String jobName;
        private final boolean isProfilingAvailable;
        private final long submissionTimestamp;

        public JobStatusListenerWrapper(EventCollector eventCollector, String jobName, boolean isProfilingAvailable, long submissionTimestamp) {
            this.eventCollector = eventCollector;
            this.jobName = jobName;
            this.isProfilingAvailable = isProfilingAvailable;
            this.submissionTimestamp = submissionTimestamp;
        }

        @Override
        public void jobStatusHasChanged(ExecutionGraph executionGraph, JobStatus newJobStatus, String optionalMessage) {
            JobID jobID = executionGraph.getJobID();
            if (newJobStatus == JobStatus.RUNNING) {
                this.eventCollector.addExecutionGraph(jobID, executionGraph);
            }
            this.eventCollector.updateRecentJobEvent(jobID, this.jobName, this.isProfilingAvailable, this.submissionTimestamp, newJobStatus);
            this.eventCollector.addEvent(jobID, new JobEvent(System.currentTimeMillis(), newJobStatus, optionalMessage));
        }
    }

    private static final class ExecutionListenerWrapper
    implements ExecutionListener {
        private final EventCollector eventCollector;
        private final ExecutionGraph graph;

        public ExecutionListenerWrapper(EventCollector eventCollector, ExecutionGraph graph) {
            this.eventCollector = eventCollector;
            this.graph = graph;
        }

        @Override
        public void executionStateChanged(JobID jobID, JobVertexID vertexId, int subtask, ExecutionAttemptID executionId, ExecutionState newExecutionState, String optionalMessage) {
            long timestamp = System.currentTimeMillis();
            ExecutionJobVertex vertex = this.graph.getJobVertex(vertexId);
            String taskName = vertex == null ? "(null)" : vertex.getJobVertex().getName();
            int totalNumberOfSubtasks = vertex == null ? -1 : vertex.getParallelism();
            VertexEvent vertexEvent = new VertexEvent(timestamp, vertexId, taskName, totalNumberOfSubtasks, subtask, executionId, newExecutionState, optionalMessage);
            this.eventCollector.addEvent(jobID, vertexEvent);
            ExecutionStateChangeEvent executionStateChangeEvent = new ExecutionStateChangeEvent(timestamp, vertexId, subtask, executionId, newExecutionState);
            this.eventCollector.addEvent(jobID, executionStateChangeEvent);
            LOG.info(vertexEvent.toString());
        }
    }
}

