/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import org.apache.flink.runtime.instance.AllocatedSlot;
import org.apache.flink.runtime.jobmanager.scheduler.SlotAllocationFutureAction;

public class SlotAllocationFuture {
    private final Object monitor = new Object();
    private volatile AllocatedSlot slot;
    private volatile SlotAllocationFutureAction action;

    public SlotAllocationFuture() {
    }

    public SlotAllocationFuture(AllocatedSlot slot) {
        this.slot = slot;
    }

    public AllocatedSlot waitTillAllocated() throws InterruptedException {
        return this.waitTillAllocated(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllocatedSlot waitTillAllocated(long timeout) throws InterruptedException {
        Object object = this.monitor;
        synchronized (object) {
            while (this.slot == null) {
                this.monitor.wait(timeout);
            }
            return this.slot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFutureAction(SlotAllocationFutureAction action) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.action != null) {
                throw new IllegalStateException("Future already has an action registered.");
            }
            this.action = action;
            if (this.slot != null) {
                action.slotAllocated(this.slot);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSlot(AllocatedSlot slot) {
        if (slot == null) {
            throw new NullPointerException();
        }
        Object object = this.monitor;
        synchronized (object) {
            if (this.slot != null) {
                throw new IllegalStateException("The future has already been assigned a slot.");
            }
            this.slot = slot;
            this.monitor.notifyAll();
            if (this.action != null) {
                this.action.slotAllocated(slot);
            }
        }
    }

    public String toString() {
        return this.slot == null ? "PENDING" : "DONE";
    }
}

