/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.jobmanager.JobManager;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupInfoServlet
extends HttpServlet {
    private static final long serialVersionUID = 3704963598772630435L;
    private static final Logger LOG = LoggerFactory.getLogger(SetupInfoServlet.class);
    private Configuration globalC = GlobalConfiguration.getConfiguration();
    private JobManager jobmanager;
    private static final Comparator<Instance> INSTANCE_SORTER = new Comparator<Instance>(){

        @Override
        public int compare(Instance o1, Instance o2) {
            return o1.getInstanceConnectionInfo().compareTo(o2.getInstanceConnectionInfo());
        }
    };

    public SetupInfoServlet(JobManager jm) {
        this.jobmanager = jm;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(200);
        resp.setContentType("application/json");
        if ("globalC".equals(req.getParameter("get"))) {
            this.writeGlobalConfiguration(resp);
        } else if ("taskmanagers".equals(req.getParameter("get"))) {
            this.writeTaskmanagers(resp);
        }
    }

    private void writeGlobalConfiguration(HttpServletResponse resp) throws IOException {
        Set keys = this.globalC.keySet();
        ArrayList list = new ArrayList(keys);
        Collections.sort(list);
        JSONObject obj = new JSONObject();
        for (String k : list) {
            try {
                obj.put(k, (Object)this.globalC.getString(k, ""));
            }
            catch (JSONException e) {
                LOG.warn("Json object creation failed", (Throwable)e);
            }
        }
        PrintWriter w = resp.getWriter();
        w.write(obj.toString());
    }

    private void writeTaskmanagers(HttpServletResponse resp) throws IOException {
        ArrayList<Instance> instances = new ArrayList<Instance>(this.jobmanager.getInstanceManager().getAllRegisteredInstances().values());
        Collections.sort(instances, INSTANCE_SORTER);
        JSONObject obj = new JSONObject();
        JSONArray array = new JSONArray();
        for (Instance instance : instances) {
            JSONObject objInner = new JSONObject();
            long time = new Date().getTime() - instance.getLastHeartBeat();
            try {
                objInner.put("inetAdress", (Object)instance.getInstanceConnectionInfo().getInetAdress());
                objInner.put("ipcPort", instance.getInstanceConnectionInfo().ipcPort());
                objInner.put("dataPort", instance.getInstanceConnectionInfo().dataPort());
                objInner.put("timeSinceLastHeartbeat", time / 1000L);
                objInner.put("slotsNumber", instance.getTotalNumberOfSlots());
                objInner.put("freeSlots", instance.getNumberOfAvailableSlots());
                objInner.put("cpuCores", instance.getResources().getNumberOfCPUCores());
                objInner.put("physicalMemory", instance.getResources().getSizeOfPhysicalMemory() >>> 20);
                objInner.put("freeMemory", instance.getResources().getSizeOfJvmHeap() >>> 20);
                objInner.put("managedMemory", instance.getResources().getSizeOfManagedMemory() >>> 20);
                array.put((Object)objInner);
            }
            catch (JSONException e) {
                LOG.warn("Json object creation failed", (Throwable)e);
            }
        }
        try {
            obj.put("taskmanagers", (Object)array);
        }
        catch (JSONException e) {
            LOG.warn("Json object creation failed", (Throwable)e);
        }
        PrintWriter w = resp.getWriter();
        w.write(obj.toString());
    }
}

