/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators;

import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.operators.util.JoinHashMap;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeComparatorFactory;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypePairComparatorFactory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.iterative.concurrent.SolutionSetBroker;
import org.apache.flink.runtime.iterative.task.AbstractIterativePactTask;
import org.apache.flink.runtime.operators.PactTaskContext;
import org.apache.flink.runtime.operators.ResettablePactDriver;
import org.apache.flink.runtime.operators.hash.AbstractHashTableProber;
import org.apache.flink.runtime.operators.hash.CompactingHashTable;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.runtime.util.EmptyIterator;
import org.apache.flink.runtime.util.KeyGroupedIterator;
import org.apache.flink.runtime.util.SingleElementIterator;
import org.apache.flink.util.Collector;

public class CoGroupWithSolutionSetSecondDriver<IT1, IT2, OT>
implements ResettablePactDriver<CoGroupFunction<IT1, IT2, OT>, OT> {
    private PactTaskContext<CoGroupFunction<IT1, IT2, OT>, OT> taskContext;
    private CompactingHashTable<IT2> hashTable;
    private JoinHashMap<IT2> objectMap;
    private TypeSerializer<IT1> probeSideSerializer;
    private TypeComparator<IT1> probeSideComparator;
    private TypePairComparator<IT1, IT2> pairComparator;
    private IT2 solutionSideRecord;
    protected volatile boolean running;

    @Override
    public void setup(PactTaskContext<CoGroupFunction<IT1, IT2, OT>, OT> context) {
        this.taskContext = context;
        this.running = true;
    }

    @Override
    public int getNumberOfInputs() {
        return 1;
    }

    @Override
    public Class<CoGroupFunction<IT1, IT2, OT>> getStubType() {
        Class<CoGroupFunction> clazz = CoGroupFunction.class;
        return clazz;
    }

    @Override
    public int getNumberOfDriverComparators() {
        return 1;
    }

    @Override
    public boolean isInputResettable(int inputNum) {
        if (inputNum < 0 || inputNum > 1) {
            throw new IndexOutOfBoundsException();
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initialize() throws Exception {
        TypeComparator solutionSetComparator;
        TypeSerializer solutionSetSerializer;
        if (!(this.taskContext instanceof AbstractIterativePactTask)) throw new Exception("The task context of this driver is no iterative task context.");
        AbstractIterativePactTask iterativeTaskContext = (AbstractIterativePactTask)this.taskContext;
        String identifier = iterativeTaskContext.brokerKey();
        Object table = SolutionSetBroker.instance().get(identifier);
        if (table instanceof CompactingHashTable) {
            this.hashTable = (CompactingHashTable)table;
            solutionSetSerializer = this.hashTable.getBuildSideSerializer();
            solutionSetComparator = this.hashTable.getBuildSideComparator().duplicate();
        } else {
            if (!(table instanceof JoinHashMap)) throw new RuntimeException("Unrecognized solution set index: " + table);
            this.objectMap = (JoinHashMap)table;
            solutionSetSerializer = this.objectMap.getBuildSerializer();
            solutionSetComparator = this.objectMap.getBuildComparator().duplicate();
        }
        TaskConfig config = this.taskContext.getTaskConfig();
        ClassLoader classLoader = this.taskContext.getUserCodeClassLoader();
        TypeComparatorFactory probeSideComparatorFactory = config.getDriverComparator(0, classLoader);
        this.probeSideSerializer = this.taskContext.getInputSerializer(0).getSerializer();
        this.probeSideComparator = probeSideComparatorFactory.createComparator();
        this.solutionSideRecord = solutionSetSerializer.createInstance();
        TypePairComparatorFactory factory = this.taskContext.getTaskConfig().getPairComparatorFactory(this.taskContext.getUserCodeClassLoader());
        this.pairComparator = factory.createComparator12(this.probeSideComparator, solutionSetComparator);
    }

    @Override
    public void prepare() {
    }

    @Override
    public void run() throws Exception {
        CoGroupFunction<IT1, IT2, OT> coGroupStub = this.taskContext.getStub();
        Collector<OT> collector = this.taskContext.getOutputCollector();
        KeyGroupedIterator probeSideInput = new KeyGroupedIterator(this.taskContext.getInput(0), this.probeSideSerializer, this.probeSideComparator);
        SingleElementIterator<Object> siIter = new SingleElementIterator<Object>();
        EmptyIterator emptySolutionSide = EmptyIterator.get();
        if (this.hashTable != null) {
            CompactingHashTable<IT2> join = this.hashTable;
            AbstractHashTableProber prober = join.getProber((TypeComparator)this.probeSideComparator, (TypePairComparator)this.pairComparator);
            IT2 buildSideRecord = this.solutionSideRecord;
            while (this.running && probeSideInput.nextKey()) {
                Object current = probeSideInput.getCurrent();
                buildSideRecord = ((CompactingHashTable.HashTableProber)prober).getMatchFor(current, buildSideRecord);
                if (buildSideRecord != null) {
                    siIter.set(buildSideRecord);
                    coGroupStub.coGroup((Iterable)probeSideInput.getValues(), siIter, collector);
                    continue;
                }
                coGroupStub.coGroup((Iterable)probeSideInput.getValues(), emptySolutionSide, collector);
            }
        } else {
            JoinHashMap<IT2> join = this.objectMap;
            JoinHashMap.Prober prober = join.createProber(this.probeSideComparator, this.pairComparator);
            TypeSerializer serializer = join.getBuildSerializer();
            while (this.running && probeSideInput.nextKey()) {
                Object current = probeSideInput.getCurrent();
                Object buildSideRecord = prober.lookupMatch(current);
                if (buildSideRecord != null) {
                    siIter.set(serializer.copy(buildSideRecord));
                    coGroupStub.coGroup((Iterable)probeSideInput.getValues(), siIter, collector);
                    continue;
                }
                coGroupStub.coGroup((Iterable)probeSideInput.getValues(), emptySolutionSide, collector);
            }
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void teardown() {
    }

    @Override
    public void cancel() {
        this.running = false;
    }
}

