/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.profiling.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.instance.AllocatedSlot;
import org.apache.flink.runtime.instance.Instance;
import org.apache.flink.runtime.instance.InstanceConnectionInfo;
import org.apache.flink.runtime.profiling.impl.types.InternalInstanceProfilingData;
import org.apache.flink.runtime.profiling.types.InstanceSummaryProfilingEvent;

public class JobProfilingData {
    private final ExecutionGraph executionGraph;
    private final long profilingStart;
    private final Map<InstanceConnectionInfo, InternalInstanceProfilingData> collectedInstanceProfilingData = new HashMap<InstanceConnectionInfo, InternalInstanceProfilingData>();

    public JobProfilingData(ExecutionGraph executionGraph) {
        this.executionGraph = executionGraph;
        this.profilingStart = System.currentTimeMillis();
    }

    public long getProfilingStart() {
        return this.profilingStart;
    }

    public ExecutionGraph getExecutionGraph() {
        return this.executionGraph;
    }

    public boolean addIfInstanceIsAllocatedByJob(InternalInstanceProfilingData instanceProfilingData) {
        for (ExecutionVertex executionVertex : this.executionGraph.getAllExecutionVertices()) {
            AllocatedSlot slot = executionVertex.getCurrentAssignedResource();
            if (slot == null || !slot.getInstance().getInstanceConnectionInfo().equals(instanceProfilingData.getInstanceConnectionInfo())) continue;
            this.collectedInstanceProfilingData.put(instanceProfilingData.getInstanceConnectionInfo(), instanceProfilingData);
            return true;
        }
        return false;
    }

    public InstanceSummaryProfilingEvent getInstanceSummaryProfilingData(long timestamp) {
        HashSet<Instance> tempSet = new HashSet<Instance>();
        for (ExecutionVertex executionVertex : this.executionGraph.getAllExecutionVertices()) {
            AllocatedSlot slot = executionVertex.getCurrentAssignedResource();
            if (slot == null) continue;
            tempSet.add(slot.getInstance());
        }
        if (tempSet.size() != this.collectedInstanceProfilingData.size()) {
            return null;
        }
        return this.constructInstanceSummary(timestamp);
    }

    private InstanceSummaryProfilingEvent constructInstanceSummary(long timestamp) {
        int numberOfInstances = this.collectedInstanceProfilingData.size();
        Iterator<InstanceConnectionInfo> instanceIterator = this.collectedInstanceProfilingData.keySet().iterator();
        long freeMemorySum = 0L;
        long totalMemorySum = 0L;
        long bufferedMemorySum = 0L;
        long cachedMemorySum = 0L;
        long cachedSwapMemorySum = 0L;
        int ioWaitCPUSum = 0;
        int idleCPUSum = 0;
        int profilingIntervalSum = 0;
        int systemCPUSum = 0;
        int hardIrqCPUSum = 0;
        int softIrqCPUSum = 0;
        int userCPUSum = 0;
        long receivedBytesSum = 0L;
        long transmittedBytesSum = 0L;
        while (instanceIterator.hasNext()) {
            InternalInstanceProfilingData profilingData = this.collectedInstanceProfilingData.get(instanceIterator.next());
            freeMemorySum += profilingData.getFreeMemory();
            ioWaitCPUSum += profilingData.getIOWaitCPU();
            idleCPUSum += profilingData.getIdleCPU();
            profilingIntervalSum += profilingData.getProfilingInterval();
            systemCPUSum += profilingData.getSystemCPU();
            hardIrqCPUSum += profilingData.getHardIrqCPU();
            softIrqCPUSum += profilingData.getSoftIrqCPU();
            totalMemorySum += profilingData.getTotalMemory();
            userCPUSum += profilingData.getUserCPU();
            receivedBytesSum += profilingData.getReceivedBytes();
            transmittedBytesSum += profilingData.getTransmittedBytes();
            bufferedMemorySum += profilingData.getBufferedMemory();
            cachedMemorySum += profilingData.getCachedMemory();
            cachedSwapMemorySum += profilingData.getCachedSwapMemory();
        }
        InstanceSummaryProfilingEvent instanceSummary = new InstanceSummaryProfilingEvent(profilingIntervalSum / numberOfInstances, ioWaitCPUSum / numberOfInstances, idleCPUSum / numberOfInstances, userCPUSum / numberOfInstances, systemCPUSum / numberOfInstances, hardIrqCPUSum / numberOfInstances, softIrqCPUSum / numberOfInstances, totalMemorySum / (long)numberOfInstances, freeMemorySum / (long)numberOfInstances, bufferedMemorySum / (long)numberOfInstances, cachedMemorySum / (long)numberOfInstances, cachedSwapMemorySum / (long)numberOfInstances, receivedBytesSum / (long)numberOfInstances, transmittedBytesSum / (long)numberOfInstances, this.executionGraph.getJobID(), timestamp, timestamp - this.profilingStart);
        this.collectedInstanceProfilingData.clear();
        return instanceSummary;
    }
}

