/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.profiling.impl.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.io.StringRecord;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.profiling.impl.types.InternalProfilingData;
import org.apache.flink.util.StringUtils;

public class ProfilingDataContainer
implements IOReadableWritable {
    private final Queue<InternalProfilingData> queuedProfilingData = new ArrayDeque<InternalProfilingData>();

    public void addProfilingData(InternalProfilingData profilingData) {
        if (profilingData == null) {
            return;
        }
        this.queuedProfilingData.add(profilingData);
    }

    public void clear() {
        this.queuedProfilingData.clear();
    }

    public void read(DataInputView in) throws IOException {
        int numberOfRecords = in.readInt();
        for (int i = 0; i < numberOfRecords; ++i) {
            String className = StringRecord.readString((DataInput)in);
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (Exception e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            InternalProfilingData profilingData = null;
            try {
                profilingData = (InternalProfilingData)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IOException(StringUtils.stringifyException((Throwable)e));
            }
            profilingData.read(in);
            this.queuedProfilingData.add(profilingData);
        }
    }

    public int size() {
        return this.queuedProfilingData.size();
    }

    public boolean isEmpty() {
        return this.queuedProfilingData.isEmpty();
    }

    public Iterator<InternalProfilingData> getIterator() {
        return this.queuedProfilingData.iterator();
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.queuedProfilingData.size());
        for (InternalProfilingData profilingData : this.queuedProfilingData) {
            StringRecord.writeString((DataOutput)out, (String)profilingData.getClass().getName());
            profilingData.write(out);
        }
    }
}

