/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.profiling.types;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.event.job.AbstractEvent;
import org.apache.flink.runtime.event.job.ManagementEvent;
import org.apache.flink.runtime.jobgraph.JobID;
import org.apache.flink.shaded.com.google.common.base.Preconditions;

public abstract class ProfilingEvent
extends AbstractEvent
implements ManagementEvent {
    private static final long serialVersionUID = 1L;
    private final JobID jobID;
    private long profilingTimestamp;

    public ProfilingEvent(JobID jobID, long timestamp, long profilingTimestamp) {
        super(timestamp);
        Preconditions.checkNotNull((Object)jobID);
        this.jobID = jobID;
        this.profilingTimestamp = profilingTimestamp;
    }

    public ProfilingEvent() {
        this.jobID = new JobID();
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public long getProfilingTimestamp() {
        return this.profilingTimestamp;
    }

    @Override
    public void read(DataInputView in) throws IOException {
        super.read(in);
        this.jobID.read(in);
        this.profilingTimestamp = in.readLong();
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        super.write(out);
        this.jobID.write(out);
        out.writeLong(this.profilingTimestamp);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ProfilingEvent) {
            ProfilingEvent other = (ProfilingEvent)obj;
            return super.equals(obj) && this.profilingTimestamp == other.profilingTimestamp && this.jobID.equals(other.jobID);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.jobID.hashCode() ^ (int)(this.profilingTimestamp >>> 32) ^ (int)this.profilingTimestamp ^ super.hashCode();
    }
}

