/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TimeZone;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.ByteRangeInputStream;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenRenewer;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.hdfs.server.common.JspHelper;
import org.apache.hadoop.hdfs.tools.DelegationTokenFetcher;
import org.apache.hadoop.hdfs.web.URLUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ServletUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class HftpFileSystem
extends FileSystem
implements DelegationTokenRenewer.Renewable {
    public static final Text TOKEN_KIND;
    protected UserGroupInformation ugi;
    private URI hftpURI;
    protected URI nnUri;
    protected URI nnSecureUri;
    public static final String HFTP_TIMEZONE = "UTC";
    public static final String HFTP_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private Token<?> delegationToken;
    private Token<?> renewToken;
    private static final HftpDelegationTokenSelector hftpTokenSelector;
    private DelegationTokenRenewer dtRenewer = null;
    protected static final ThreadLocal<SimpleDateFormat> df;

    private synchronized void addRenewAction(HftpFileSystem hftpFs) {
        if (this.dtRenewer == null) {
            this.dtRenewer = DelegationTokenRenewer.getInstance();
        }
        this.dtRenewer.addRenewAction(hftpFs);
    }

    public static final SimpleDateFormat getDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat(HFTP_DATE_FORMAT);
        df.setTimeZone(TimeZone.getTimeZone(HFTP_TIMEZONE));
        return df;
    }

    protected int getDefaultPort() {
        return this.getConf().getInt("dfs.http.port", 50070);
    }

    protected int getDefaultSecurePort() {
        return this.getConf().getInt("dfs.https.port", 50470);
    }

    protected InetSocketAddress getNamenodeAddr(URI uri) {
        return NetUtils.createSocketAddr((String)uri.getAuthority(), (int)this.getDefaultPort());
    }

    protected InetSocketAddress getNamenodeSecureAddr(URI uri) {
        return NetUtils.createSocketAddrForHost((String)uri.getHost(), (int)this.getDefaultSecurePort());
    }

    protected URI getNamenodeUri(URI uri) {
        return DFSUtil.createUri("http", this.getNamenodeAddr(uri));
    }

    protected URI getNamenodeSecureUri(URI uri) {
        return DFSUtil.createUri("https", this.getNamenodeSecureAddr(uri));
    }

    public String getCanonicalServiceName() {
        return SecurityUtil.buildTokenService((URI)this.nnSecureUri).toString();
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.setConf(conf);
        this.ugi = UserGroupInformation.getCurrentUser();
        this.nnUri = this.getNamenodeUri(name);
        this.nnSecureUri = this.getNamenodeSecureUri(name);
        try {
            this.hftpURI = new URI(name.getScheme(), name.getAuthority(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            this.initDelegationToken();
        }
    }

    protected void initDelegationToken() throws IOException {
        Object token = this.selectDelegationToken(this.ugi);
        boolean createdToken = false;
        if (token == null) {
            token = this.getDelegationToken(null);
            boolean bl = createdToken = token != null;
        }
        if (token != null) {
            this.setDelegationToken((Token)token);
            if (createdToken) {
                this.addRenewAction(this);
                LOG.debug((Object)("Created new DT for " + token.getService()));
            } else {
                LOG.debug((Object)("Found existing DT for " + token.getService()));
            }
        }
    }

    protected Token<DelegationTokenIdentifier> selectDelegationToken(UserGroupInformation ugi) {
        return hftpTokenSelector.selectToken(this.nnSecureUri, ugi.getTokens(), this.getConf());
    }

    @Override
    public Token<?> getRenewToken() {
        return this.renewToken;
    }

    @Override
    public synchronized <T extends TokenIdentifier> void setDelegationToken(Token<T> token) {
        this.renewToken = token;
        this.delegationToken = new Token(token);
        this.delegationToken.setKind(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
    }

    public synchronized Token<?> getDelegationToken(final String renewer) throws IOException {
        try {
            this.ugi.reloginFromKeytab();
            return (Token)this.ugi.doAs(new PrivilegedExceptionAction<Token<?>>(){

                @Override
                public Token<?> run() throws IOException {
                    Credentials c;
                    String nnHttpUrl = HftpFileSystem.this.nnSecureUri.toString();
                    try {
                        c = DelegationTokenFetcher.getDTfromRemote(nnHttpUrl, renewer);
                    }
                    catch (IOException e) {
                        if (e.getCause() instanceof ConnectException) {
                            FileSystem.LOG.warn((Object)("Couldn't connect to " + nnHttpUrl + ", assuming security is disabled"));
                            return null;
                        }
                        if (FileSystem.LOG.isDebugEnabled()) {
                            FileSystem.LOG.debug((Object)"Exception getting delegation token", (Throwable)e);
                        }
                        throw e;
                    }
                    Iterator i$ = c.getAllTokens().iterator();
                    if (i$.hasNext()) {
                        Token t = (Token)i$.next();
                        if (FileSystem.LOG.isDebugEnabled()) {
                            FileSystem.LOG.debug((Object)("Got dt for " + HftpFileSystem.this.getUri() + ";t.service=" + t.getService()));
                        }
                        return t;
                    }
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public URI getUri() {
        return this.hftpURI;
    }

    protected URL getNamenodeURL(String path, String query) throws IOException {
        URL url = new URL("http", this.nnUri.getHost(), this.nnUri.getPort(), path + '?' + query);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("url=" + url));
        }
        return url;
    }

    private String getEncodedUgiParameter() {
        StringBuilder ugiParamenter = new StringBuilder(ServletUtil.encodeQueryValue((String)this.ugi.getShortUserName()));
        for (String g : this.ugi.getGroupNames()) {
            ugiParamenter.append(",");
            ugiParamenter.append(ServletUtil.encodeQueryValue((String)g));
        }
        return ugiParamenter.toString();
    }

    protected HttpURLConnection openConnection(String path, String query) throws IOException {
        query = this.addDelegationTokenParam(query);
        URL url = this.getNamenodeURL(path, query);
        HttpURLConnection connection = (HttpURLConnection)URLUtils.openConnection(url);
        connection.setRequestMethod("GET");
        connection.connect();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addDelegationTokenParam(String query) throws IOException {
        String tokenString = null;
        if (UserGroupInformation.isSecurityEnabled()) {
            HftpFileSystem hftpFileSystem = this;
            synchronized (hftpFileSystem) {
                if (this.delegationToken != null) {
                    tokenString = this.delegationToken.encodeToUrlString();
                    return query + JspHelper.getDelegationTokenUrlParam(tokenString);
                }
            }
        }
        return query;
    }

    public FSDataInputStream open(Path f, int buffersize) throws IOException {
        f = f.makeQualified(this.getUri(), this.getWorkingDirectory());
        String path = "/data" + ServletUtil.encodePath((String)f.toUri().getPath());
        String query = this.addDelegationTokenParam("ugi=" + this.getEncodedUgiParameter());
        URL u = this.getNamenodeURL(path, query);
        return new FSDataInputStream((InputStream)((Object)new RangeHeaderInputStream(u)));
    }

    public void close() throws IOException {
        super.close();
        if (this.dtRenewer != null) {
            this.dtRenewer.removeRenewAction(this);
        }
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        LsParser lsparser = new LsParser();
        return lsparser.listStatus(f);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        LsParser lsparser = new LsParser();
        return lsparser.getFileStatus(f);
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        String s = this.makeQualified(f).toUri().getPath();
        return new ChecksumParser().getFileChecksum(s);
    }

    public Path getWorkingDirectory() {
        return new Path("/").makeQualified(this.getUri(), null);
    }

    public void setWorkingDirectory(Path f) {
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean rename(Path src, Path dst) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        throw new IOException("Not supported");
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new IOException("Not supported");
    }

    private static ContentSummary toContentSummary(Attributes attrs) throws SAXException {
        String length = attrs.getValue("length");
        String fileCount = attrs.getValue("fileCount");
        String directoryCount = attrs.getValue("directoryCount");
        String quota = attrs.getValue("quota");
        String spaceConsumed = attrs.getValue("spaceConsumed");
        String spaceQuota = attrs.getValue("spaceQuota");
        if (length == null || fileCount == null || directoryCount == null || quota == null || spaceConsumed == null || spaceQuota == null) {
            return null;
        }
        try {
            return new ContentSummary(Long.parseLong(length), Long.parseLong(fileCount), Long.parseLong(directoryCount), Long.parseLong(quota), Long.parseLong(spaceConsumed), Long.parseLong(spaceQuota));
        }
        catch (Exception e) {
            throw new SAXException("Invalid attributes: length=" + length + ", fileCount=" + fileCount + ", directoryCount=" + directoryCount + ", quota=" + quota + ", spaceConsumed=" + spaceConsumed + ", spaceQuota=" + spaceQuota, e);
        }
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        String s = this.makeQualified(f).toUri().getPath();
        ContentSummary cs = new ContentSummaryParser().getContentSummary(s);
        return cs != null ? cs : super.getContentSummary(f);
    }

    static {
        HttpURLConnection.setFollowRedirects(true);
        TOKEN_KIND = new Text("HFTP delegation");
        hftpTokenSelector = new HftpDelegationTokenSelector();
        df = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return HftpFileSystem.getDateFormat();
            }
        };
    }

    private static class HftpDelegationTokenSelector
    extends AbstractDelegationTokenSelector<DelegationTokenIdentifier> {
        private static final DelegationTokenSelector hdfsTokenSelector = new DelegationTokenSelector();

        public HftpDelegationTokenSelector() {
            super(TOKEN_KIND);
        }

        Token<DelegationTokenIdentifier> selectToken(URI nnUri, Collection<Token<?>> tokens, Configuration conf) {
            Token<DelegationTokenIdentifier> token = this.selectToken(SecurityUtil.buildTokenService((URI)nnUri), tokens);
            if (token == null) {
                token = hdfsTokenSelector.selectToken(nnUri, tokens, conf);
            }
            return token;
        }
    }

    @InterfaceAudience.Private
    public static class TokenManager
    extends TokenRenewer {
        public boolean handleKind(Text kind) {
            return kind.equals((Object)TOKEN_KIND);
        }

        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        public long renew(Token<?> token, Configuration conf) throws IOException {
            UserGroupInformation.getLoginUser().reloginFromKeytab();
            InetSocketAddress serviceAddr = SecurityUtil.getTokenServiceAddr(token);
            return DelegationTokenFetcher.renewDelegationToken(DFSUtil.createUri("https", serviceAddr).toString(), token);
        }

        public void cancel(Token<?> token, Configuration conf) throws IOException {
            UserGroupInformation.getLoginUser().checkTGTAndReloginFromKeytab();
            InetSocketAddress serviceAddr = SecurityUtil.getTokenServiceAddr(token);
            DelegationTokenFetcher.cancelDelegationToken(DFSUtil.createUri("https", serviceAddr).toString(), token);
        }
    }

    private class ContentSummaryParser
    extends DefaultHandler {
        private ContentSummary contentsummary;

        private ContentSummaryParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            if (!ContentSummary.class.getName().equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException((Exception)((Object)RemoteException.valueOf((Attributes)attrs)));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            this.contentsummary = HftpFileSystem.toContentSummary(attrs);
        }

        private ContentSummary getContentSummary(String path) throws IOException {
            HttpURLConnection connection = HftpFileSystem.this.openConnection("/contentSummary" + ServletUtil.encodePath((String)path), "ugi=" + HftpFileSystem.this.getEncodedUgiParameter());
            InputStream in = null;
            try {
                in = connection.getInputStream();
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                xr.parse(new InputSource(in));
            }
            catch (FileNotFoundException fnfe) {
                ContentSummary contentSummary = null;
                return contentSummary;
            }
            catch (SAXException saxe) {
                Exception embedded = saxe.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("Invalid xml format", saxe);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                connection.disconnect();
            }
            return this.contentsummary;
        }
    }

    private class ChecksumParser
    extends DefaultHandler {
        private FileChecksum filechecksum;

        private ChecksumParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            if (!MD5MD5CRC32FileChecksum.class.getName().equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException((Exception)((Object)RemoteException.valueOf((Attributes)attrs)));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            this.filechecksum = MD5MD5CRC32FileChecksum.valueOf((Attributes)attrs);
        }

        private FileChecksum getFileChecksum(String f) throws IOException {
            HttpURLConnection connection = HftpFileSystem.this.openConnection("/fileChecksum" + ServletUtil.encodePath((String)f), "ugi=" + HftpFileSystem.this.getEncodedUgiParameter());
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                xr.parse(new InputSource(connection.getInputStream()));
            }
            catch (SAXException e) {
                Exception embedded = e.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("invalid xml directory content", e);
            }
            finally {
                connection.disconnect();
            }
            return this.filechecksum;
        }
    }

    class LsParser
    extends DefaultHandler {
        ArrayList<FileStatus> fslist = new ArrayList();

        LsParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            long modif;
            if ("listing".equals(qname)) {
                return;
            }
            if (!"file".equals(qname) && !"directory".equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException((Exception)((Object)RemoteException.valueOf((Attributes)attrs)));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            long atime = 0L;
            try {
                SimpleDateFormat ldf = df.get();
                modif = ldf.parse(attrs.getValue("modified")).getTime();
                String astr = attrs.getValue("accesstime");
                if (astr != null) {
                    atime = ldf.parse(astr).getTime();
                }
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
            FileStatus fs = "file".equals(qname) ? new FileStatus(Long.valueOf(attrs.getValue("size")).longValue(), false, (int)Short.valueOf(attrs.getValue("replication")).shortValue(), Long.valueOf(attrs.getValue("blocksize")).longValue(), modif, atime, FsPermission.valueOf((String)attrs.getValue("permission")), attrs.getValue("owner"), attrs.getValue("group"), HftpFileSystem.this.makeQualified(new Path(HftpFileSystem.this.getUri().toString(), attrs.getValue("path")))) : new FileStatus(0L, true, 0, 0L, modif, atime, FsPermission.valueOf((String)attrs.getValue("permission")), attrs.getValue("owner"), attrs.getValue("group"), HftpFileSystem.this.makeQualified(new Path(HftpFileSystem.this.getUri().toString(), attrs.getValue("path"))));
            this.fslist.add(fs);
        }

        private void fetchList(String path, boolean recur) throws IOException {
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                HttpURLConnection connection = HftpFileSystem.this.openConnection("/listPaths" + ServletUtil.encodePath((String)path), "ugi=" + HftpFileSystem.this.getEncodedUgiParameter() + (recur ? "&recursive=yes" : ""));
                InputStream resp = connection.getInputStream();
                xr.parse(new InputSource(resp));
            }
            catch (SAXException e) {
                Exception embedded = e.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("invalid xml directory content", e);
            }
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            this.fetchList(f.toUri().getPath(), false);
            if (this.fslist.size() == 0) {
                throw new FileNotFoundException("File does not exist: " + f);
            }
            return this.fslist.get(0);
        }

        public FileStatus[] listStatus(Path f, boolean recur) throws IOException {
            this.fetchList(f.toUri().getPath(), recur);
            if (this.fslist.size() > 0 && (this.fslist.size() != 1 || this.fslist.get(0).isDirectory())) {
                this.fslist.remove(0);
            }
            return this.fslist.toArray(new FileStatus[0]);
        }

        public FileStatus[] listStatus(Path f) throws IOException {
            return this.listStatus(f, false);
        }
    }

    static class RangeHeaderInputStream
    extends ByteRangeInputStream {
        RangeHeaderInputStream(RangeHeaderUrlOpener o, RangeHeaderUrlOpener r) {
            super(o, r);
        }

        RangeHeaderInputStream(URL url) {
            this(new RangeHeaderUrlOpener(url), new RangeHeaderUrlOpener(null));
        }

        @Override
        protected void checkResponseCode(HttpURLConnection connection) throws IOException {
            int code = connection.getResponseCode();
            if (this.startPos != 0L && code != 206) {
                throw new IOException("HTTP_PARTIAL expected, received " + code);
            }
            if (this.startPos == 0L && code != 200) {
                throw new IOException("HTTP_OK expected, received " + code);
            }
        }

        @Override
        protected URL getResolvedUrl(HttpURLConnection connection) {
            return connection.getURL();
        }
    }

    static class RangeHeaderUrlOpener
    extends ByteRangeInputStream.URLOpener {
        RangeHeaderUrlOpener(URL url) {
            super(url);
        }

        @Override
        protected HttpURLConnection openConnection() throws IOException {
            return (HttpURLConnection)URLUtils.openConnection(this.url);
        }

        @Override
        protected HttpURLConnection openConnection(long offset) throws IOException {
            HttpURLConnection conn = this.openConnection();
            conn.setRequestMethod("GET");
            if (offset != 0L) {
                conn.setRequestProperty("Range", "bytes=" + offset + "-");
            }
            return conn;
        }
    }
}

