/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.util.ExactSizeInputStream;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.DataChecksum;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class HdfsProtoUtil {
    public static HdfsProtos.BlockTokenIdentifierProto toProto(Token<?> blockToken) {
        return HdfsProtos.BlockTokenIdentifierProto.newBuilder().setIdentifier(ByteString.copyFrom((byte[])blockToken.getIdentifier())).setPassword(ByteString.copyFrom((byte[])blockToken.getPassword())).setKind(blockToken.getKind().toString()).setService(blockToken.getService().toString()).build();
    }

    public static Token<BlockTokenIdentifier> fromProto(HdfsProtos.BlockTokenIdentifierProto proto) {
        return new Token(proto.getIdentifier().toByteArray(), proto.getPassword().toByteArray(), new Text(proto.getKind()), new Text(proto.getService()));
    }

    public static HdfsProtos.ExtendedBlockProto toProto(ExtendedBlock block) {
        return HdfsProtos.ExtendedBlockProto.newBuilder().setBlockId(block.getBlockId()).setPoolId(block.getBlockPoolId()).setNumBytes(block.getNumBytes()).setGenerationStamp(block.getGenerationStamp()).build();
    }

    public static ExtendedBlock fromProto(HdfsProtos.ExtendedBlockProto proto) {
        return new ExtendedBlock(proto.getPoolId(), proto.getBlockId(), proto.getNumBytes(), proto.getGenerationStamp());
    }

    private static HdfsProtos.DatanodeIDProto toProto(DatanodeID dni) {
        return HdfsProtos.DatanodeIDProto.newBuilder().setName(dni.getName()).setStorageID(dni.getStorageID()).setInfoPort(dni.getInfoPort()).build();
    }

    private static DatanodeID fromProto(HdfsProtos.DatanodeIDProto idProto) {
        return new DatanodeID(idProto.getName(), idProto.getStorageID(), idProto.getInfoPort(), -1);
    }

    public static HdfsProtos.DatanodeInfoProto toProto(DatanodeInfo dni) {
        return HdfsProtos.DatanodeInfoProto.newBuilder().setId(HdfsProtoUtil.toProto((DatanodeID)dni)).setCapacity(dni.getCapacity()).setDfsUsed(dni.getDfsUsed()).setRemaining(dni.getRemaining()).setBlockPoolUsed(dni.getBlockPoolUsed()).setLastUpdate(dni.getLastUpdate()).setXceiverCount(dni.getXceiverCount()).setLocation(dni.getNetworkLocation()).setHostName(dni.getHostName()).setAdminState(HdfsProtos.DatanodeInfoProto.AdminState.valueOf(dni.getAdminState().name())).build();
    }

    public static DatanodeInfo fromProto(HdfsProtos.DatanodeInfoProto dniProto) {
        DatanodeInfo dniObj = new DatanodeInfo(HdfsProtoUtil.fromProto(dniProto.getId()), dniProto.getLocation(), dniProto.getHostName());
        dniObj.setCapacity(dniProto.getCapacity());
        dniObj.setDfsUsed(dniProto.getDfsUsed());
        dniObj.setRemaining(dniProto.getRemaining());
        dniObj.setBlockPoolUsed(dniProto.getBlockPoolUsed());
        dniObj.setLastUpdate(dniProto.getLastUpdate());
        dniObj.setXceiverCount(dniProto.getXceiverCount());
        dniObj.setAdminState(DatanodeInfo.AdminStates.valueOf(dniProto.getAdminState().name()));
        return dniObj;
    }

    public static ArrayList<? extends HdfsProtos.DatanodeInfoProto> toProtos(DatanodeInfo[] dnInfos, int startIdx) {
        ArrayList protos = Lists.newArrayListWithCapacity((int)dnInfos.length);
        for (int i = startIdx; i < dnInfos.length; ++i) {
            protos.add(HdfsProtoUtil.toProto(dnInfos[i]));
        }
        return protos;
    }

    public static DatanodeInfo[] fromProtos(List<HdfsProtos.DatanodeInfoProto> targetsList) {
        DatanodeInfo[] ret = new DatanodeInfo[targetsList.size()];
        int i = 0;
        for (HdfsProtos.DatanodeInfoProto proto : targetsList) {
            ret[i++] = HdfsProtoUtil.fromProto(proto);
        }
        return ret;
    }

    public static DataChecksum.Type fromProto(HdfsProtos.ChecksumTypeProto type) {
        return DataChecksum.Type.valueOf((String)type.name());
    }

    public static HdfsProtos.ChecksumTypeProto toProto(DataChecksum.Type type) {
        return HdfsProtos.ChecksumTypeProto.valueOf(type.name());
    }

    public static InputStream vintPrefixed(InputStream input) throws IOException {
        int firstByte = input.read();
        if (firstByte == -1) {
            throw new EOFException("Premature EOF: no length prefix available");
        }
        int size = CodedInputStream.readRawVarint32((int)firstByte, (InputStream)input);
        assert (size >= 0);
        return new ExactSizeInputStream(input, size);
    }
}

