/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.HashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class Host2NodesMap {
    private HashMap<String, DatanodeDescriptor[]> map = new HashMap();
    private ReadWriteLock hostmapLock = new ReentrantReadWriteLock();

    Host2NodesMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean contains(DatanodeDescriptor node) {
        if (node == null) {
            return false;
        }
        String host = node.getHost();
        this.hostmapLock.readLock().lock();
        try {
            DatanodeDescriptor[] nodes = this.map.get(host);
            if (nodes != null) {
                for (DatanodeDescriptor containedNode : nodes) {
                    if (node != containedNode) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.hostmapLock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(DatanodeDescriptor node) {
        this.hostmapLock.writeLock().lock();
        try {
            DatanodeDescriptor[] newNodes;
            if (node == null || this.contains(node)) {
                boolean bl = false;
                return bl;
            }
            String host = node.getHost();
            DatanodeDescriptor[] nodes = this.map.get(host);
            if (nodes == null) {
                newNodes = new DatanodeDescriptor[]{node};
            } else {
                newNodes = new DatanodeDescriptor[nodes.length + 1];
                System.arraycopy(nodes, 0, newNodes, 0, nodes.length);
                newNodes[nodes.length] = node;
            }
            this.map.put(host, newNodes);
            boolean bl = true;
            return bl;
        }
        finally {
            this.hostmapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(DatanodeDescriptor node) {
        if (node == null) {
            return false;
        }
        String host = node.getHost();
        this.hostmapLock.writeLock().lock();
        try {
            int i;
            DatanodeDescriptor[] nodes = this.map.get(host);
            if (nodes == null) {
                boolean bl = false;
                return bl;
            }
            if (nodes.length == 1) {
                if (nodes[0] == node) {
                    this.map.remove(host);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            for (i = 0; i < nodes.length && nodes[i] != node; ++i) {
            }
            if (i == nodes.length) {
                boolean bl = false;
                return bl;
            }
            DatanodeDescriptor[] newNodes = new DatanodeDescriptor[nodes.length - 1];
            System.arraycopy(nodes, 0, newNodes, 0, i);
            System.arraycopy(nodes, i + 1, newNodes, i, nodes.length - i - 1);
            this.map.put(host, newNodes);
            boolean bl = true;
            return bl;
        }
        finally {
            this.hostmapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatanodeDescriptor getDatanodeByHost(String host) {
        if (host == null) {
            return null;
        }
        this.hostmapLock.readLock().lock();
        try {
            DatanodeDescriptor[] nodes = this.map.get(host);
            if (nodes == null) {
                DatanodeDescriptor datanodeDescriptor = null;
                return datanodeDescriptor;
            }
            if (nodes.length == 1) {
                DatanodeDescriptor datanodeDescriptor = nodes[0];
                return datanodeDescriptor;
            }
            DatanodeDescriptor datanodeDescriptor = nodes[DFSUtil.getRandom().nextInt(nodes.length)];
            return datanodeDescriptor;
        }
        finally {
            this.hostmapLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatanodeDescriptor getDatanodeByName(String name) {
        if (name == null) {
            return null;
        }
        int colon = name.indexOf(":");
        String host = colon < 0 ? name : name.substring(0, colon);
        this.hostmapLock.readLock().lock();
        try {
            DatanodeDescriptor[] nodes = this.map.get(host);
            if (nodes == null) {
                DatanodeDescriptor datanodeDescriptor = null;
                return datanodeDescriptor;
            }
            for (DatanodeDescriptor containedNode : nodes) {
                if (!name.equals(containedNode.getName())) continue;
                DatanodeDescriptor datanodeDescriptor = containedNode;
                return datanodeDescriptor;
            }
            DatanodeDescriptor datanodeDescriptor = null;
            return datanodeDescriptor;
        }
        finally {
            this.hostmapLock.readLock().unlock();
        }
    }
}

