/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.common.Storage;

@InterfaceAudience.Private
@InterfaceStability.Unstable
abstract class FSImageStorageInspector {
    FSImageStorageInspector() {
    }

    abstract void inspectDirectory(Storage.StorageDirectory var1) throws IOException;

    abstract boolean isUpgradeFinalized();

    abstract LoadPlan createLoadPlan() throws IOException;

    abstract boolean needToSave();

    static class FSImageFile {
        final Storage.StorageDirectory sd;
        final long txId;
        private final File file;

        FSImageFile(Storage.StorageDirectory sd, File file, long txId) {
            assert (txId >= 0L) : "Invalid txid on " + file + ": " + txId;
            this.sd = sd;
            this.txId = txId;
            this.file = file;
        }

        File getFile() {
            return this.file;
        }

        public long getCheckpointTxId() {
            return this.txId;
        }

        public String toString() {
            return String.format("FSImageFile(file=%s, cpktTxId=%019d)", this.file.toString(), this.txId);
        }
    }

    static abstract class LoadPlan {
        LoadPlan() {
        }

        abstract boolean doRecovery() throws IOException;

        abstract File getImageFile();

        abstract List<File> getEditsFiles();

        abstract Storage.StorageDirectory getStorageDirectoryForProperties();

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Will load image file: ").append(this.getImageFile()).append("\n");
            sb.append("Will load edits files:").append("\n");
            for (File f : this.getEditsFiles()) {
                sb.append("  ").append(f).append("\n");
            }
            sb.append("Will load metadata from: ").append(this.getStorageDirectoryForProperties()).append("\n");
            return sb.toString();
        }
    }
}

