/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.hdfs.util.MD5FileUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class GetImageServlet
extends HttpServlet {
    private static final long serialVersionUID = -7669068179452648952L;
    private static final Log LOG = LogFactory.getLog(GetImageServlet.class);
    private static final String TXID_PARAM = "txid";
    private static final String START_TXID_PARAM = "startTxId";
    private static final String END_TXID_PARAM = "endTxId";
    private static final String STORAGEINFO_PARAM = "storageInfo";
    private static Set<Long> currentlyDownloadingCheckpoints = Collections.synchronizedSet(new HashSet());

    public void doGet(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        try {
            ServletContext context = this.getServletContext();
            final FSImage nnImage = NameNodeHttpServer.getFsImageFromContext(context);
            final GetImageParams parsedParams = new GetImageParams(request, response);
            final Configuration conf = (Configuration)this.getServletContext().getAttribute("current.conf");
            if (UserGroupInformation.isSecurityEnabled() && !this.isValidRequestor(request.getRemoteUser(), conf)) {
                response.sendError(403, "Only Namenode and Secondary Namenode may access this servlet");
                LOG.warn((Object)("Received non-NN/SNN request for image or edits from " + request.getRemoteHost()));
                return;
            }
            String myStorageInfoString = nnImage.getStorage().toColonSeparatedString();
            String theirStorageInfoString = parsedParams.getStorageInfoString();
            if (theirStorageInfoString != null && !myStorageInfoString.equals(theirStorageInfoString)) {
                response.sendError(403, "This namenode has storage info " + myStorageInfoString + " but the secondary expected " + theirStorageInfoString);
                LOG.warn((Object)("Received an invalid request file transfer request from a secondary with storage info " + theirStorageInfoString));
                return;
            }
            UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    if (parsedParams.isGetImage()) {
                        long txid = parsedParams.getTxId();
                        File imageFile = nnImage.getStorage().getFsImageName(txid);
                        if (imageFile == null) {
                            throw new IOException("Could not find image with txid " + txid);
                        }
                        GetImageServlet.this.setVerificationHeaders(response, imageFile);
                        TransferFsImage.getFileServer((OutputStream)response.getOutputStream(), imageFile, GetImageServlet.this.getThrottler(conf));
                    } else if (parsedParams.isGetEdit()) {
                        long startTxId = parsedParams.getStartTxId();
                        long endTxId = parsedParams.getEndTxId();
                        File editFile = nnImage.getStorage().findFinalizedEditsFile(startTxId, endTxId);
                        GetImageServlet.this.setVerificationHeaders(response, editFile);
                        TransferFsImage.getFileServer((OutputStream)response.getOutputStream(), editFile, GetImageServlet.this.getThrottler(conf));
                    } else if (parsedParams.isPutImage()) {
                        final long txid = parsedParams.getTxId();
                        if (!currentlyDownloadingCheckpoints.add(txid)) {
                            throw new IOException("Another checkpointer is already in the process of uploading a checkpoint made at transaction ID " + txid);
                        }
                        try {
                            if (nnImage.getStorage().findImageFile(txid) != null) {
                                throw new IOException("Another checkpointer already uploaded an checkpoint for txid " + txid);
                            }
                            MD5Hash downloadImageDigest = (MD5Hash)this.reloginIfNecessary().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<MD5Hash>(){

                                @Override
                                public MD5Hash run() throws Exception {
                                    return TransferFsImage.downloadImageToStorage(parsedParams.getInfoServer(), txid, nnImage.getStorage(), true);
                                }
                            });
                            nnImage.saveDigestAndRenameCheckpointImage(txid, downloadImageDigest);
                            nnImage.purgeOldStorage();
                        }
                        finally {
                            currentlyDownloadingCheckpoints.remove(txid);
                        }
                    }
                    return null;
                }

                private UserGroupInformation reloginIfNecessary() throws IOException {
                    return UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)SecurityUtil.getServerPrincipal((String)conf.get("dfs.namenode.kerberos.https.principal"), (String)NameNode.getAddress(conf).getHostName()), (String)conf.get("dfs.namenode.keytab.file"));
                }
            });
        }
        catch (Exception ie) {
            String errMsg = "GetImage failed. " + StringUtils.stringifyException((Throwable)ie);
            response.sendError(410, errMsg);
            throw new IOException(errMsg);
        }
        finally {
            response.getOutputStream().close();
        }
    }

    private final DataTransferThrottler getThrottler(Configuration conf) {
        long transferBandwidth = conf.getLong("dfs.image.transfer.bandwidthPerSec", 0L);
        DataTransferThrottler throttler = null;
        if (transferBandwidth > 0L) {
            throttler = new DataTransferThrottler(transferBandwidth);
        }
        return throttler;
    }

    protected boolean isValidRequestor(String remoteUser, Configuration conf) throws IOException {
        String[] validRequestors;
        if (remoteUser == null) {
            LOG.warn((Object)"Received null remoteUser while authorizing access to getImage servlet");
            return false;
        }
        for (String v : validRequestors = new String[]{SecurityUtil.getServerPrincipal((String)conf.get("dfs.namenode.kerberos.https.principal"), (String)NameNode.getAddress(conf).getHostName()), SecurityUtil.getServerPrincipal((String)conf.get("dfs.namenode.kerberos.principal"), (String)NameNode.getAddress(conf).getHostName()), SecurityUtil.getServerPrincipal((String)conf.get("dfs.secondary.namenode.kerberos.https.principal"), (String)SecondaryNameNode.getHttpAddress(conf).getHostName()), SecurityUtil.getServerPrincipal((String)conf.get("dfs.secondary.namenode.kerberos.principal"), (String)SecondaryNameNode.getHttpAddress(conf).getHostName())}) {
            if (v == null || !v.equals(remoteUser)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("isValidRequestor is allowing: " + remoteUser));
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isValidRequestor is rejecting: " + remoteUser));
        }
        return false;
    }

    private void setVerificationHeaders(HttpServletResponse response, File file) throws IOException {
        response.setHeader("Content-Length", String.valueOf(file.length()));
        MD5Hash hash = MD5FileUtils.readStoredMd5ForFile(file);
        if (hash != null) {
            response.setHeader("X-MD5-Digest", hash.toString());
        }
    }

    static String getParamStringForImage(long txid, StorageInfo remoteStorageInfo) {
        return "getimage=1&txid=" + txid + "&" + STORAGEINFO_PARAM + "=" + remoteStorageInfo.toColonSeparatedString();
    }

    static String getParamStringForLog(RemoteEditLog log, StorageInfo remoteStorageInfo) {
        return "getedit=1&startTxId=" + log.getStartTxId() + "&" + END_TXID_PARAM + "=" + log.getEndTxId() + "&" + STORAGEINFO_PARAM + "=" + remoteStorageInfo.toColonSeparatedString();
    }

    static String getParamStringToPutImage(long txid, InetSocketAddress imageListenAddress, NNStorage storage) {
        return "putimage=1&txid=" + txid + "&port=" + imageListenAddress.getPort() + "&machine=" + imageListenAddress.getHostName() + "&" + STORAGEINFO_PARAM + "=" + storage.toColonSeparatedString();
    }

    static class GetImageParams {
        private boolean isGetImage;
        private boolean isGetEdit;
        private boolean isPutImage;
        private int remoteport;
        private String machineName;
        private long startTxId;
        private long endTxId;
        private long txId;
        private String storageInfoString;

        public GetImageParams(HttpServletRequest request, HttpServletResponse response) throws IOException {
            Map pmap = request.getParameterMap();
            this.isPutImage = false;
            this.isGetEdit = false;
            this.isGetImage = false;
            this.remoteport = 0;
            this.machineName = null;
            for (Map.Entry entry : pmap.entrySet()) {
                String key = (String)entry.getKey();
                String[] val = (String[])entry.getValue();
                if (key.equals("getimage")) {
                    this.isGetImage = true;
                    this.txId = GetImageParams.parseLongParam(request, GetImageServlet.TXID_PARAM);
                    continue;
                }
                if (key.equals("getedit")) {
                    this.isGetEdit = true;
                    this.startTxId = GetImageParams.parseLongParam(request, GetImageServlet.START_TXID_PARAM);
                    this.endTxId = GetImageParams.parseLongParam(request, GetImageServlet.END_TXID_PARAM);
                    continue;
                }
                if (key.equals("putimage")) {
                    this.isPutImage = true;
                    this.txId = GetImageParams.parseLongParam(request, GetImageServlet.TXID_PARAM);
                    continue;
                }
                if (key.equals("port")) {
                    this.remoteport = new Integer(val[0]);
                    continue;
                }
                if (key.equals("machine")) {
                    this.machineName = val[0];
                    continue;
                }
                if (!key.equals(GetImageServlet.STORAGEINFO_PARAM)) continue;
                this.storageInfoString = val[0];
            }
            int numGets = (this.isGetImage ? 1 : 0) + (this.isGetEdit ? 1 : 0);
            if (numGets > 1 || numGets == 0 && !this.isPutImage) {
                throw new IOException("Illegal parameters to TransferFsImage");
            }
        }

        public String getStorageInfoString() {
            return this.storageInfoString;
        }

        public long getTxId() {
            Preconditions.checkState((this.isGetImage || this.isPutImage ? 1 : 0) != 0);
            return this.txId;
        }

        public long getStartTxId() {
            Preconditions.checkState((boolean)this.isGetEdit);
            return this.startTxId;
        }

        public long getEndTxId() {
            Preconditions.checkState((boolean)this.isGetEdit);
            return this.endTxId;
        }

        boolean isGetEdit() {
            return this.isGetEdit;
        }

        boolean isGetImage() {
            return this.isGetImage;
        }

        boolean isPutImage() {
            return this.isPutImage;
        }

        String getInfoServer() throws IOException {
            if (this.machineName == null || this.remoteport == 0) {
                throw new IOException("MachineName and port undefined");
            }
            return this.machineName + ":" + this.remoteport;
        }

        private static long parseLongParam(HttpServletRequest request, String param) throws IOException {
            String paramStr = request.getParameter(param);
            if (paramStr == null) {
                throw new IOException("Invalid request has no " + param + " parameter");
            }
            return Long.valueOf(paramStr);
        }
    }
}

