/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.protocol;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.avro.reflect.Union;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.protocol.BlockCommand;
import org.apache.hadoop.hdfs.server.protocol.BlockRecoveryCommand;
import org.apache.hadoop.hdfs.server.protocol.KeyUpdateCommand;
import org.apache.hadoop.hdfs.server.protocol.ServerCommand;
import org.apache.hadoop.hdfs.server.protocol.UpgradeCommand;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableFactories;
import org.apache.hadoop.io.WritableFactory;
import org.apache.hadoop.io.WritableUtils;

@Union(value={Void.class, Register.class, Finalize.class, BlockCommand.class, UpgradeCommand.class, BlockRecoveryCommand.class, KeyUpdateCommand.class})
@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class DatanodeCommand
extends ServerCommand {
    public static final DatanodeCommand REGISTER;

    public DatanodeCommand() {
    }

    DatanodeCommand(int action) {
        super(action);
    }

    static {
        WritableFactories.setFactory(Register.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new Register();
            }
        });
        WritableFactories.setFactory(Finalize.class, (WritableFactory)new WritableFactory(){

            public Writable newInstance() {
                return new Finalize();
            }
        });
        REGISTER = new Register();
    }

    public static class Finalize
    extends DatanodeCommand {
        String blockPoolId;

        private Finalize() {
            super(5);
        }

        public Finalize(String bpid) {
            super(5);
            this.blockPoolId = bpid;
        }

        public String getBlockPoolId() {
            return this.blockPoolId;
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.blockPoolId = WritableUtils.readString((DataInput)in);
        }

        @Override
        public void write(DataOutput out) throws IOException {
            WritableUtils.writeString((DataOutput)out, (String)this.blockPoolId);
        }
    }

    static class Register
    extends DatanodeCommand {
        private Register() {
            super(4);
        }

        @Override
        public void readFields(DataInput in) {
        }

        @Override
        public void write(DataOutput out) {
        }
    }
}

