/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import org.apache.hadoop.hdfs.web.resources.Param;

abstract class LongParam
extends Param<Long, Domain> {
    LongParam(Domain domain, Long value, Long min, Long max) {
        super(domain, value);
        this.checkRange(min, max);
    }

    private void checkRange(Long min, Long max) {
        if (this.value == null) {
            return;
        }
        if (min != null && (Long)this.value < min) {
            throw new IllegalArgumentException("Invalid parameter range: " + this.getName() + " = " + ((Domain)this.domain).toString((Long)this.value) + " < " + ((Domain)this.domain).toString(min));
        }
        if (max != null && (Long)this.value > max) {
            throw new IllegalArgumentException("Invalid parameter range: " + this.getName() + " = " + ((Domain)this.domain).toString((Long)this.value) + " > " + ((Domain)this.domain).toString(max));
        }
    }

    @Override
    public String toString() {
        return this.getName() + "=" + ((Domain)this.domain).toString((Long)this.getValue());
    }

    @Override
    public String getValueString() {
        return ((Domain)this.domain).toString((Long)this.getValue());
    }

    static final class Domain
    extends Param.Domain<Long> {
        final int radix;

        Domain(String paramName) {
            this(paramName, 10);
        }

        Domain(String paramName, int radix) {
            super(paramName);
            this.radix = radix;
        }

        @Override
        public String getDomain() {
            return "<null | short in radix " + this.radix + ">";
        }

        @Override
        Long parse(String str) {
            try {
                return "null".equals(str) ? null : Long.valueOf(Long.parseLong(str, this.radix));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Failed to parse \"" + str + "\" as a radix-" + this.radix + " long integer.", e);
            }
        }

        String toString(Long n) {
            return n == null ? "null" : Long.toString(n, this.radix);
        }
    }
}

