/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.java.This0AccessFinder;
import org.apache.flink.util.InstantiationUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClosureCleaner {
    private static Logger LOG = LoggerFactory.getLogger(ClosureCleaner.class);

    private static ClassReader getClassReader(Class<?> cls) {
        String className = cls.getName().replaceFirst("^.*\\.", "") + ".class";
        try {
            return new ClassReader(cls.getResourceAsStream(className));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create ClassReader: " + e);
        }
    }

    public static void clean(Object func, boolean checkSerializable) {
        Class<?> cls = func.getClass();
        for (Field f : cls.getDeclaredFields()) {
            if (!f.getName().startsWith("this$")) continue;
            ClosureCleaner.cleanThis0(func, cls, f.getName());
        }
        if (checkSerializable) {
            ClosureCleaner.ensureSerializable(func);
        }
    }

    private static void cleanThis0(Object func, Class<?> cls, String this0Name) {
        This0AccessFinder this0Finder = new This0AccessFinder(this0Name);
        ClosureCleaner.getClassReader(cls).accept((ClassVisitor)this0Finder, 0);
        if (LOG.isDebugEnabled()) {
            LOG.debug(this0Name + " is accessed: " + this0Finder.isThis0Accessed());
        }
        if (!this0Finder.isThis0Accessed()) {
            Field this0;
            try {
                this0 = func.getClass().getDeclaredField(this0Name);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Could not set " + this0Name + ": " + e);
            }
            this0.setAccessible(true);
            try {
                this0.set(func, null);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could not set " + this0Name + ": " + e);
            }
        }
    }

    public static void ensureSerializable(Object func) {
        try {
            InstantiationUtil.serializeObject((Object)func);
        }
        catch (Exception e) {
            throw new InvalidProgramException("Task " + func + " not serializable: ", (Throwable)e);
        }
    }
}

