/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.functions;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.InvalidProgramException;

public class FunctionAnnotation {
    private FunctionAnnotation() {
    }

    public static Set<Annotation> readSingleConstantAnnotations(Class<?> udfClass) {
        ConstantFields constantSet = udfClass.getAnnotation(ConstantFields.class);
        ConstantFieldsExcept notConstantSet = udfClass.getAnnotation(ConstantFieldsExcept.class);
        ReadFields readfieldSet = udfClass.getAnnotation(ReadFields.class);
        HashSet<Annotation> result = null;
        if (notConstantSet != null && constantSet != null) {
            throw new InvalidProgramException("Either " + ConstantFields.class.getSimpleName() + " or " + ConstantFieldsExcept.class.getSimpleName() + " can be annotated to a function, not both.");
        }
        if (notConstantSet != null) {
            result = new HashSet<Annotation>();
            result.add(notConstantSet);
        }
        if (constantSet != null) {
            result = new HashSet();
            result.add(constantSet);
        }
        if (readfieldSet != null) {
            if (result == null) {
                result = new HashSet();
            }
            result.add(readfieldSet);
        }
        return result;
    }

    public static Set<Annotation> readDualConstantAnnotations(Class<?> udfClass) {
        ConstantFieldsFirst constantSet1 = udfClass.getAnnotation(ConstantFieldsFirst.class);
        ConstantFieldsSecond constantSet2 = udfClass.getAnnotation(ConstantFieldsSecond.class);
        ConstantFieldsFirstExcept notConstantSet1 = udfClass.getAnnotation(ConstantFieldsFirstExcept.class);
        ConstantFieldsSecondExcept notConstantSet2 = udfClass.getAnnotation(ConstantFieldsSecondExcept.class);
        ReadFieldsFirst readfieldSet1 = udfClass.getAnnotation(ReadFieldsFirst.class);
        ReadFieldsSecond readfieldSet2 = udfClass.getAnnotation(ReadFieldsSecond.class);
        if (notConstantSet1 != null && constantSet1 != null) {
            throw new InvalidProgramException("Either " + ConstantFieldsFirst.class.getSimpleName() + " or " + ConstantFieldsFirstExcept.class.getSimpleName() + " can be annotated to a function, not both.");
        }
        if (constantSet2 != null && notConstantSet2 != null) {
            throw new InvalidProgramException("Either " + ConstantFieldsSecond.class.getSimpleName() + " or " + ConstantFieldsSecondExcept.class.getSimpleName() + " can be annotated to a function, not both.");
        }
        HashSet<Annotation> result = null;
        if (notConstantSet2 != null) {
            result = new HashSet<Annotation>();
            result.add(notConstantSet2);
        }
        if (constantSet2 != null) {
            result = new HashSet();
            result.add(constantSet2);
        }
        if (readfieldSet2 != null) {
            if (result == null) {
                result = new HashSet();
            }
            result.add(readfieldSet2);
        }
        if (notConstantSet1 != null) {
            if (result == null) {
                result = new HashSet();
            }
            result.add(notConstantSet1);
        }
        if (constantSet1 != null) {
            if (result == null) {
                result = new HashSet();
            }
            result.add(constantSet1);
        }
        if (readfieldSet1 != null) {
            if (result == null) {
                result = new HashSet();
            }
            result.add(readfieldSet1);
        }
        return result;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ReadFieldsFirst {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ReadFieldsSecond {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ReadFields {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConstantFieldsSecondExcept {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConstantFieldsFirstExcept {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConstantFieldsExcept {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConstantFieldsSecond {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConstantFieldsFirst {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConstantFields {
        public String[] value();
    }
}

