/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.flink.api.common.io.GenericCsvInputFormat;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.com.google.common.base.Charsets;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.types.parser.FieldParser;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvInputFormat<OUT extends Tuple>
extends GenericCsvInputFormat<OUT> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CsvInputFormat.class);
    public static final String DEFAULT_LINE_DELIMITER = "\n";
    public static final char DEFAULT_FIELD_DELIMITER = ',';
    private transient Object[] parsedValues;
    private byte[] commentPrefix = null;
    private boolean lineDelimiterIsLinebreak = false;
    private transient int commentCount;
    private transient int invalidLineCount;

    public CsvInputFormat(Path filePath) {
        super(filePath);
    }

    public CsvInputFormat(Path filePath, Class<?> ... types) {
        this(filePath, DEFAULT_LINE_DELIMITER, ',', types);
    }

    public CsvInputFormat(Path filePath, String lineDelimiter, char fieldDelimiter, Class<?> ... types) {
        super(filePath);
        this.setDelimiter(lineDelimiter);
        this.setFieldDelimiter(fieldDelimiter);
        this.setFieldTypes(types);
    }

    public byte[] getCommentPrefix() {
        return this.commentPrefix;
    }

    public void setCommentPrefix(byte[] commentPrefix) {
        this.commentPrefix = commentPrefix;
    }

    public void setCommentPrefix(char commentPrefix) {
        this.setCommentPrefix(String.valueOf(commentPrefix));
    }

    public void setCommentPrefix(String commentPrefix) {
        this.setCommentPrefix(commentPrefix, Charsets.UTF_8);
    }

    public void setCommentPrefix(String commentPrefix, String charsetName) throws IllegalCharsetNameException, UnsupportedCharsetException {
        if (charsetName == null) {
            throw new IllegalArgumentException("Charset name must not be null");
        }
        if (commentPrefix != null) {
            Charset charset = Charset.forName(charsetName);
            this.setCommentPrefix(commentPrefix, charset);
        } else {
            this.commentPrefix = null;
        }
    }

    public void setCommentPrefix(String commentPrefix, Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("Charset must not be null");
        }
        this.commentPrefix = (byte[])(commentPrefix != null ? commentPrefix.getBytes(charset) : null);
    }

    public void setFieldTypes(Class<?> ... fieldTypes) {
        if (fieldTypes == null || fieldTypes.length == 0) {
            throw new IllegalArgumentException("Field types must not be null or empty.");
        }
        this.setFieldTypesGeneric(fieldTypes);
    }

    public void setFields(int[] sourceFieldIndices, Class<?>[] fieldTypes) {
        Preconditions.checkNotNull((Object)sourceFieldIndices);
        Preconditions.checkNotNull(fieldTypes);
        CsvInputFormat.checkForMonotonousOrder(sourceFieldIndices, fieldTypes);
        this.setFieldsGeneric(sourceFieldIndices, fieldTypes);
    }

    public void setFields(boolean[] sourceFieldMask, Class<?>[] fieldTypes) {
        Preconditions.checkNotNull((Object)sourceFieldMask);
        Preconditions.checkNotNull(fieldTypes);
        this.setFieldsGeneric(sourceFieldMask, fieldTypes);
    }

    public Class<?>[] getFieldTypes() {
        return super.getGenericFieldTypes();
    }

    public void open(FileInputSplit split) throws IOException {
        super.open(split);
        FieldParser[] fieldParsers = this.getFieldParsers();
        if (fieldParsers.length == 0) {
            throw new IOException("CsvInputFormat.open(FileInputSplit split) - no field parsers to parse input");
        }
        this.parsedValues = new Object[fieldParsers.length];
        for (int i = 0; i < fieldParsers.length; ++i) {
            this.parsedValues[i] = fieldParsers[i].createValue();
        }
        if (this.getDelimiter().length == 1 && this.getDelimiter()[0] == 10) {
            this.lineDelimiterIsLinebreak = true;
        }
        this.commentCount = 0;
        this.invalidLineCount = 0;
    }

    public void close() throws IOException {
        if (this.invalidLineCount > 0 && LOG.isWarnEnabled()) {
            LOG.warn("In file \"" + this.filePath + "\" (split start: " + this.splitStart + ") " + this.invalidLineCount + " invalid line(s) were skipped.");
        }
        if (this.commentCount > 0 && LOG.isInfoEnabled()) {
            LOG.info("In file \"" + this.filePath + "\" (split start: " + this.splitStart + ") " + this.commentCount + " comment line(s) were skipped.");
        }
        super.close();
    }

    public OUT nextRecord(OUT record) throws IOException {
        Tuple returnRecord = null;
        while ((returnRecord = (Tuple)super.nextRecord(record)) == null && !this.reachedEnd()) {
        }
        return (OUT)returnRecord;
    }

    public OUT readRecord(OUT reuse, byte[] bytes, int offset, int numBytes) throws IOException {
        if (this.lineDelimiterIsLinebreak && numBytes > 0 && bytes[offset + numBytes - 1] == 13) {
            --numBytes;
        }
        if (this.commentPrefix != null && this.commentPrefix.length <= numBytes) {
            boolean isComment = true;
            for (int i = 0; i < this.commentPrefix.length; ++i) {
                if (this.commentPrefix[i] == bytes[offset + i]) continue;
                isComment = false;
                break;
            }
            if (isComment) {
                ++this.commentCount;
                return null;
            }
        }
        if (this.parseRecord(this.parsedValues, bytes, offset, numBytes)) {
            for (int i = 0; i < this.parsedValues.length; ++i) {
                ((Tuple)reuse).setField((Object)this.parsedValues[i], i);
            }
            return reuse;
        }
        ++this.invalidLineCount;
        return null;
    }

    public String toString() {
        return "CSV Input (" + StringUtils.showControlCharacters((String)String.valueOf(this.getFieldDelimiter())) + ") " + this.getFilePath();
    }

    private static void checkAndCoSort(int[] positions, Class<?>[] types) {
        int i;
        if (positions.length != types.length) {
            throw new IllegalArgumentException("The positions and types must be of the same length");
        }
        TreeMap map = new TreeMap();
        for (i = 0; i < positions.length; ++i) {
            if (positions[i] < 0) {
                throw new IllegalArgumentException("The field  (" + positions[i] + ") is invalid.");
            }
            if (types[i] == null) {
                throw new IllegalArgumentException("The type " + i + " is invalid (null)");
            }
            if (map.containsKey(positions[i])) {
                throw new IllegalArgumentException("The position " + positions[i] + " occurs multiple times.");
            }
            map.put(positions[i], types[i]);
        }
        i = 0;
        for (Map.Entry entry : map.entrySet()) {
            positions[i] = (Integer)entry.getKey();
            types[i] = (Class)entry.getValue();
            ++i;
        }
    }

    private static void checkForMonotonousOrder(int[] positions, Class<?>[] types) {
        if (positions.length != types.length) {
            throw new IllegalArgumentException("The positions and types must be of the same length");
        }
        int lastPos = -1;
        for (int i = 0; i < positions.length; ++i) {
            if (positions[i] < 0) {
                throw new IllegalArgumentException("The field  (" + positions[i] + ") is invalid.");
            }
            if (types[i] == null) {
                throw new IllegalArgumentException("The type " + i + " is invalid (null)");
            }
            if (positions[i] <= lastPos) {
                throw new IllegalArgumentException("The positions must be strictly increasing (no permutations are supported).");
            }
            lastPos = positions[i];
        }
    }
}

